/*
 * Decompiled with CFR 0.152.
 */
package li.cil.manual.client;

import li.cil.manual.api.ManualModel;
import li.cil.manual.api.ManualScreenStyle;
import li.cil.manual.api.ManualStyle;
import li.cil.manual.api.Tab;
import li.cil.manual.api.provider.DocumentProvider;
import li.cil.manual.api.provider.PathProvider;
import li.cil.manual.api.provider.RendererProvider;
import li.cil.manual.api.util.Constants;
import li.cil.manual.api.util.ShowManualScreenEvent;
import li.cil.manual.client.gui.ManualScreen;
import li.cil.manual.client.provider.BlockRendererProvider;
import li.cil.manual.client.provider.ItemRendererProvider;
import li.cil.manual.client.provider.TagRendererProvider;
import li.cil.manual.client.provider.TextureRendererProvider;
import li.cil.manual.client.util.RegistryUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;

@OnlyIn(value=Dist.CLIENT)
public final class ClientSetup {
    public static void initialize() {
        RegistryUtils.begin("markdown_manual");
        DeferredRegister<Tab> tabs = RegistryUtils.create(Tab.class);
        DeferredRegister<PathProvider> pathProviders = RegistryUtils.create(PathProvider.class);
        DeferredRegister<DocumentProvider> documentProviders = RegistryUtils.create(DocumentProvider.class);
        DeferredRegister<RendererProvider> rendererProviders = RegistryUtils.create(RendererProvider.class);
        DeferredRegister<ManualModel> manuals = RegistryUtils.create(ManualModel.class);
        ClientSetup.makeClientOnlyRegistry(pathProviders, Constants.PATH_PROVIDERS);
        ClientSetup.makeClientOnlyRegistry(documentProviders, Constants.DOCUMENT_PROVIDERS);
        ClientSetup.makeClientOnlyRegistry(rendererProviders, Constants.RENDERER_PROVIDERS);
        ClientSetup.makeClientOnlyRegistry(tabs, Constants.TABS);
        ClientSetup.makeClientOnlyRegistry(manuals, Constants.MANUALS);
        rendererProviders.register("texture", TextureRendererProvider::new);
        rendererProviders.register("item", ItemRendererProvider::new);
        rendererProviders.register("block", BlockRendererProvider::new);
        rendererProviders.register("tag", TagRendererProvider::new);
        RegistryUtils.finish();
        MinecraftForge.EVENT_BUS.addListener(ClientSetup::handleShowManualScreen);
    }

    private static void handleShowManualScreen(ShowManualScreenEvent event) {
        ManualModel model = event.getManualModel();
        ManualStyle manualStyle = event.getManualStyle().orElse(ManualStyle.DEFAULT);
        ManualScreenStyle screenStyle = event.getScreenStyle().orElse(ManualScreenStyle.DEFAULT);
        ManualScreen screen = new ManualScreen(model, manualStyle, screenStyle);
        Minecraft.func_71410_x().func_147108_a((Screen)screen);
    }

    private static <T extends IForgeRegistryEntry<T>> void makeClientOnlyRegistry(DeferredRegister<T> deferredRegister, RegistryKey<Registry<T>> key) {
        deferredRegister.makeRegistry(key.func_240901_a_().func_110623_a(), () -> new RegistryBuilder().disableSync().disableSaving());
    }
}

