/*
 * Decompiled with CFR 0.152.
 */
package li.cil.manual.client.document.segment;

import li.cil.manual.client.document.DocumentRenderer;
import li.cil.manual.client.document.segment.Segment;
import li.cil.manual.client.document.segment.TextSegment;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.StringUtils;

@OnlyIn(value=Dist.CLIENT)
public final class HeaderSegment
extends TextSegment {
    private final int level;
    private final float fontScale;

    public HeaderSegment(DocumentRenderer document, Segment parent, String text, int level) {
        super(document, parent, text);
        this.level = level;
        this.fontScale = Math.max(1.0f, 1.75f - (float)level * 0.25f);
    }

    @Override
    public String toString() {
        return String.format("%s %s", StringUtils.repeat((char)'#', (int)this.level), super.toString());
    }

    @Override
    protected float getScale() {
        return this.fontScale * super.getScale();
    }

    @Override
    protected String getFormat() {
        return super.getFormat() + TextFormatting.UNDERLINE;
    }

    @Override
    protected int getLineHeight() {
        return (int)(1.4f * (float)super.getLineHeight());
    }
}

