/*
 * Decompiled with CFR 0.152.
 */
package li.cil.manual.client.document.segment;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Optional;
import li.cil.manual.api.render.ContentRenderer;
import li.cil.manual.api.render.InteractiveContentRenderer;
import li.cil.manual.api.util.PathUtils;
import li.cil.manual.client.document.DocumentRenderTypes;
import li.cil.manual.client.document.DocumentRenderer;
import li.cil.manual.client.document.Strings;
import li.cil.manual.client.document.segment.AbstractSegment;
import li.cil.manual.client.document.segment.InteractiveSegment;
import li.cil.manual.client.document.segment.NextSegmentInfo;
import li.cil.manual.client.document.segment.Segment;
import li.cil.manual.client.document.segment.render.MissingContentRenderer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class RenderSegment
extends AbstractSegment
implements InteractiveSegment {
    private final ITextComponent title;
    private final ContentRenderer renderer;

    public RenderSegment(DocumentRenderer document, Segment parent, String title, String url) {
        super(document, parent);
        this.title = new StringTextComponent(title);
        String path = url.contains(":") ? url : (document.getLocation() != null ? PathUtils.resolve(document.getLocation().toString(), url) : url);
        Optional<ContentRenderer> renderer = this.model.imageFor(path);
        this.renderer = renderer.orElseGet(() -> new MissingContentRenderer(Strings.getMissingContentText(url)));
    }

    @Override
    public Optional<ITextComponent> getTooltip() {
        if (this.renderer instanceof InteractiveContentRenderer) {
            return Optional.of(((InteractiveContentRenderer)this.renderer).getTooltip(this.title));
        }
        return Optional.of(this.title);
    }

    @Override
    public boolean mouseClicked() {
        return this.renderer instanceof InteractiveContentRenderer && ((InteractiveContentRenderer)this.renderer).mouseClicked();
    }

    @Override
    public int getLineHeight(int segmentX, int documentWidth) {
        return this.imageHeight(segmentX, documentWidth);
    }

    @Override
    public Optional<InteractiveSegment> render(MatrixStack matrixStack, int segmentX, int lineHeight, int documentWidth, int mouseX, int mouseY) {
        boolean isHovered;
        int width = this.imageWidth(segmentX, documentWidth);
        int height = this.imageHeight(segmentX, documentWidth);
        boolean wrapBefore = segmentX >= documentWidth;
        boolean centerAndWrapAfter = segmentX == 0 || wrapBefore;
        int x = centerAndWrapAfter ? (documentWidth - width) / 2 : segmentX;
        int y = wrapBefore ? lineHeight : 0;
        float scale = this.scale(segmentX, documentWidth);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)x, (double)y, 0.0);
        matrixStack.func_227862_a_(scale, scale, scale);
        boolean bl = isHovered = mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
        if (isHovered) {
            DocumentRenderTypes.draw(DocumentRenderTypes.highlight(), buffer -> {
                Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
                float r = 0.2f;
                float g = 0.4f;
                float b = 0.6f;
                float a = 0.25f;
                buffer.func_227888_a_(matrix, 0.0f, (float)this.renderer.getHeight(), 0.0f).func_227885_a_(0.2f, 0.4f, 0.6f, 0.25f).func_181675_d();
                buffer.func_227888_a_(matrix, (float)this.renderer.getWidth(), (float)this.renderer.getHeight(), 0.0f).func_227885_a_(0.2f, 0.4f, 0.6f, 0.25f).func_181675_d();
                buffer.func_227888_a_(matrix, (float)this.renderer.getWidth(), 0.0f, 0.0f).func_227885_a_(0.2f, 0.4f, 0.6f, 0.25f).func_181675_d();
                buffer.func_227888_a_(matrix, 0.0f, 0.0f, 0.0f).func_227885_a_(0.2f, 0.4f, 0.6f, 0.25f).func_181675_d();
            });
        }
        this.renderer.render(matrixStack, mouseX, mouseY);
        matrixStack.func_227865_b_();
        return isHovered ? Optional.of(this) : Optional.empty();
    }

    @Override
    public NextSegmentInfo getNext(int segmentX, int lineHeight, int documentWidth) {
        int width = this.imageWidth(segmentX, documentWidth);
        int height = this.imageHeight(segmentX, documentWidth);
        boolean wrapBefore = segmentX >= documentWidth;
        boolean centerAndWrapAfter = segmentX == 0 || wrapBefore;
        int localX = centerAndWrapAfter ? (documentWidth - width) / 2 : segmentX;
        int localY = wrapBefore ? lineHeight : 0;
        int absoluteX = centerAndWrapAfter ? 0 : localX + width;
        int relativeY = localY + (centerAndWrapAfter ? height + 1 : 0);
        return new NextSegmentInfo(this.next, absoluteX, relativeY);
    }

    public String toString() {
        return String.format("![%s](%s)", this.title, this.renderer);
    }

    private int imageWidth(int segmentX, int documentWidth) {
        if (segmentX >= documentWidth) {
            return Math.min(documentWidth, this.renderer.getWidth());
        }
        return Math.min(documentWidth - segmentX, this.renderer.getWidth());
    }

    private int imageHeight(int segmentX, int documentWidth) {
        return MathHelper.func_76123_f((float)((float)this.renderer.getHeight() * this.scale(segmentX, documentWidth)));
    }

    private float scale(int segmentX, int documentWidth) {
        return Math.min(1.0f, (float)this.imageWidth(segmentX, documentWidth) / (float)this.renderer.getWidth());
    }
}

