/*
 * Decompiled with CFR 0.152.
 */
package li.cil.manual.client.document.segment;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import li.cil.manual.api.render.FontRenderer;
import li.cil.manual.client.document.DocumentRenderer;
import li.cil.manual.client.document.segment.AbstractSegment;
import li.cil.manual.client.document.segment.InteractiveSegment;
import li.cil.manual.client.document.segment.NextSegmentInfo;
import li.cil.manual.client.document.segment.Segment;
import li.cil.manual.client.document.segment.SegmentRefiner;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.ArrayUtils;

@OnlyIn(value=Dist.CLIENT)
public class TextSegment
extends AbstractSegment {
    private static final char[] BREAKS = new char[]{' ', '.', ',', ':', ';', '!', '?', '_', '=', '-', '+', '*', '/', '\\'};
    private static final CharSequence[] LISTS = new CharSequence[]{"- ", "* "};
    private final String text;
    private final List<TextBlock> blockCache = new ArrayList<TextBlock>();
    private CacheKey blockCacheKey;
    private NextSegmentInfo nextCache;
    private CacheKey nextCacheKey;

    public TextSegment(DocumentRenderer document, @Nullable Segment parent, String text) {
        super(document, parent);
        this.text = text;
    }

    @Override
    public int getLineHeight(int indent, int documentWidth) {
        return this.getLineHeight();
    }

    @Override
    public NextSegmentInfo getNext(int segmentX, int lineHeight, int documentWidth) {
        CacheKey cacheKey = new CacheKey(segmentX, lineHeight, documentWidth);
        if (!Objects.equals(cacheKey, this.nextCacheKey)) {
            this.nextCache = new NextSegmentInfo(this.next);
            this.forEachBlock(segmentX, lineHeight, documentWidth, block -> {
                this.nextCache.absoluteX = block.x + this.getStringWidth(block.chars);
                this.nextCache.relativeY = block.y;
            });
            if (this.next != null && this.next.getLineRoot() != this.getLineRoot()) {
                this.nextCache.absoluteX = 0;
                this.nextCache.relativeY = this.nextCache.relativeY == 0 ? Math.max(lineHeight, this.getLineHeight()) : (this.nextCache.relativeY += this.getLineHeight());
            }
            this.nextCacheKey = cacheKey;
        }
        return this.nextCache;
    }

    @Override
    public Optional<InteractiveSegment> render(MatrixStack matrixStack, int segmentX, int lineHeight, int documentWidth, int mouseX, int mouseY) {
        String format = this.getFormat();
        float scale = this.getFontScale() * this.getScale();
        int color = this.getColor();
        Optional<InteractiveSegment> interactive = this.getInteractiveParent();
        ObjectReference hovered = new ObjectReference(Optional.empty());
        BufferBuilder builder = Tessellator.func_178181_a().func_178180_c();
        IRenderTypeBuffer.Impl bufferSource = IRenderTypeBuffer.func_228455_a_((BufferBuilder)builder);
        this.forEachBlock(segmentX, lineHeight, documentWidth, block -> {
            int blockWidth = this.getStringWidth(block.chars);
            int blockHeight = this.getLineHeight();
            if (!((Optional)hovered.value).isPresent() && mouseX >= block.x && mouseX <= block.x + blockWidth && mouseY >= block.y && mouseY <= block.y + blockHeight) {
                hovered.value = interactive;
            }
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)block.x, (double)block.y, 0.0);
            matrixStack.func_227862_a_(scale, scale, scale);
            this.getFont().drawBatch(matrixStack, (IRenderTypeBuffer)bufferSource, format + block.chars, color);
            matrixStack.func_227865_b_();
        });
        bufferSource.func_228461_a_();
        return (Optional)hovered.value;
    }

    @Override
    public Iterable<Segment> refine(Pattern pattern, SegmentRefiner factory) {
        ArrayList<Segment> result = new ArrayList<Segment>();
        int textStart = 0;
        Matcher matcher = pattern.matcher(this.text);
        while (matcher.find()) {
            if (matcher.start() > textStart) {
                result.add(new TextSegment(this.document, this, this.text.substring(textStart, matcher.start())));
            }
            textStart = matcher.end();
            result.add(factory.refine(this.document, this, matcher));
        }
        if (textStart == 0) {
            result.add(this);
        } else if (textStart < this.text.length()) {
            result.add(new TextSegment(this.document, this, this.text.substring(textStart)));
        }
        return result;
    }

    public String toString() {
        return this.text;
    }

    protected boolean isIgnoringLeadingWhitespace() {
        return true;
    }

    protected FontRenderer getFont() {
        return this.style.getRegularFont();
    }

    protected int getColor() {
        return this.tryGetFromParent(this.style.getRegularTextColor(), TextSegment::getColor);
    }

    protected float getScale() {
        return this.tryGetFromParent(Float.valueOf(1.0f), TextSegment::getScale).floatValue();
    }

    protected String getFormat() {
        return this.tryGetFromParent("", TextSegment::getFormat);
    }

    protected int getLineHeight() {
        return (int)((float)(this.getFont().lineHeight() + 1) * this.getFontScale() * this.getScale());
    }

    private float getFontScale() {
        return (float)this.style.getLineHeight() / (float)this.getFont().lineHeight();
    }

    private int getStringWidth(CharSequence string) {
        return (int)((float)this.getFont().width(this.getFormat() + string) * this.getFontScale() * this.getScale());
    }

    private void forEachBlock(int segmentX, int lineHeight, int documentWidth, Consumer<TextBlock> blockConsumer) {
        CacheKey cacheKey = new CacheKey(segmentX, lineHeight, documentWidth);
        if (!Objects.equals(cacheKey, this.blockCacheKey)) {
            this.blockCache.clear();
            String chars = this.text;
            if (this.isIgnoringLeadingWhitespace() && segmentX == 0) {
                chars = chars.substring(TextSegment.indexOfFirstNonWhitespace(chars));
            }
            int wrappedIndent = this.computeWrappedIndent();
            int currentX = segmentX;
            int currentY = 0;
            int charCount = this.computeCharsFittingOnLine(chars, documentWidth - currentX, documentWidth - wrappedIndent);
            while (chars.length() > 0) {
                String blockChars = chars.substring(0, charCount);
                this.blockCache.add(new TextBlock(currentX, currentY, blockChars));
                currentX = wrappedIndent;
                currentY = currentY == 0 ? Math.max(lineHeight, this.getLineHeight()) : (currentY += this.getLineHeight());
                chars = chars.substring(charCount);
                chars = chars.substring(TextSegment.indexOfFirstNonWhitespace(chars));
                charCount = this.computeCharsFittingOnLine(chars, documentWidth - currentX, documentWidth - wrappedIndent);
            }
            this.blockCacheKey = cacheKey;
        }
        for (TextBlock block : this.blockCache) {
            blockConsumer.accept(block);
        }
    }

    private static int indexOfFirstNonWhitespace(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return i;
        }
        return s.length();
    }

    private int computeCharsFittingOnLine(String string, int remainingLineWidth, int documentWidth) {
        int count;
        int fullWidth = this.getStringWidth(string);
        int lastBreak = -1;
        for (count = 0; count < string.length(); ++count) {
            boolean exceedsLineLength;
            int nextLargerWidth = this.getStringWidth(string.substring(0, count + 1));
            boolean bl = exceedsLineLength = nextLargerWidth >= remainingLineWidth;
            if (exceedsLineLength) {
                boolean matchesFullLine;
                boolean mayUseFullLine = remainingLineWidth == documentWidth;
                boolean canFitInLine = fullWidth <= documentWidth;
                boolean bl2 = matchesFullLine = fullWidth == documentWidth;
                if (lastBreak >= 0) {
                    return lastBreak + 1;
                }
                if (mayUseFullLine && matchesFullLine) {
                    return string.length();
                }
                if (canFitInLine && !mayUseFullLine) {
                    return 0;
                }
                return count;
            }
            if (!ArrayUtils.contains((char[])BREAKS, (char)string.charAt(count))) continue;
            lastBreak = count;
        }
        return count;
    }

    private <T> T tryGetFromParent(T defaultValue, Function<TextSegment, T> getter) {
        Optional parent = this.getParent();
        if (parent.isPresent() && parent.get() instanceof TextSegment) {
            return getter.apply((TextSegment)parent.get());
        }
        return defaultValue;
    }

    private Optional<InteractiveSegment> getInteractiveParent() {
        Optional<Segment> segment = Optional.of(this);
        while (segment.isPresent()) {
            if (segment.get() instanceof InteractiveSegment) {
                return segment.map(s -> (InteractiveSegment)s);
            }
            segment = ((Segment)segment.get()).getParent();
        }
        return Optional.empty();
    }

    private TextSegment getRootTextSegment() {
        TextSegment textSegment = this;
        Optional<Segment> parent = this.getParent();
        while (parent.isPresent() && parent.get() instanceof TextSegment) {
            textSegment = (TextSegment)parent.get();
            parent = ((Segment)parent.get()).getParent();
        }
        return textSegment;
    }

    private int computeWrappedIndent() {
        TextSegment textSegment = this.getRootTextSegment();
        CharSequence rootPrefix = textSegment.text.subSequence(0, Math.min(2, textSegment.text.length()));
        return ArrayUtils.contains((Object[])LISTS, (Object)rootPrefix) ? this.getFont().width(rootPrefix) : 0;
    }

    private static final class TextBlock {
        public final int x;
        public final int y;
        public final String chars;

        public TextBlock(int x, int y, String chars) {
            this.x = x;
            this.y = y;
            this.chars = chars;
        }
    }

    private static final class CacheKey {
        private final int segmentX;
        private final int lineHeight;
        private final int documentWidth;

        public CacheKey(int segmentX, int lineHeight, int documentWidth) {
            this.segmentX = segmentX;
            this.lineHeight = lineHeight;
            this.documentWidth = documentWidth;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey that = (CacheKey)o;
            return this.segmentX == that.segmentX && this.lineHeight == that.lineHeight && this.documentWidth == that.documentWidth;
        }

        public int hashCode() {
            return Objects.hash(this.segmentX, this.lineHeight, this.documentWidth);
        }
    }

    private static final class ObjectReference<T> {
        public T value;

        public ObjectReference(T value) {
            this.value = value;
        }
    }
}

