/*
 * Decompiled with CFR 0.152.
 */
package li.cil.manual.client.document.segment.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.io.IOException;
import li.cil.manual.api.render.ContentRenderer;
import li.cil.manual.client.document.DocumentRenderTypes;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TextureContentRenderer
implements ContentRenderer {
    private final ResourceLocation location;
    private final ImageTexture texture;

    public TextureContentRenderer(ResourceLocation location) {
        this.location = location;
        TextureManager manager = Minecraft.func_71410_x().func_110434_K();
        Texture image = manager.func_229267_b_(location);
        if (image instanceof ImageTexture) {
            this.texture = (ImageTexture)image;
        } else {
            this.texture = new ImageTexture(location);
            manager.func_229263_a_(location, (Texture)this.texture);
            if (!this.texture.isValid) {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public int getWidth() {
        return this.texture.width;
    }

    @Override
    public int getHeight() {
        return this.texture.height;
    }

    @Override
    public void render(MatrixStack matrixStack, int mouseX, int mouseY) {
        DocumentRenderTypes.draw(DocumentRenderTypes.texture(this.location), buffer -> {
            Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
            buffer.func_227888_a_(matrix, 0.0f, (float)this.texture.height, 0.0f).func_225583_a_(0.0f, 1.0f).func_181675_d();
            buffer.func_227888_a_(matrix, (float)this.texture.width, (float)this.texture.height, 0.0f).func_225583_a_(1.0f, 1.0f).func_181675_d();
            buffer.func_227888_a_(matrix, (float)this.texture.width, 0.0f, 0.0f).func_225583_a_(1.0f, 0.0f).func_181675_d();
            buffer.func_227888_a_(matrix, 0.0f, 0.0f, 0.0f).func_225583_a_(0.0f, 0.0f).func_181675_d();
        });
    }

    private static class ImageTexture
    extends SimpleTexture {
        private int width = 0;
        private int height = 0;
        private boolean isValid;

        ImageTexture(ResourceLocation location) {
            super(location);
        }

        public void func_195413_a(IResourceManager manager) throws IOException {
            super.func_195413_a(manager);
            try (SimpleTexture.TextureData textureData = this.func_215246_b(manager);){
                NativeImage nativeImage = textureData.func_217800_b();
                this.width = nativeImage.func_195702_a();
                this.height = nativeImage.func_195714_b();
                this.isValid = true;
            }
        }
    }
}

