/*
 * Decompiled with CFR 0.152.
 */
package li.cil.manual.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import li.cil.manual.api.ManualModel;
import li.cil.manual.api.ManualScreenStyle;
import li.cil.manual.api.ManualStyle;
import li.cil.manual.api.Tab;
import li.cil.manual.api.content.Document;
import li.cil.manual.client.document.DocumentRenderer;
import li.cil.manual.client.document.segment.InteractiveSegment;
import li.cil.manual.client.util.IterableUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class ManualScreen
extends Screen {
    private final ManualModel model;
    private final ManualStyle manualStyle;
    private final ManualScreenStyle screenStyle;
    private final DocumentRenderer documentRenderer;
    private String currentPath;
    private int leftPos = 0;
    private int topPos = 0;
    private float scrollPos = 0.0f;
    private boolean isDragging = false;
    private int documentHeight = 0;
    private Optional<InteractiveSegment> currentSegment = Optional.empty();
    private ScrollButton scrollButton = null;

    public ManualScreen(ManualModel model, ManualStyle manualStyle, ManualScreenStyle screenStyle) {
        super((ITextComponent)new StringTextComponent("Manual"));
        this.model = model;
        this.manualStyle = manualStyle;
        this.screenStyle = screenStyle;
        this.documentRenderer = new DocumentRenderer(model, manualStyle);
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.leftPos = (this.field_230708_k_ - this.screenStyle.getWindowRect().func_199316_c()) / 2 + this.screenStyle.getWindowRect().func_199318_a();
        this.topPos = (this.field_230709_l_ - this.screenStyle.getWindowRect().func_199317_d()) / 2 + this.screenStyle.getWindowRect().func_199319_b();
        IterableUtils.forEachWithIndex(this.model.getTabs(), (i, tab) -> {
            int x = this.screenStyle.getTabAreaRect().func_199318_a();
            int y = this.screenStyle.getTabAreaRect().func_199319_b() + i * this.getTabClickableHeight();
            if (y + this.screenStyle.getTabRect().func_199317_d() > this.screenStyle.getTabAreaRect().func_199317_d()) {
                return;
            }
            this.func_230480_a_((Widget)new TabButton(this.leftPos + x, this.topPos + y, (Tab)tab, button -> this.pushManualPage((Tab)tab)));
        });
        this.scrollButton = (ScrollButton)this.func_230480_a_((Widget)new ScrollButton(this.leftPos + this.screenStyle.getScrollBarRect().func_199318_a() + this.screenStyle.getScrollButtonRect().func_199318_a(), this.topPos + this.screenStyle.getScrollBarRect().func_199319_b() + this.screenStyle.getScrollButtonRect().func_199319_b(), this.screenStyle.getScrollButtonRect().func_199316_c(), this.screenStyle.getScrollButtonRect().func_199317_d()));
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        if (!Objects.equals(this.currentPath, this.model.peek())) {
            this.refreshPage();
            this.currentPath = this.model.peek();
            SoundHandler soundHandler = Minecraft.func_71410_x().func_147118_V();
            soundHandler.func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)this.manualStyle.getPageChangeSound(), (float)1.0f));
        }
        this.scrollPos = MathHelper.func_219799_g((float)(partialTicks * 0.5f), (float)this.scrollPos, (float)this.getScrollPosition());
        RenderSystem.enableBlend();
        this.scrollButton.field_230693_o_ = false;
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.getMinecraft().func_110434_K().func_110577_a(this.screenStyle.getWindowBackground());
        Rectangle2d windowRect = this.screenStyle.getWindowRect();
        ManualScreen.func_238463_a_((MatrixStack)matrixStack, (int)this.leftPos, (int)this.topPos, (float)0.0f, (float)0.0f, (int)windowRect.func_199316_c(), (int)windowRect.func_199317_d(), (int)windowRect.func_199316_c(), (int)windowRect.func_199317_d());
        this.scrollButton.field_230693_o_ = this.canScroll();
        this.scrollButton.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        Rectangle2d documentRect = this.screenStyle.getDocumentRect();
        int documentX = this.leftPos + documentRect.func_199318_a();
        int documentY = this.topPos + documentRect.func_199319_b();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)documentX, (double)documentY, 0.0);
        this.currentSegment = this.documentRenderer.render(matrixStack, this.getSmoothScrollPosition(), documentRect.func_199316_c(), documentRect.func_199317_d(), mouseX - documentX, mouseY - documentY);
        matrixStack.func_227865_b_();
        this.currentSegment.flatMap(InteractiveSegment::getTooltip).ifPresent(t -> this.renderWrappedToolTip(matrixStack, Collections.singletonList(t), mouseX, mouseY, this.getFontRenderer()));
        for (Widget widget : this.field_230710_m_) {
            if (!widget.field_230693_o_ || this.isDragging && !(widget instanceof ScrollButton)) continue;
            widget.func_230443_a_(matrixStack, mouseX, mouseY);
        }
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double delta) {
        if (super.func_231043_a_(mouseX, mouseY, delta)) {
            return true;
        }
        this.scrollBy(delta);
        return true;
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (this.getMinecraft().field_71474_y.field_74314_A.func_197976_a(keyCode, scanCode)) {
            this.popManualPage();
            return true;
        }
        if (this.getMinecraft().field_71474_y.field_151445_Q.func_197976_a(keyCode, scanCode)) {
            ClientPlayerEntity player = this.getMinecraft().field_71439_g;
            if (player != null) {
                player.func_71053_j();
            }
            return true;
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (super.func_231044_a_(mouseX, mouseY, button)) {
            return true;
        }
        if (this.canScroll() && button == 0 && this.isCoordinateOverScrollBar(mouseX, mouseY)) {
            this.isDragging = true;
            this.scrollButton.func_230988_a_(Minecraft.func_71410_x().func_147118_V());
            this.scrollTo(mouseY);
            return true;
        }
        if (button == 0) {
            return this.currentSegment.map(InteractiveSegment::mouseClicked).orElse(false);
        }
        if (button == 1) {
            this.popManualPage();
            return true;
        }
        return false;
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (super.func_231045_a_(mouseX, mouseY, button, dragX, dragY)) {
            return true;
        }
        if (this.isDragging) {
            this.scrollTo(mouseY);
            return true;
        }
        return false;
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        super.func_231048_c_(mouseX, mouseY, button);
        if (button == 0) {
            this.isDragging = false;
        }
        return true;
    }

    public boolean func_231177_au__() {
        return false;
    }

    private void pushManualPage(Tab tab) {
        this.model.push(tab.getPath());
    }

    private void popManualPage() {
        if (!this.model.pop()) {
            this.func_231175_as__();
        }
    }

    private FontRenderer getFontRenderer() {
        return this.field_230712_o_;
    }

    private boolean canScroll() {
        return this.maxScrollPosition() > 0;
    }

    private int getScrollPosition() {
        return this.model.getUserData(ScrollOffset.class).map(offset -> offset.value).orElse(0);
    }

    private void setScrollPosition(int value) {
        this.model.setUserData(new ScrollOffset(value));
    }

    private int maxScrollPosition() {
        return Math.max(0, this.documentHeight - this.screenStyle.getDocumentRect().func_199317_d());
    }

    private void refreshPage() {
        Optional<Document> document = this.model.documentFor(this.model.peek());
        this.documentRenderer.parse(document.orElse(new Document(Collections.singletonList("Page not found: " + this.model.peek()))));
        this.documentHeight = this.documentRenderer.height(this.screenStyle.getDocumentRect().func_199316_c());
        this.scrollPos = this.getScrollPosition() - this.manualStyle.getLineHeight() * 3;
    }

    private void scrollTo(double mouseY) {
        int scrollButtonHeight = this.screenStyle.getScrollButtonRect().func_199317_d();
        int halfScrollButtonHeight = (int)Math.ceil((double)scrollButtonHeight * 0.5);
        int scrollMinY = this.topPos + this.screenStyle.getScrollBarRect().func_199319_b() + halfScrollButtonHeight;
        int scrollHeight = this.screenStyle.getScrollBarRect().func_199317_d() - scrollButtonHeight;
        int localMouseY = (int)(mouseY - (double)scrollMinY);
        this.scrollTo(this.maxScrollPosition() * localMouseY / scrollHeight, true);
    }

    private void scrollBy(double amount) {
        this.scrollTo(this.getScrollPosition() - (int)Math.round((double)(this.manualStyle.getLineHeight() * 3) * amount), false);
    }

    private void scrollTo(int y, boolean immediate) {
        this.setScrollPosition(Math.max(0, Math.min(this.maxScrollPosition(), y)));
        if (immediate) {
            this.scrollPos = this.getScrollPosition();
        }
    }

    private int getSmoothScrollPosition() {
        if (this.scrollPos < (float)this.getScrollPosition()) {
            return (int)Math.ceil(this.scrollPos);
        }
        return (int)Math.floor(this.scrollPos);
    }

    private int getScrollButtonY() {
        if (this.maxScrollPosition() > 0) {
            int yMax = this.screenStyle.getScrollBarRect().func_199317_d() - this.screenStyle.getScrollButtonRect().func_199317_d();
            return Math.max(0, Math.min(yMax, yMax * this.getSmoothScrollPosition() / this.maxScrollPosition()));
        }
        return 0;
    }

    private boolean isCoordinateOverScrollBar(double x, double y) {
        return this.screenStyle.getScrollBarRect().func_199315_b((int)(x - (double)this.leftPos), (int)(y - (double)this.topPos));
    }

    private int getTabClickableHeight() {
        return this.screenStyle.getTabRect().func_199317_d() - this.screenStyle.getTabOverlap();
    }

    private class ScrollButton
    extends Button {
        private static final int TOOLTIP_HEIGHT = 18;
        private final int baseY;

        ScrollButton(int x, int y, int w, int h) {
            super(x, y, w, h, StringTextComponent.field_240750_d_, button -> {});
            this.baseY = y;
        }

        protected boolean func_230992_c_(double mouseX, double mouseY) {
            if (super.func_230992_c_(mouseX, mouseY)) {
                this.func_230988_a_(Minecraft.func_71410_x().func_147118_V());
            }
            return false;
        }

        public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            this.field_230691_m_ = this.baseY + ManualScreen.this.getScrollButtonY();
            int x0 = this.field_230690_l_;
            int x1 = x0 + this.field_230688_j_;
            int y0 = this.field_230691_m_;
            int y1 = y0 + this.field_230689_k_;
            float u0 = 0.0f;
            float u1 = 1.0f;
            float v0 = ManualScreen.this.isDragging || this.func_230449_g_() ? 0.5f : 0.0f;
            float v1 = v0 + 0.5f;
            ManualScreen.this.getMinecraft().func_110434_K().func_110577_a(ManualScreen.this.screenStyle.getScrollButtonTexture());
            Tessellator t = Tessellator.func_178181_a();
            BufferBuilder builder = t.func_178180_c();
            builder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            builder.func_225582_a_((double)x0, (double)y1, (double)this.func_230927_p_()).func_225583_a_(0.0f, v1).func_181675_d();
            builder.func_225582_a_((double)x1, (double)y1, (double)this.func_230927_p_()).func_225583_a_(1.0f, v1).func_181675_d();
            builder.func_225582_a_((double)x1, (double)y0, (double)this.func_230927_p_()).func_225583_a_(1.0f, v0).func_181675_d();
            builder.func_225582_a_((double)x0, (double)y0, (double)this.func_230927_p_()).func_225583_a_(0.0f, v0).func_181675_d();
            t.func_78381_a();
        }

        public void func_230443_a_(MatrixStack matrixStack, int mouseX, int mouseY) {
            if (!(ManualScreen.this.isDragging || this.func_230449_g_() || ManualScreen.this.isCoordinateOverScrollBar(mouseX, mouseY))) {
                return;
            }
            ManualScreen.this.func_238652_a_(matrixStack, (ITextComponent)new StringTextComponent(100 * ManualScreen.this.getScrollPosition() / ManualScreen.this.maxScrollPosition() + "%"), ManualScreen.this.leftPos + ManualScreen.this.screenStyle.getScrollBarRect().func_199318_a() + ManualScreen.this.screenStyle.getScrollBarRect().func_199316_c(), this.field_230691_m_ + (this.func_238483_d_() + 18) / 2);
        }
    }

    private class TabButton
    extends Button {
        private final Tab tab;
        private final int baseX;
        private float currentX;
        private int targetX;

        TabButton(int x, int y, Tab tab, Button.IPressable action) {
            super(x, y, ManualScreen.this.screenStyle.getTabRect().func_199316_c(), ManualScreen.this.getTabClickableHeight(), StringTextComponent.field_240750_d_, action);
            this.tab = tab;
            this.baseX = x;
            this.currentX = x + ManualScreen.this.screenStyle.getTabHoverShift();
            this.targetX = (int)this.currentX;
        }

        public void func_230443_a_(MatrixStack matrixStack, int mouseX, int mouseY) {
            if (!this.func_230449_g_()) {
                return;
            }
            ArrayList<ITextComponent> tooltip = new ArrayList<ITextComponent>();
            this.tab.getTooltip(tooltip);
            if (!tooltip.isEmpty()) {
                ManualScreen.this.renderWrappedToolTip(matrixStack, tooltip, mouseX, mouseY, ManualScreen.this.getFontRenderer());
            }
        }

        public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            this.targetX = this.func_230449_g_() ? this.baseX : this.baseX + ManualScreen.this.screenStyle.getTabHoverShift();
            this.currentX = MathHelper.func_219799_g((float)(partialTicks * 0.5f), (float)this.currentX, (float)this.targetX);
            this.field_230690_l_ = this.currentX < (float)this.targetX ? (int)Math.ceil(this.currentX) : (int)Math.floor(this.currentX);
            this.field_230688_j_ = ManualScreen.this.screenStyle.getTabAreaRect().func_199316_c() - (this.field_230690_l_ - this.baseX);
            int v0 = this.func_230449_g_() ? ManualScreen.this.screenStyle.getTabRect().func_199317_d() : 0;
            int visualWidth = ManualScreen.this.screenStyle.getTabRect().func_199316_c();
            int visualHeight = ManualScreen.this.screenStyle.getTabRect().func_199317_d();
            int textureWidth = ManualScreen.this.screenStyle.getTabRect().func_199316_c();
            int textureHeight = ManualScreen.this.screenStyle.getTabRect().func_199317_d() * 2;
            ManualScreen.this.getMinecraft().func_110434_K().func_110577_a(ManualScreen.this.screenStyle.getTabButtonTexture());
            TabButton.func_238463_a_((MatrixStack)matrixStack, (int)this.field_230690_l_, (int)this.field_230691_m_, (float)0.0f, (float)v0, (int)visualWidth, (int)visualHeight, (int)textureWidth, (int)textureHeight);
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)(this.field_230690_l_ + 12), (double)(this.field_230691_m_ + (ManualScreen.this.screenStyle.getTabRect().func_199317_d() - 18) / 2), 0.0);
            this.tab.renderIcon(matrixStack);
            matrixStack.func_227865_b_();
        }

        public void func_230988_a_(SoundHandler soundHandler) {
        }
    }

    private static final class ScrollOffset {
        public final int value;

        public ScrollOffset(int value) {
            this.value = value;
        }
    }
}

