/*
 * Decompiled with CFR 0.152.
 */
package li.cil.manual.client.provider;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import li.cil.manual.api.ManualModel;
import li.cil.manual.api.prefab.provider.AbstractRendererProvider;
import li.cil.manual.api.render.ContentRenderer;
import li.cil.manual.client.document.Strings;
import li.cil.manual.client.document.segment.render.ItemStackContentRenderer;
import li.cil.manual.client.document.segment.render.MissingContentRenderer;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.command.arguments.BlockStateParser;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public final class BlockRendererProvider
extends AbstractRendererProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<String, BlockState> BLOCK_STATE_CACHE = new HashMap<String, BlockState>();

    public BlockRendererProvider() {
        super("block");
    }

    @Override
    public boolean matches(ManualModel manual) {
        return true;
    }

    @Override
    protected Optional<ContentRenderer> doGetRenderer(String data) {
        BlockState state = Objects.requireNonNull(BLOCK_STATE_CACHE.computeIfAbsent(data, string -> {
            try {
                return new BlockStateParser(new StringReader(string), false).func_197243_a(false).func_197249_b();
            }
            catch (CommandSyntaxException e) {
                LOGGER.error("Failed parsing block state.", (Throwable)e);
                return Blocks.field_150350_a.func_176223_P();
            }
        }));
        if (state.func_177230_c() != Blocks.field_150350_a) {
            return Optional.of(new ItemStackContentRenderer(new ItemStack((IItemProvider)state.func_177230_c())));
        }
        return Optional.of(new MissingContentRenderer(Strings.NO_SUCH_BLOCK));
    }
}

