/*
 * Decompiled with CFR 0.152.
 */
package al132.chemlib.items;

import al132.chemlib.Utils;
import al132.chemlib.capability.CapabilityDrugInfo;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;

public class DankMolecule {
    public Item item;
    public int duration;
    public int amplifier;
    public List<Effect> effects;
    public Consumer<PlayerEntity> entityEffects;
    public static HashMap<Item, DankMolecule> dankMolecules = new HashMap();

    public DankMolecule(Item item, int duration, int amplifier, List<Effect> effects, Consumer<PlayerEntity> entityEffects) {
        this.item = item;
        this.duration = duration;
        this.amplifier = amplifier;
        this.effects = effects;
        this.entityEffects = entityEffects;
    }

    public void activateForPlayer(PlayerEntity player) {
        for (Effect effect : this.effects) {
            this.effects.forEach(x -> player.func_195064_c(new EffectInstance(effect, this.duration, this.amplifier)));
        }
        if (this.entityEffects != null) {
            this.entityEffects.accept(player);
        }
    }

    public static void init() {
        Utils.getChemItem("compound_potassium_cyanide").ifPresent(item -> dankMolecules.put((Item)item, new DankMolecule((Item)item, 500, 2, Lists.newArrayList((Object[])new Effect[]{Effects.field_82731_v, Effects.field_76436_u, Effects.field_76431_k, Effects.field_76421_d, Effects.field_76438_s}), player -> {
            player.func_71024_bL().func_75114_a(0);
            player.func_70097_a(DamageSource.field_76366_f, 16.0f);
        })));
        Utils.getChemItem("compound_psilocybin").ifPresent(item -> dankMolecules.put((Item)item, new DankMolecule((Item)item, 600, 2, Lists.newArrayList((Object[])new Effect[]{Effects.field_76439_r, Effects.field_188423_x, Effects.field_76421_d}), player -> player.getCapability(CapabilityDrugInfo.DRUG_INFO).ifPresent(data -> {
            data.psilocybinTicks = 1100;
        }))));
        Utils.getChemItem("compound_penicillin").ifPresent(item -> dankMolecules.put((Item)item, new DankMolecule((Item)item, 0, 0, Lists.newArrayList(), player -> {
            player.func_195061_cb();
            player.func_70691_i(2.0f);
        })));
        Utils.getChemItem("compound_epinephrine").ifPresent(item -> dankMolecules.put((Item)item, new DankMolecule((Item)item, 200, 0, Lists.newArrayList((Object[])new Effect[]{Effects.field_76430_j, Effects.field_76424_c, Effects.field_76422_e}), p -> {})));
        Utils.getChemItem("compound_cocaine").ifPresent(item -> dankMolecules.put((Item)item, new DankMolecule((Item)item, 400, 2, Lists.newArrayList((Object[])new Effect[]{Effects.field_76439_r, Effects.field_76424_c, Effects.field_76422_e, Effects.field_76430_j}), p -> {})));
        Utils.getChemItem("compound_acetylsalicylic_acid").ifPresent(item -> dankMolecules.put((Item)item, new DankMolecule((Item)item, 0, 0, Lists.newArrayList(), player -> player.func_70691_i(5.0f))));
        Utils.getChemItem("compound_caffeine").ifPresent(item -> dankMolecules.put((Item)item, new DankMolecule((Item)item, 400, 0, Lists.newArrayList((Object[])new Effect[]{Effects.field_76439_r, Effects.field_76424_c, Effects.field_76422_e}), p -> {})));
    }

    public static boolean hasDankMolecule(ItemStack stack) {
        return dankMolecules.containsKey(stack.func_77973_b());
    }

    public static Optional<DankMolecule> getDankMolecule(ItemStack stack) {
        return Optional.ofNullable(dankMolecules.get(stack.func_77973_b()));
    }
}

