/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.api.bus.device.object;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import li.cil.oc2.api.bus.device.object.Callback;
import li.cil.oc2.api.bus.device.object.DocumentedDevice;
import li.cil.oc2.api.bus.device.object.Parameter;
import li.cil.oc2.api.bus.device.rpc.AbstractRPCMethod;
import li.cil.oc2.api.bus.device.rpc.RPCMethod;
import li.cil.oc2.api.bus.device.rpc.RPCParameter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Strings;

public final class Callbacks {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final HashMap<Class<?>, List<Method>> METHOD_BY_TYPE = new HashMap();
    private static final HashMap<Method, RPCParameter[]> PARAMETERS_BY_METHOD = new HashMap();
    private static final HashMap<Method, CallbackDocumentation> DOCUMENTATION_BY_METHOD = new HashMap();

    public static List<RPCMethod> collectMethods(Object methodContainer) {
        List<Method> reflectedMethods = Callbacks.getMethods(methodContainer.getClass());
        ArrayList<RPCMethod> methods = new ArrayList<RPCMethod>();
        for (Method method : reflectedMethods) {
            try {
                methods.add(new ObjectRPCMethod(methodContainer, method));
            }
            catch (IllegalAccessException e) {
                LOGGER.error("Failed accessing method [{}].", (Object)method);
            }
        }
        return methods;
    }

    public static boolean hasMethods(Object object) {
        if (object instanceof Class) {
            return !Callbacks.getMethods((Class)object).isEmpty();
        }
        return !Callbacks.getMethods(object.getClass()).isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Method> getMethods(Class<?> type) {
        HashMap<Class<?>, List<Method>> hashMap = METHOD_BY_TYPE;
        synchronized (hashMap) {
            return METHOD_BY_TYPE.computeIfAbsent(type, c -> Arrays.stream(c.getMethods()).filter(m -> m.isAnnotationPresent(Callback.class)).collect(Collectors.toList()));
        }
    }

    private static final class CallbackVisitorImpl
    implements DocumentedDevice.CallbackVisitor {
        public String description;
        public String returnValueDescription;
        public final HashMap<String, String> parameterDescriptions = new HashMap();

        private CallbackVisitorImpl() {
        }

        @Override
        public DocumentedDevice.CallbackVisitor description(String value) {
            this.description = value;
            return this;
        }

        @Override
        public DocumentedDevice.CallbackVisitor returnValueDescription(String value) {
            this.returnValueDescription = value;
            return this;
        }

        @Override
        public DocumentedDevice.CallbackVisitor parameterDescription(String parameterName, String value) {
            this.parameterDescriptions.put(parameterName, value);
            return this;
        }
    }

    private static final class DeviceVisitorImpl
    implements DocumentedDevice.DeviceVisitor {
        public final HashMap<String, CallbackVisitorImpl> callbacks = new HashMap();

        private DeviceVisitorImpl() {
        }

        @Override
        public DocumentedDevice.CallbackVisitor visitCallback(String callbackName) {
            return this.callbacks.computeIfAbsent(callbackName, unused -> new CallbackVisitorImpl());
        }
    }

    private static final class CallbackDocumentation {
        @Nullable
        public final String description;
        @Nullable
        public final String returnValueDescription;
        public final HashMap<String, String> parameterDescriptions;

        private CallbackDocumentation(@Nullable String description, @Nullable String returnValueDescription, HashMap<String, String> parameterDescriptions) {
            this.description = description;
            this.returnValueDescription = returnValueDescription;
            this.parameterDescriptions = parameterDescriptions;
        }
    }

    private static final class ObjectRPCMethod
    extends AbstractRPCMethod {
        private final MethodHandle handle;
        private final String description;
        private final String returnValueDescription;

        public ObjectRPCMethod(Object target, Method method) throws IllegalAccessException {
            this(new ConstructorData(target, method));
        }

        private ObjectRPCMethod(ConstructorData data) throws IllegalAccessException {
            super(data.methodName, data.annotation.synchronize(), data.method.getReturnType(), data.parameters);
            this.handle = MethodHandles.lookup().unreflect(data.method).bindTo(data.target);
            this.description = data.description;
            this.returnValueDescription = data.returnValueDescription;
        }

        @Override
        @Nullable
        public Object invoke(Object ... parameters) throws Throwable {
            return this.handle.invokeWithArguments(parameters);
        }

        @Override
        public Optional<String> getDescription() {
            return Optional.ofNullable(this.description);
        }

        @Override
        public Optional<String> getReturnValueDescription() {
            return Optional.ofNullable(this.returnValueDescription);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ObjectRPCMethod that = (ObjectRPCMethod)o;
            return this.handle.equals(that.handle);
        }

        public int hashCode() {
            return Objects.hash(this.handle);
        }

        public String toString() {
            return this.handle.toString();
        }

        private static final class ReflectionParameter
        implements RPCParameter {
            private final Class<?> type;
            @Nullable
            private final String name;
            @Nullable
            private final String description;

            public ReflectionParameter(java.lang.reflect.Parameter parameter, HashMap<String, String> parameterDescriptions) {
                this.type = parameter.getType();
                Parameter annotation = parameter.getAnnotation(Parameter.class);
                boolean hasName = annotation != null && Strings.isNotBlank((String)annotation.value());
                boolean hasDescription = annotation != null && Strings.isNotBlank((String)annotation.description());
                String string = this.name = hasName ? annotation.value() : null;
                this.description = parameterDescriptions.containsKey(this.name) ? parameterDescriptions.get(this.name) : (hasDescription ? annotation.description() : null);
            }

            @Override
            public Class<?> getType() {
                return this.type;
            }

            @Override
            public Optional<String> getName() {
                return Optional.ofNullable(this.name);
            }

            @Override
            public Optional<String> getDescription() {
                return Optional.ofNullable(this.description);
            }
        }

        private static final class ConstructorData {
            public final Object target;
            public final Method method;
            public final Callback annotation;
            public final String methodName;
            public final String description;
            public final String returnValueDescription;
            public final RPCParameter[] parameters;

            public ConstructorData(Object target, Method method) {
                this.target = target;
                this.method = method;
                this.annotation = Objects.requireNonNull(method.getAnnotation(Callback.class), "Method without Callback annotation.");
                this.methodName = Strings.isNotBlank((String)this.annotation.name()) ? this.annotation.name() : method.getName();
                CallbackDocumentation documentation = DOCUMENTATION_BY_METHOD.computeIfAbsent(method, m -> {
                    boolean hasDescription = Strings.isNotBlank((String)this.annotation.description());
                    boolean hasReturnValueDescription = Strings.isNotBlank((String)this.annotation.returnValueDescription());
                    String description = hasDescription ? this.annotation.description() : null;
                    String returnValueDescription = hasReturnValueDescription ? this.annotation.returnValueDescription() : null;
                    HashMap<String, String> parameterDescriptions = new HashMap<String, String>();
                    if (target instanceof DocumentedDevice) {
                        DocumentedDevice documentedDevice = (DocumentedDevice)target;
                        DeviceVisitorImpl visitor = new DeviceVisitorImpl();
                        documentedDevice.getDeviceDocumentation(visitor);
                        CallbackVisitorImpl callbackVisitor = visitor.callbacks.get(this.methodName);
                        if (callbackVisitor != null) {
                            if (Strings.isNotBlank((String)callbackVisitor.description)) {
                                description = callbackVisitor.description;
                            }
                            if (Strings.isNotBlank((String)callbackVisitor.returnValueDescription)) {
                                returnValueDescription = callbackVisitor.description;
                            }
                            parameterDescriptions.putAll(callbackVisitor.parameterDescriptions);
                        }
                    }
                    return new CallbackDocumentation(description, returnValueDescription, parameterDescriptions);
                });
                this.description = documentation.description;
                this.returnValueDescription = documentation.returnValueDescription;
                this.parameters = PARAMETERS_BY_METHOD.computeIfAbsent(method, m -> (RPCParameter[])Arrays.stream(m.getParameters()).map(parameter -> new ReflectionParameter((java.lang.reflect.Parameter)parameter, documentation.parameterDescriptions)).toArray(RPCParameter[]::new));
            }
        }
    }
}

