/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.api.bus.device.object;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import li.cil.oc2.api.bus.device.object.Callbacks;
import li.cil.oc2.api.bus.device.object.NamedDevice;
import li.cil.oc2.api.bus.device.rpc.RPCDevice;
import li.cil.oc2.api.bus.device.rpc.RPCMethod;

public final class ObjectDevice
implements RPCDevice {
    private final Object object;
    private final ArrayList<String> typeNames;
    private final List<RPCMethod> methods;
    private final String className;

    public ObjectDevice(Object object, List<String> typeNames) {
        this.object = object;
        this.typeNames = new ArrayList<String>(typeNames);
        this.methods = Callbacks.collectMethods(object);
        this.className = object.getClass().getSimpleName();
        if (object instanceof NamedDevice) {
            NamedDevice namedDevice = (NamedDevice)object;
            this.typeNames.addAll(namedDevice.getDeviceTypeNames());
        }
    }

    public ObjectDevice(Object object, String ... typeNames) {
        this(object, Arrays.asList(typeNames));
    }

    public ObjectDevice(Object object, @Nullable String typeName) {
        this(object, typeName != null ? Collections.singletonList(typeName) : Collections.emptyList());
    }

    public ObjectDevice(Object object) {
        this(object, Collections.emptyList());
    }

    @Override
    public List<String> getTypeNames() {
        return this.typeNames;
    }

    @Override
    public List<RPCMethod> getMethods() {
        return this.methods;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectDevice that = (ObjectDevice)o;
        return this.object.equals(that.object);
    }

    public int hashCode() {
        return this.object.hashCode();
    }

    public String toString() {
        return this.className;
    }
}

