/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.client;

import java.util.Objects;
import li.cil.oc2.api.bus.device.DeviceType;
import li.cil.oc2.client.gui.ComputerContainerScreen;
import li.cil.oc2.client.gui.ComputerTerminalScreen;
import li.cil.oc2.client.gui.RobotContainerScreen;
import li.cil.oc2.client.gui.RobotTerminalScreen;
import li.cil.oc2.client.item.CustomItemColors;
import li.cil.oc2.client.item.CustomItemModelProperties;
import li.cil.oc2.client.model.BusCableModelLoader;
import li.cil.oc2.client.renderer.BusInterfaceNameRenderer;
import li.cil.oc2.client.renderer.NetworkCableRenderer;
import li.cil.oc2.client.renderer.color.BusCableBlockColor;
import li.cil.oc2.client.renderer.entity.RobotEntityRenderer;
import li.cil.oc2.client.renderer.tileentity.ChargerTileEntityRenderer;
import li.cil.oc2.client.renderer.tileentity.ComputerTileEntityRenderer;
import li.cil.oc2.client.renderer.tileentity.DiskDriveTileEntityRenderer;
import li.cil.oc2.client.renderer.tileentity.NetworkConnectorTileEntityRenderer;
import li.cil.oc2.common.block.Blocks;
import li.cil.oc2.common.bus.device.DeviceTypes;
import li.cil.oc2.common.container.Containers;
import li.cil.oc2.common.entity.Entities;
import li.cil.oc2.common.tileentity.TileEntities;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.entity.EntityType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

public final class ClientSetup {
    @SubscribeEvent
    public static void handleSetupEvent(FMLClientSetupEvent event) {
        NetworkCableRenderer.initialize();
        BusInterfaceNameRenderer.initialize();
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)TileEntities.COMPUTER_TILE_ENTITY.get()), ComputerTileEntityRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)TileEntities.NETWORK_CONNECTOR_TILE_ENTITY.get()), NetworkConnectorTileEntityRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)TileEntities.DISK_DRIVE_TILE_ENTITY.get()), DiskDriveTileEntityRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)TileEntities.CHARGER_TILE_ENTITY.get()), ChargerTileEntityRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)Entities.ROBOT.get()), RobotEntityRenderer::new);
        event.enqueueWork(() -> {
            CustomItemModelProperties.initialize();
            CustomItemColors.initialize();
            ScreenManager.func_216911_a((ContainerType)((ContainerType)Containers.COMPUTER.get()), ComputerContainerScreen::new);
            ScreenManager.func_216911_a((ContainerType)((ContainerType)Containers.COMPUTER_TERMINAL.get()), ComputerTerminalScreen::new);
            ScreenManager.func_216911_a((ContainerType)((ContainerType)Containers.ROBOT.get()), RobotContainerScreen::new);
            ScreenManager.func_216911_a((ContainerType)((ContainerType)Containers.ROBOT_TERMINAL.get()), RobotTerminalScreen::new);
            RenderTypeLookup.setRenderLayer((Block)((Block)Blocks.BUS_CABLE.get()), RenderType2 -> true);
            ((Minecraft)event.getMinecraftSupplier().get()).func_184125_al().func_186722_a((IBlockColor)new BusCableBlockColor(), new Block[]{(Block)Blocks.BUS_CABLE.get()});
        });
    }

    @SubscribeEvent
    public static void handleModelRegistryEvent(ModelRegistryEvent event) {
        ModelLoaderRegistry.registerLoader((ResourceLocation)Blocks.BUS_CABLE.getId(), (IModelLoader)new BusCableModelLoader());
    }

    @SubscribeEvent
    public static void handleTextureStitchEvent(TextureStitchEvent.Pre event) {
        if (!Objects.equals(event.getMap().func_229223_g_(), PlayerContainer.field_226615_c_)) {
            return;
        }
        for (DeviceType deviceType : DeviceTypes.DEVICE_TYPE_REGISTRY.get().getValues()) {
            event.addSprite(deviceType.getBackgroundIcon());
        }
        event.addSprite(ComputerTileEntityRenderer.OVERLAY_POWER_LOCATION);
        event.addSprite(ComputerTileEntityRenderer.OVERLAY_STATUS_LOCATION);
        event.addSprite(ComputerTileEntityRenderer.OVERLAY_TERMINAL_LOCATION);
        event.addSprite(ChargerTileEntityRenderer.EFFECT_LOCATION);
    }
}

