/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.List;
import li.cil.oc2.client.gui.AbstractContainerScreen;
import li.cil.oc2.client.gui.MachineTerminalWidget;
import li.cil.oc2.client.gui.Sprites;
import li.cil.oc2.client.gui.widget.ImageButton;
import li.cil.oc2.client.gui.widget.ToggleImageButton;
import li.cil.oc2.common.Constants;
import li.cil.oc2.common.container.AbstractMachineTerminalContainer;
import li.cil.oc2.common.util.TooltipUtils;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.client.gui.GuiUtils;

public abstract class AbstractMachineTerminalScreen<T extends AbstractMachineTerminalContainer>
extends AbstractContainerScreen<T> {
    private static final int CONTROLS_TOP = 8;
    private static final int ENERGY_TOP = 8 + Sprites.SIDEBAR_3.height + 4;
    private static boolean isInputCaptureEnabled;
    private final MachineTerminalWidget terminalWidget = new MachineTerminalWidget(this);

    protected AbstractMachineTerminalScreen(T container, PlayerInventory playerInventory, ITextComponent title) {
        super(container, playerInventory, title);
        this.field_146999_f = Sprites.TERMINAL_SCREEN.width;
        this.field_147000_g = Sprites.TERMINAL_SCREEN.height;
    }

    public static boolean isInputCaptureEnabled() {
        return isInputCaptureEnabled;
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.terminalWidget.render(matrixStack, mouseX, mouseY, ((AbstractMachineTerminalContainer)this.field_147002_h).getVirtualMachine().getBootError());
        int energyCapacity = ((AbstractMachineTerminalContainer)this.field_147002_h).getEnergyCapacity();
        if (energyCapacity > 0) {
            int energyStored = ((AbstractMachineTerminalContainer)this.field_147002_h).getEnergy();
            int energyConsumption = ((AbstractMachineTerminalContainer)this.field_147002_h).getEnergyConsumption();
            Sprites.ENERGY_BAR.drawFillY(matrixStack, this.field_147003_i - Sprites.SIDEBAR_2.width + 4, this.field_147009_r + ENERGY_TOP + 4, (float)energyStored / (float)energyCapacity);
            if (this.isMouseOver(mouseX, mouseY, -Sprites.SIDEBAR_2.width + 4, ENERGY_TOP + 4, Sprites.ENERGY_BAR.width, Sprites.ENERGY_BAR.height)) {
                List<TranslationTextComponent> tooltip = Arrays.asList(new TranslationTextComponent(Constants.TOOLTIP_ENERGY, new Object[]{TooltipUtils.withColor(energyStored + "/" + energyCapacity, TextFormatting.GREEN)}), new TranslationTextComponent(Constants.TOOLTIP_ENERGY_CONSUMPTION, new Object[]{TooltipUtils.withColor(String.valueOf(energyConsumption), TextFormatting.GREEN)}));
                GuiUtils.drawHoveringText((MatrixStack)matrixStack, tooltip, (int)mouseX, (int)mouseY, (int)this.field_230708_k_, (int)this.field_230709_l_, (int)200, (FontRenderer)this.field_230712_o_);
            }
        }
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        this.terminalWidget.tick();
    }

    public boolean func_231042_a_(char ch, int modifiers) {
        return this.terminalWidget.charTyped(ch, modifiers) || super.func_231042_a_(ch, modifiers);
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (this.terminalWidget.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        InputMappings.Input input = InputMappings.func_197954_a((int)keyCode, (int)scanCode);
        if (this.field_230706_i_.field_71474_y.field_151445_Q.isActiveAndMatches(input)) {
            return true;
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.terminalWidget.init();
        this.func_230480_a_((Widget)new ToggleImageButton((Screen)this, this.field_147003_i - Sprites.SIDEBAR_3.width + 4, this.field_147009_r + 8 + 4, 12, 12, (ITextComponent)new TranslationTextComponent(Constants.COMPUTER_SCREEN_POWER_CAPTION), (ITextComponent)new TranslationTextComponent(Constants.COMPUTER_SCREEN_POWER_DESCRIPTION), Sprites.POWER_BUTTON_BASE, Sprites.POWER_BUTTON_PRESSED, Sprites.POWER_BUTTON_ACTIVE){

            @Override
            public void func_230930_b_() {
                super.func_230930_b_();
                ((AbstractMachineTerminalContainer)AbstractMachineTerminalScreen.this.field_147002_h).sendPowerStateToServer(!((AbstractMachineTerminalContainer)AbstractMachineTerminalScreen.this.field_147002_h).getVirtualMachine().isRunning());
            }

            @Override
            public boolean isToggled() {
                return ((AbstractMachineTerminalContainer)AbstractMachineTerminalScreen.this.field_147002_h).getVirtualMachine().isRunning();
            }
        });
        this.func_230480_a_((Widget)new ToggleImageButton((Screen)this, this.field_147003_i - Sprites.SIDEBAR_3.width + 4, this.field_147009_r + 8 + 4 + 14, 12, 12, (ITextComponent)new TranslationTextComponent(Constants.TERMINAL_CAPTURE_INPUT_CAPTION), (ITextComponent)new TranslationTextComponent(Constants.TERMINAL_CAPTURE_INPUT_DESCRIPTION), Sprites.INPUT_BUTTON_BASE, Sprites.INPUT_BUTTON_PRESSED, Sprites.INPUT_BUTTON_ACTIVE){

            @Override
            public void func_230930_b_() {
                super.func_230930_b_();
                isInputCaptureEnabled = !isInputCaptureEnabled;
            }

            @Override
            public boolean isToggled() {
                return isInputCaptureEnabled;
            }
        });
        this.func_230480_a_((Widget)new ImageButton((Screen)this, this.field_147003_i - Sprites.SIDEBAR_3.width + 4, this.field_147009_r + 8 + 4 + 14 + 14, 12, 12, (ITextComponent)new TranslationTextComponent(Constants.MACHINE_OPEN_INVENTORY_CAPTION), null, Sprites.INVENTORY_BUTTON_INACTIVE, Sprites.INVENTORY_BUTTON_ACTIVE){

            @Override
            public void func_230930_b_() {
                ((AbstractMachineTerminalContainer)AbstractMachineTerminalScreen.this.field_147002_h).switchToInventory();
            }
        });
    }

    public void func_231175_as__() {
        super.func_231175_as__();
        this.terminalWidget.onClose();
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Sprites.SIDEBAR_3.draw(matrixStack, this.field_147003_i - Sprites.SIDEBAR_2.width, this.field_147009_r + 8);
        if (((AbstractMachineTerminalContainer)this.field_147002_h).getEnergyCapacity() > 0) {
            int x = this.field_147003_i - Sprites.SIDEBAR_2.width;
            int y = this.field_147009_r + ENERGY_TOP;
            Sprites.SIDEBAR_2.draw(matrixStack, x, y);
            Sprites.ENERGY_BASE.draw(matrixStack, x + 4, y + 4);
        }
        this.terminalWidget.renderBackground(matrixStack, mouseX, mouseY);
    }

    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
    }
}

