/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import li.cil.oc2.common.util.TranslationUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public final class FileChooserScreen
extends Screen {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int MARGIN = 30;
    private static final int WIDGET_SPACING = 8;
    private static final int TEXT_FIELD_HEIGHT = 20;
    private static final int BUTTON_HEIGHT = 20;
    private static final int LIST_ENTRY_HEIGHT = 12;
    private static final ITextComponent OPEN_TITLE_TEXT = TranslationUtils.text("gui.{mod}.file_chooser.title.load");
    private static final ITextComponent SAVE_TITLE_TEXT = TranslationUtils.text("gui.{mod}.file_chooser.title.save");
    private static final ITextComponent FILE_NAME_TEXT = TranslationUtils.text("gui.{mod}.file_chooser.text_field.filename");
    private static final ITextComponent LOAD_TEXT = TranslationUtils.text("gui.{mod}.file_chooser.confirm_button.load");
    private static final ITextComponent SAVE_TEXT = TranslationUtils.text("gui.{mod}.file_chooser.confirm_button.save");
    private static final ITextComponent OVERWRITE_TEXT = TranslationUtils.text("gui.{mod}.file_chooser.confirm_button.overwrite");
    private static final ITextComponent CANCEL_TEXT = TranslationUtils.text("gui.{mod}.file_chooser.cancel_button");
    private static Path directory = Paths.get("", new String[0]).toAbsolutePath();
    private final FileChooserCallback callback;
    private final boolean isLoad;
    private final Screen previousScreen;
    private FileList fileList;
    private TextFieldWidget fileNameTextField;
    private Button okButton;
    private boolean isComplete;

    public static void openFileChooserForSave(String name, FileChooserCallback callback) {
        Screen currentScreen = Minecraft.func_71410_x().field_71462_r;
        if (currentScreen instanceof FileChooserScreen) {
            currentScreen.func_231175_as__();
        }
        FileChooserScreen screen = new FileChooserScreen(callback, false);
        Minecraft.func_71410_x().func_147108_a((Screen)screen);
        screen.fileNameTextField.func_146180_a(name);
    }

    public static void openFileChooserForLoad(FileChooserCallback callback) {
        Screen currentScreen = Minecraft.func_71410_x().field_71462_r;
        if (currentScreen instanceof FileChooserScreen) {
            currentScreen.func_231175_as__();
        }
        FileChooserScreen screen = new FileChooserScreen(callback, true);
        Minecraft.func_71410_x().func_147108_a((Screen)screen);
    }

    public FileChooserScreen(FileChooserCallback callback, boolean isLoad) {
        super(isLoad ? OPEN_TITLE_TEXT : SAVE_TITLE_TEXT);
        this.callback = callback;
        this.isLoad = isLoad;
        this.previousScreen = Minecraft.func_71410_x().field_71462_r;
    }

    public void func_231175_as__() {
        if (!this.isComplete) {
            this.callback.onCanceled();
        }
        if (this.previousScreen != null) {
            this.field_230706_i_.func_212871_a_(() -> this.field_230706_i_.func_147108_a(this.previousScreen));
        }
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230446_a_(matrixStack);
        this.fileList.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.fileNameTextField.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    public boolean func_231177_au__() {
        return false;
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        int widgetsWidth = this.field_230708_k_ - 60;
        int listHeight = this.field_230709_l_ - 30 - 8 - 20 - 8 - 20 - 30;
        this.fileList = new FileList(30, listHeight, 12);
        this.func_230481_d_((IGuiEventListener)this.fileList);
        int fileNameTop = 30 + listHeight + 8;
        this.fileNameTextField = new TextFieldWidget(this.field_230712_o_, 30, fileNameTop, widgetsWidth, 20, FILE_NAME_TEXT);
        this.fileNameTextField.func_212954_a(s -> {
            this.fileList.setSelected(null);
            this.updateButtons();
        });
        this.fileNameTextField.func_146203_f(1024);
        this.func_230481_d_((IGuiEventListener)this.fileNameTextField);
        int buttonTop = fileNameTop + 20 + 8;
        int buttonCount = 2;
        int buttonWidth = widgetsWidth / 2 - 8;
        this.okButton = (Button)this.func_230480_a_((Widget)new Button(30, buttonTop, buttonWidth, 20, StringTextComponent.field_240750_d_, this::handleOkPressed));
        this.func_230480_a_((Widget)new Button(30 + buttonWidth + 8, buttonTop, buttonWidth, 20, CANCEL_TEXT, this::handleCancelPressed));
        this.fileList.refreshFiles(directory);
        this.updateButtons();
    }

    private boolean isParentPath() {
        if (directory == null) {
            return false;
        }
        FileList.FileEntry selected = (FileList.FileEntry)this.fileList.func_230958_g_();
        if (selected != null) {
            return selected.file == null || selected.file.equals(directory.getParent());
        }
        String selectedFileEntry = this.fileNameTextField.func_146179_b();
        return "..".equals(selectedFileEntry);
    }

    @Nullable
    private Optional<Path> getPath() {
        FileList.FileEntry selected = (FileList.FileEntry)this.fileList.func_230958_g_();
        if (selected != null) {
            return Optional.ofNullable(selected.file);
        }
        if (directory == null) {
            return Optional.empty();
        }
        String selectedFileEntry = this.fileNameTextField.func_146179_b();
        if (selectedFileEntry == null || "".equals(selectedFileEntry) || ".".equals(selectedFileEntry)) {
            return Optional.empty();
        }
        try {
            return Optional.of(directory.resolve(selectedFileEntry));
        }
        catch (InvalidPathException e) {
            return Optional.empty();
        }
    }

    private void confirm() {
        if (this.isParentPath()) {
            this.fileList.refreshFiles(this.getPath().orElse(null));
            this.fileNameTextField.func_146180_a("");
            return;
        }
        this.getPath().ifPresent(path -> {
            if (path == null || Files.isDirectory(path, new LinkOption[0])) {
                this.fileList.refreshFiles((Path)path);
                this.fileNameTextField.func_146180_a("");
                return;
            }
            if (Files.isRegularFile(path, new LinkOption[0])) {
                this.isComplete = true;
                this.callback.onFileSelected((Path)path);
                this.func_231175_as__();
            } else if (!this.isLoad) {
                this.isComplete = true;
                this.callback.onFileSelected((Path)path);
                this.func_231175_as__();
            }
        });
    }

    private void cancel() {
        this.isComplete = true;
        this.callback.onCanceled();
        this.func_231175_as__();
    }

    private void updateButtons() {
        this.okButton.field_230693_o_ = false;
        this.okButton.func_238482_a_(this.isLoad ? LOAD_TEXT : SAVE_TEXT);
        this.okButton.clearFGColor();
        if (this.isParentPath()) {
            this.okButton.field_230693_o_ = true;
            return;
        }
        this.getPath().ifPresent(path -> {
            if (this.isLoad) {
                this.okButton.field_230693_o_ = Files.exists(path, new LinkOption[0]);
            } else {
                this.okButton.field_230693_o_ = true;
                if (Files.isRegularFile(path, new LinkOption[0])) {
                    this.okButton.func_238482_a_(OVERWRITE_TEXT);
                    this.okButton.setFGColor(0xFF0000);
                }
            }
        });
    }

    private void handleOkPressed(Button button) {
        this.confirm();
    }

    private void handleCancelPressed(Button button) {
        this.cancel();
    }

    private final class FileList
    extends ExtendedList<FileEntry> {
        public FileList(int y, int height, int slotHeight) {
            super(FileChooserScreen.this.field_230706_i_, FileChooserScreen.this.field_230708_k_, FileChooserScreen.this.field_230709_l_, y, y + height, slotHeight);
        }

        public void refreshFiles(Path directory) {
            directory = directory;
            this.func_230932_a_(0.0);
            this.func_230963_j_();
            if (directory != null && Files.isDirectory(directory, new LinkOption[0])) {
                this.func_230513_b_((AbstractList.AbstractListEntry)this.createDirectoryEntry(directory.getParent(), ".."));
                try {
                    List files = Files.list(directory).sorted((p1, p2) -> {
                        if (Files.isDirectory(p1, new LinkOption[0]) && !Files.isDirectory(p2, new LinkOption[0])) {
                            return -1;
                        }
                        if (!Files.isDirectory(p1, new LinkOption[0]) && Files.isDirectory(p2, new LinkOption[0])) {
                            return 1;
                        }
                        return p1.getFileName().compareTo(p2.getFileName());
                    }).collect(Collectors.toList());
                    for (Path path : files) {
                        try {
                            if (Files.isHidden(path)) continue;
                            if (Files.isDirectory(path, new LinkOption[0])) {
                                this.func_230513_b_((AbstractList.AbstractListEntry)this.createDirectoryEntry(path));
                                continue;
                            }
                            this.func_230513_b_((AbstractList.AbstractListEntry)this.createFileEntry(path));
                        }
                        catch (IOException | SecurityException exception) {}
                    }
                }
                catch (IOException | SecurityException e) {
                    LOGGER.error((Object)e);
                }
            } else {
                for (Path path : FileSystems.getDefault().getRootDirectories()) {
                    this.func_230513_b_((AbstractList.AbstractListEntry)this.createDirectoryEntry(path, path.toString()));
                }
            }
        }

        public void setSelected(@Nullable FileEntry entry) {
            super.func_241215_a_((AbstractList.AbstractListEntry)entry);
            FileChooserScreen.this.updateButtons();
        }

        private FileEntry createFileEntry(Path file) {
            return new FileEntry(file, (ITextComponent)new StringTextComponent(file.getFileName().toString()));
        }

        private FileEntry createDirectoryEntry(Path path) {
            return this.createDirectoryEntry(path, path.getFileName().toString() + path.getFileSystem().getSeparator());
        }

        private FileEntry createDirectoryEntry(Path path, String displayName) {
            return new FileEntry(path, (ITextComponent)new StringTextComponent(displayName).func_240700_a_(s -> s.func_240718_a_(Color.func_240743_a_((int)0xA0A0FF))));
        }

        private final class FileEntry
        extends ExtendedList.AbstractListEntry<FileEntry> {
            private final Path file;
            private final ITextComponent displayName;
            private long lastEntryClickTime = 0L;

            public FileEntry(Path file, ITextComponent displayName) {
                this.file = file;
                this.displayName = displayName;
            }

            public void func_230432_a_(MatrixStack stack, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isHovered, float deltaTime) {
                FileChooserScreen.this.field_230712_o_.func_243246_a(stack, this.displayName, (float)left, (float)top, -1);
            }

            public boolean func_231044_a_(double mouseX, double mouseY, int button) {
                boolean isLeftClick;
                boolean bl = isLeftClick = button == 0;
                if (isLeftClick) {
                    boolean isDoubleClick;
                    if (this.file == null || directory != null && this.file.equals(directory.getParent())) {
                        FileChooserScreen.this.fileNameTextField.func_146180_a("..");
                    } else {
                        Path fileName = this.file.getFileName();
                        FileChooserScreen.this.fileNameTextField.func_146180_a(fileName != null ? fileName.toString() : this.file.toString());
                    }
                    FileChooserScreen.this.fileNameTextField.func_146196_d();
                    FileChooserScreen.this.fileNameTextField.func_146199_i(0);
                    FileList.this.setSelected(this);
                    boolean bl2 = isDoubleClick = System.currentTimeMillis() - this.lastEntryClickTime < 250L;
                    if (isDoubleClick) {
                        FileChooserScreen.this.confirm();
                    }
                    this.lastEntryClickTime = System.currentTimeMillis();
                }
                return false;
            }
        }
    }

    @FunctionalInterface
    public static interface FileChooserCallback {
        public void onFileSelected(Path var1);

        default public void onCanceled() {
        }
    }
}

