/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import li.cil.oc2.client.gui.AbstractMachineTerminalScreen;
import li.cil.oc2.client.gui.Sprites;
import li.cil.oc2.client.gui.terminal.TerminalInput;
import li.cil.oc2.common.container.AbstractMachineTerminalContainer;
import li.cil.oc2.common.vm.Terminal;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;

public final class MachineTerminalWidget
extends AbstractGui {
    public static final int TERMINAL_WIDTH = 320;
    public static final int TERMINAL_HEIGHT = 192;
    public static final int MARGIN_SIZE = 8;
    public static final int TERMINAL_X = 8;
    public static final int TERMINAL_Y = 8;
    public static final int WIDTH = Sprites.TERMINAL_SCREEN.width;
    public static final int HEIGHT = Sprites.TERMINAL_SCREEN.height;
    private final AbstractMachineTerminalScreen<?> parent;
    private final AbstractMachineTerminalContainer container;
    private final Terminal terminal;
    private int leftPos;
    private int topPos;
    private boolean isMouseOverTerminal;

    public MachineTerminalWidget(AbstractMachineTerminalScreen<?> parent) {
        this.parent = parent;
        this.container = (AbstractMachineTerminalContainer)this.parent.func_212873_a_();
        this.terminal = this.container.getTerminal();
    }

    public void renderBackground(MatrixStack matrixStack, int mouseX, int mouseY) {
        this.isMouseOverTerminal = this.isMouseOverTerminal(mouseX, mouseY);
        Sprites.TERMINAL_SCREEN.draw(matrixStack, this.leftPos, this.topPos);
        if (this.shouldCaptureInput()) {
            Sprites.TERMINAL_FOCUSED.draw(matrixStack, this.leftPos, this.topPos);
        }
    }

    public void render(MatrixStack matrixStack, int mouseX, int mouseY, @Nullable ITextComponent error) {
        if (this.container.getVirtualMachine().isRunning()) {
            MatrixStack stack = new MatrixStack();
            stack.func_227861_a_((double)(this.leftPos + 8), (double)(this.topPos + 8), (double)this.getClient().func_175599_af().field_77023_b);
            stack.func_227862_a_(320.0f / (float)this.terminal.getWidth(), 192.0f / (float)this.terminal.getHeight(), 1.0f);
            this.terminal.render(stack);
        } else {
            FontRenderer font = this.getClient().field_71466_p;
            if (error != null) {
                int textWidth = font.func_238414_a_((ITextProperties)error);
                int textOffsetX = (320 - textWidth) / 2;
                font.getClass();
                int textOffsetY = (192 - 9) / 2;
                font.func_243246_a(matrixStack, error, (float)(this.leftPos + 8 + textOffsetX), (float)(this.topPos + 8 + textOffsetY), 0xEE3322);
            }
        }
    }

    public void tick() {
        ByteBuffer input = this.terminal.getInput();
        if (input != null) {
            this.container.sendTerminalInputToServer(input);
        }
    }

    public boolean charTyped(char ch, int modifier) {
        this.terminal.putInput((byte)ch);
        return true;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        block4: {
            block3: {
                if (!this.shouldCaptureInput() && keyCode == 256) {
                    return false;
                }
                if ((modifiers & 2) == 0 || keyCode != 86) break block3;
                String value = this.getClient().field_195559_v.func_197965_a();
                for (char ch : value.toCharArray()) {
                    this.terminal.putInput((byte)ch);
                }
                break block4;
            }
            byte[] sequence = TerminalInput.getSequence(keyCode, modifiers);
            if (sequence == null) break block4;
            for (int i = 0; i < sequence.length; ++i) {
                this.terminal.putInput(sequence[i]);
            }
        }
        return true;
    }

    public void init() {
        this.leftPos = (this.parent.field_230708_k_ - WIDTH) / 2;
        this.topPos = (this.parent.field_230709_l_ - HEIGHT) / 2;
        this.getClient().field_195559_v.func_197967_a(true);
    }

    public void onClose() {
        this.getClient().field_195559_v.func_197967_a(false);
    }

    private Minecraft getClient() {
        return this.parent.getMinecraft();
    }

    private boolean shouldCaptureInput() {
        return this.isMouseOverTerminal && AbstractMachineTerminalScreen.isInputCaptureEnabled() && this.container.getVirtualMachine().isRunning();
    }

    private boolean isMouseOverTerminal(int mouseX, int mouseY) {
        return this.parent.isMouseOver(mouseX, mouseY, 8, 8, 320, 192);
    }
}

