/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.client.gui.util;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import li.cil.oc2.api.bus.device.DeviceType;
import li.cil.oc2.api.bus.device.DeviceTypes;
import li.cil.oc2.client.gui.widget.Sprite;
import li.cil.oc2.common.container.TypedSlotItemHandler;
import li.cil.oc2.common.util.TranslationUtils;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public final class GuiUtils {
    private static final Map<DeviceType, ITextComponent> WARNING_BY_DEVICE_TYPE = (Map)Util.func_199748_a(() -> {
        HashMap<DeviceType, TranslationTextComponent> map = new HashMap<DeviceType, TranslationTextComponent>();
        map.put(DeviceTypes.FLASH_MEMORY, TranslationUtils.text("tooltip.{mod}.flash_memory_missing"));
        map.put(DeviceTypes.MEMORY, TranslationUtils.text("tooltip.{mod}.memory_missing"));
        map.put(DeviceTypes.HARD_DRIVE, TranslationUtils.text("tooltip.{mod}.hard_drive_missing"));
        return map;
    });
    private static final int SLOT_SIZE = 18;
    private static final int DEVICE_INFO_ICON_SIZE = 28;
    private static final int RELATIVE_ICON_POSITION = -5;

    public static <TContainer extends Container> void renderMissingDeviceInfoIcon(MatrixStack matrixStack, ContainerScreen<TContainer> screen, DeviceType type, Sprite icon) {
        GuiUtils.findFirstSlotOfTypeIfAllSlotsOfTypeEmpty(screen.func_212873_a_(), type).ifPresent(slot -> icon.draw(matrixStack, screen.getGuiLeft() + slot.field_75223_e - 1 + -5, screen.getGuiTop() + slot.field_75221_f - 1 + -5));
    }

    public static <TContainer extends Container> void renderMissingDeviceInfoTooltip(MatrixStack matrixStack, ContainerScreen<TContainer> screen, int mouseX, int mouseY, DeviceType type) {
        GuiUtils.renderMissingDeviceInfoTooltip(matrixStack, screen, mouseX, mouseY, type, Objects.requireNonNull(WARNING_BY_DEVICE_TYPE.get(type)));
    }

    public static <TContainer extends Container> void renderMissingDeviceInfoTooltip(MatrixStack matrixStack, ContainerScreen<TContainer> screen, int mouseX, int mouseY, DeviceType type, ITextComponent tooltip) {
        boolean isCursorHoldingStack;
        boolean bl = isCursorHoldingStack = !screen.getMinecraft().field_71439_g.field_71071_by.func_70445_o().func_190926_b();
        if (isCursorHoldingStack) {
            return;
        }
        Slot hoveredSlot = screen.getSlotUnderMouse();
        if (hoveredSlot != null && hoveredSlot.func_75216_d()) {
            return;
        }
        GuiUtils.findFirstSlotOfTypeIfAllSlotsOfTypeEmpty(screen.func_212873_a_(), type).ifPresent(slot -> {
            if (slot == hoveredSlot) {
                screen.func_238652_a_(matrixStack, tooltip, mouseX, mouseY);
            }
        });
    }

    private static Optional<TypedSlotItemHandler> findFirstSlotOfTypeIfAllSlotsOfTypeEmpty(Container container, DeviceType type) {
        TypedSlotItemHandler firstSlot = null;
        for (Slot slot : container.field_75151_b) {
            TypedSlotItemHandler typedSlot;
            DeviceType slotType;
            if (!(slot instanceof TypedSlotItemHandler) || (slotType = (typedSlot = (TypedSlotItemHandler)slot).getDeviceType()) != type) continue;
            if (slot.func_75216_d()) {
                return Optional.empty();
            }
            if (firstSlot != null) continue;
            firstSlot = typedSlot;
        }
        return Optional.ofNullable(firstSlot);
    }
}

