/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.client.gui.widget;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import li.cil.oc2.client.gui.widget.Sprite;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.AbstractButton;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.gui.GuiUtils;

public abstract class ImageButton
extends AbstractButton {
    private static final long PRESS_DURATION = 200L;
    private static final long TOOLTIP_DELAY = 250L;
    private final Screen parent;
    private final List<? extends ITextComponent> tooltip;
    private final Sprite baseImage;
    private final Sprite pressedImage;
    private long lastPressedAt;
    private long hoveringStartedAt;

    public ImageButton(Screen parent, int x, int y, int width, int height, ITextComponent caption, @Nullable ITextComponent description, Sprite baseImage, Sprite pressedImage) {
        super(x, y, width, height, caption);
        this.parent = parent;
        this.tooltip = description == null ? Collections.singletonList(caption) : Arrays.asList(caption, new StringTextComponent("").func_240700_a_(style -> style.func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.GRAY))).func_230529_a_(description));
        this.baseImage = baseImage;
        this.pressedImage = pressedImage;
    }

    public void func_230930_b_() {
        this.lastPressedAt = System.currentTimeMillis();
    }

    public void func_230431_b_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        Sprite background = this.baseImage;
        if (System.currentTimeMillis() - this.lastPressedAt < 200L) {
            background = this.pressedImage;
        }
        background.draw(stack, this.field_230690_l_, this.field_230691_m_);
        if (this.func_230449_g_()) {
            if (this.hoveringStartedAt == 0L) {
                this.hoveringStartedAt = System.currentTimeMillis();
            }
            if (System.currentTimeMillis() - this.hoveringStartedAt > 250L) {
                this.func_230443_a_(stack, mouseX, mouseY);
            }
        } else {
            this.hoveringStartedAt = 0L;
        }
    }

    public void func_230443_a_(MatrixStack stack, int mouseX, int mouseY) {
        GuiUtils.drawHoveringText((MatrixStack)stack, this.tooltip, (int)mouseX, (int)mouseY, (int)this.parent.field_230708_k_, (int)this.parent.field_230709_l_, (int)200, (FontRenderer)Minecraft.func_71410_x().field_71466_p);
    }
}

