/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.client.item;

import li.cil.oc2.common.item.Items;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.item.DyeColor;
import net.minecraft.item.IDyeableArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;

public final class CustomItemColors {
    public static final int BLACK = -12566464;
    public static final int GREY = -11184811;
    public static final int LIGHT_GREY = -7763575;
    public static final int WHITE = -3487030;
    public static final int LIME = -10102229;
    public static final int GREEN = -14902223;
    public static final int CYAN = -15612483;
    public static final int BLUE = -11573528;
    public static final int LIGHT_BLUE = -15625531;
    public static final int PURPLE = -7404854;
    public static final int MAGENTA = -3796857;
    public static final int PINK = -2403907;
    public static final int ORANGE = -2260931;
    public static final int RED = -2278083;
    public static final int BROWN = -9151422;
    public static final int YELLOW = -951;
    private static final int NO_TINT = -1;

    public static void initialize() {
        ItemColors itemColors = Minecraft.func_71410_x().getItemColors();
        itemColors.func_199877_a((stack, layer) -> layer == 1 ? CustomItemColors.getColor(stack) : -1, new IItemProvider[]{(IItemProvider)Items.HARD_DRIVE_SMALL.get(), (IItemProvider)Items.HARD_DRIVE_MEDIUM.get(), (IItemProvider)Items.HARD_DRIVE_LARGE.get(), (IItemProvider)Items.HARD_DRIVE_CUSTOM.get(), (IItemProvider)Items.FLOPPY.get()});
    }

    public static int getColorByDye(DyeColor dye) {
        switch (dye) {
            case WHITE: {
                return -3487030;
            }
            case ORANGE: {
                return -2260931;
            }
            case MAGENTA: {
                return -3796857;
            }
            case LIGHT_BLUE: {
                return -15625531;
            }
            case YELLOW: {
                return -951;
            }
            case LIME: {
                return -10102229;
            }
            case PINK: {
                return -2403907;
            }
            case GRAY: {
                return -11184811;
            }
            case LIGHT_GRAY: {
                return -7763575;
            }
            case CYAN: {
                return -15612483;
            }
            case PURPLE: {
                return -7404854;
            }
            case BLUE: {
                return -11573528;
            }
            case BROWN: {
                return -9151422;
            }
            case GREEN: {
                return -14902223;
            }
            case RED: {
                return -2278083;
            }
            case BLACK: {
                return -12566464;
            }
        }
        return -11184811;
    }

    public static int getColor(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof IDyeableArmorItem) {
            IDyeableArmorItem coloredItem = (IDyeableArmorItem)item;
            return coloredItem.func_200886_f(stack);
        }
        return -11184811;
    }

    public static ItemStack withColor(ItemStack stack, DyeColor color) {
        return CustomItemColors.withColor(stack, CustomItemColors.getColorByDye(color));
    }

    public static ItemStack withColor(ItemStack stack, int color) {
        Item item = stack.func_77973_b();
        if (item instanceof IDyeableArmorItem) {
            IDyeableArmorItem coloredItem = (IDyeableArmorItem)item;
            coloredItem.func_200885_a(stack, color);
        }
        return stack;
    }
}

