/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.client.manual;

import li.cil.manual.api.ManualModel;
import li.cil.manual.api.Tab;
import li.cil.manual.api.prefab.Manual;
import li.cil.manual.api.prefab.provider.NamespaceDocumentProvider;
import li.cil.manual.api.prefab.provider.NamespacePathProvider;
import li.cil.manual.api.prefab.tab.ItemStackTab;
import li.cil.manual.api.prefab.tab.TextureTab;
import li.cil.manual.api.provider.DocumentProvider;
import li.cil.manual.api.provider.PathProvider;
import li.cil.oc2.common.block.Blocks;
import li.cil.oc2.common.item.Items;
import li.cil.oc2.common.util.RegistryUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;

@OnlyIn(value=Dist.CLIENT)
public final class Manuals {
    private static final DeferredRegister<ManualModel> MANUALS = RegistryUtils.create(ManualModel.class);
    public static final RegistryObject<ManualModel> MANUAL = MANUALS.register("manual", Manual::new);

    public static void initialize() {
        DeferredRegister<PathProvider> pathProviders = RegistryUtils.create(PathProvider.class);
        DeferredRegister<DocumentProvider> contentProviders = RegistryUtils.create(DocumentProvider.class);
        DeferredRegister<Tab> tabs = RegistryUtils.create(Tab.class);
        pathProviders.register("path_provider", () -> new NamespacePathProvider("oc2"));
        contentProviders.register("content_provider", () -> new NamespaceDocumentProvider("oc2", "doc"));
        tabs.register("home", () -> new TextureTab("%LANGUAGE%/index.md", (ITextComponent)new TranslationTextComponent("manual.oc2.home"), new ResourceLocation("oc2", "textures/gui/manual/home.png")));
        tabs.register("blocks", () -> new ItemStackTab("%LANGUAGE%/block/index.md", (ITextComponent)new TranslationTextComponent("manual.oc2.blocks"), new ItemStack((IItemProvider)Blocks.COMPUTER.get())));
        tabs.register("modules", () -> new ItemStackTab("%LANGUAGE%/item/index.md", (ITextComponent)new TranslationTextComponent("manual.oc2.items"), new ItemStack((IItemProvider)Items.TRANSISTOR.get())));
    }
}

