/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.client.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import li.cil.oc2.common.Constants;
import li.cil.oc2.common.block.BusCableBlock;
import li.cil.oc2.common.tileentity.BusCableTileEntity;
import li.cil.oc2.common.util.ItemStackUtils;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;

public final class BusCableBakedModel
implements IDynamicBakedModel {
    private static final ModelProperty<BusCableSupportSide> BUS_CABLE_SUPPORT_PROPERTY = new ModelProperty();
    private static final ModelProperty<BusCableFacade> BUS_CABLE_FACADE_PROPERTY = new ModelProperty();
    private final IBakedModel proxy;
    private final IBakedModel[] straightModelByAxis;
    private final IBakedModel[] supportModelByFace;

    public BusCableBakedModel(IBakedModel proxy, IBakedModel[] straightModelByAxis, IBakedModel[] supportModelByFace) {
        this.proxy = proxy;
        this.straightModelByAxis = straightModelByAxis;
        this.supportModelByFace = supportModelByFace;
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, Random rand, IModelData extraData) {
        RenderType layer = MinecraftForgeClient.getRenderLayer();
        if (extraData.hasProperty(BUS_CABLE_FACADE_PROPERTY)) {
            BusCableFacade facade = (BusCableFacade)extraData.getData(BUS_CABLE_FACADE_PROPERTY);
            if (layer == null || RenderTypeLookup.canRenderInLayer((BlockState)facade.blockState, (RenderType)layer)) {
                return facade.model.getQuads(facade.blockState, side, rand, facade.data);
            }
            return Collections.emptyList();
        }
        if (state == null || !((Boolean)state.func_177229_b((Property)BusCableBlock.HAS_CABLE)).booleanValue() || layer == null || !layer.equals((Object)RenderType.func_228639_c_())) {
            return Collections.emptyList();
        }
        for (int i = 0; i < Constants.AXES.length; ++i) {
            Direction.Axis axis = Constants.AXES[i];
            if (!BusCableBakedModel.isStraightAlongAxis(state, axis)) continue;
            return this.straightModelByAxis[i].getQuads(state, side, rand, extraData);
        }
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(this.proxy.getQuads(state, side, rand, extraData));
        BusCableSupportSide supportSide = (BusCableSupportSide)extraData.getData(BUS_CABLE_SUPPORT_PROPERTY);
        if (supportSide != null) {
            quads.addAll(this.supportModelByFace[supportSide.value.func_176745_a()].getQuads(state, side, rand, extraData));
        }
        return quads;
    }

    public boolean func_177555_b() {
        return this.proxy.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.proxy.func_177556_c();
    }

    public boolean func_230044_c_() {
        return this.proxy.func_230044_c_();
    }

    public boolean func_188618_c() {
        return this.proxy.func_188618_c();
    }

    public TextureAtlasSprite func_177554_e() {
        return this.proxy.func_177554_e();
    }

    public ItemOverrideList func_188617_f() {
        return this.proxy.func_188617_f();
    }

    @Nonnull
    public IModelData getModelData(IBlockDisplayReader world, BlockPos pos, BlockState state, IModelData tileData) {
        if (state.func_235901_b_((Property)BusCableBlock.HAS_FACADE) && ((Boolean)state.func_177229_b((Property)BusCableBlock.HAS_FACADE)).booleanValue()) {
            TileEntity tileEntity = world.func_175625_s(pos);
            BlockState facadeState = null;
            if (tileEntity instanceof BusCableTileEntity) {
                ItemStack facadeItem = ((BusCableTileEntity)tileEntity).getFacade();
                facadeState = ItemStackUtils.getBlockState(facadeItem);
            }
            if (facadeState == null) {
                facadeState = Blocks.field_150339_S.func_176223_P();
            }
            BlockModelShapes shapes = Minecraft.func_71410_x().func_175602_ab().func_175023_a();
            IBakedModel model = shapes.func_178125_b(facadeState);
            IModelData data = model.getModelData(world, pos, facadeState, tileData);
            return new ModelDataMap.Builder().withInitial(BUS_CABLE_FACADE_PROPERTY, (Object)new BusCableFacade(facadeState, model, data)).build();
        }
        Direction supportSide = null;
        for (Direction direction : Constants.DIRECTIONS) {
            if (!BusCableBakedModel.isNeighborInDirectionSolid(world, pos, direction)) continue;
            EnumProperty<BusCableBlock.ConnectionType> property = BusCableBlock.FACING_TO_CONNECTION_MAP.get(direction);
            if (state.func_235901_b_(property) && state.func_177229_b(property) == BusCableBlock.ConnectionType.INTERFACE) {
                return tileData;
            }
            if (supportSide != null) continue;
            supportSide = direction;
        }
        if (supportSide != null) {
            return new ModelDataMap.Builder().withInitial(BUS_CABLE_SUPPORT_PROPERTY, (Object)new BusCableSupportSide(supportSide)).build();
        }
        return tileData;
    }

    private static boolean isNeighborInDirectionSolid(IBlockDisplayReader world, BlockPos pos, Direction direction) {
        BlockPos neighborPos = pos.func_177972_a(direction);
        return world.func_180495_p(neighborPos).func_224755_d((IBlockReader)world, neighborPos, direction.func_176734_d());
    }

    private static boolean isStraightAlongAxis(BlockState state, Direction.Axis axis) {
        for (Direction direction : Constants.DIRECTIONS) {
            EnumProperty<BusCableBlock.ConnectionType> property = BusCableBlock.FACING_TO_CONNECTION_MAP.get(direction);
            if (!(axis.test(direction) ? state.func_177229_b(property) != BusCableBlock.ConnectionType.CABLE : state.func_177229_b(property) != BusCableBlock.ConnectionType.NONE)) continue;
            return false;
        }
        return true;
    }

    private static final class BusCableFacade {
        public final BlockState blockState;
        public final IBakedModel model;
        public final IModelData data;

        public BusCableFacade(BlockState blockState, IBakedModel model, IModelData data) {
            this.blockState = blockState;
            this.model = model;
            this.data = data;
        }
    }

    private static final class BusCableSupportSide {
        public final Direction value;

        private BusCableSupportSide(Direction value) {
            this.value = value;
        }
    }
}

