/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.client.model;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import li.cil.oc2.client.model.BusCableBakedModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.ModelTransformComposition;
import net.minecraftforge.client.model.geometry.IModelGeometry;

public final class BusCableModel
implements IModelGeometry<BusCableModel> {
    private static final ResourceLocation BUS_CABLE_STRAIGHT_MODEL = new ResourceLocation("oc2", "block/cable_straight");
    private static final ResourceLocation BUS_CABLE_SUPPORT_MODEL = new ResourceLocation("oc2", "block/cable_support");
    private final ModelLoaderRegistry.VanillaProxy proxy;

    public BusCableModel(ModelLoaderRegistry.VanillaProxy proxy) {
        this.proxy = proxy;
    }

    public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList overrides, ResourceLocation modelLocation) {
        IBakedModel bakedBaseModel = this.proxy.bake(owner, bakery, spriteGetter, modelTransform, overrides, modelLocation);
        IBakedModel[] straightModelByAxis = new IBakedModel[]{Objects.requireNonNull(bakery.getBakedModel(BUS_CABLE_STRAIGHT_MODEL, (IModelTransform)new ModelTransformComposition(modelTransform, (IModelTransform)ModelRotation.X0_Y90), spriteGetter)), Objects.requireNonNull(bakery.getBakedModel(BUS_CABLE_STRAIGHT_MODEL, (IModelTransform)new ModelTransformComposition(modelTransform, (IModelTransform)ModelRotation.X90_Y0), spriteGetter)), Objects.requireNonNull(bakery.getBakedModel(BUS_CABLE_STRAIGHT_MODEL, modelTransform, spriteGetter))};
        IBakedModel[] supportModelByFace = new IBakedModel[]{Objects.requireNonNull(bakery.getBakedModel(BUS_CABLE_SUPPORT_MODEL, (IModelTransform)new ModelTransformComposition(modelTransform, (IModelTransform)ModelRotation.X270_Y0), spriteGetter)), Objects.requireNonNull(bakery.getBakedModel(BUS_CABLE_SUPPORT_MODEL, (IModelTransform)new ModelTransformComposition(modelTransform, (IModelTransform)ModelRotation.X90_Y0), spriteGetter)), Objects.requireNonNull(bakery.getBakedModel(BUS_CABLE_SUPPORT_MODEL, (IModelTransform)new ModelTransformComposition(modelTransform, (IModelTransform)ModelRotation.X0_Y180), spriteGetter)), Objects.requireNonNull(bakery.getBakedModel(BUS_CABLE_SUPPORT_MODEL, modelTransform, spriteGetter)), Objects.requireNonNull(bakery.getBakedModel(BUS_CABLE_SUPPORT_MODEL, (IModelTransform)new ModelTransformComposition(modelTransform, (IModelTransform)ModelRotation.X0_Y90), spriteGetter)), Objects.requireNonNull(bakery.getBakedModel(BUS_CABLE_SUPPORT_MODEL, (IModelTransform)new ModelTransformComposition(modelTransform, (IModelTransform)ModelRotation.X0_Y270), spriteGetter))};
        return new BusCableBakedModel(bakedBaseModel, straightModelByAxis, supportModelByFace);
    }

    public Collection<RenderMaterial> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        ArrayList<RenderMaterial> textures = new ArrayList<RenderMaterial>(this.proxy.getTextures(owner, modelGetter, missingTextureErrors));
        textures.addAll(modelGetter.apply(BUS_CABLE_STRAIGHT_MODEL).func_225614_a_(modelGetter, missingTextureErrors));
        textures.addAll(modelGetter.apply(BUS_CABLE_SUPPORT_MODEL).func_225614_a_(modelGetter, missingTextureErrors));
        return textures;
    }
}

