/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.client.renderer;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import li.cil.oc2.client.renderer.CustomRenderType;
import li.cil.oc2.common.tileentity.NetworkConnectorTileEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.dispenser.IPosition;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.LightType;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;

public final class NetworkCableRenderer {
    private static final int MAX_RENDER_DISTANCE = 100;
    private static final int CABLE_VERTEX_COUNT = 9;
    private static final float CABLE_THICKNESS = 0.025f;
    private static final float CABLE_LENGTH_FOR_MAX_SWING = 6.0f;
    private static final float CABLE_MAX_SWING_AMOUNT = 0.05f;
    private static final int CABLE_SWING_INTERVAL = 8000;
    private static final float CABLE_HANG_MIN = 0.1f;
    private static final float CABLE_HANG_MAX = 0.5f;
    private static final float CABLE_MAX_LENGTH = 8.0f;
    private static final Vector3f CABLE_COLOR = new Vector3f(0.0f, 0.33f, 0.4f);
    private static final Set<NetworkConnectorTileEntity> connectors = Collections.newSetFromMap(new WeakHashMap());
    private static int lastKnownConnectorCount;
    private static boolean isDirty;
    private static final ArrayList<Connection> connections;
    private static final WeakHashMap<NetworkConnectorTileEntity, ArrayList<Connection>> connectionsByConnector;

    public static void initialize() {
        MinecraftForge.EVENT_BUS.addListener(NetworkCableRenderer::handleRenderWorld);
        MinecraftForge.EVENT_BUS.addListener(NetworkCableRenderer::handleChunkUnloadEvent);
        MinecraftForge.EVENT_BUS.addListener(NetworkCableRenderer::handleWorldUnloadEvent);
    }

    public static void addNetworkConnector(NetworkConnectorTileEntity connector) {
        connectors.add(connector);
        NetworkCableRenderer.invalidateConnections();
    }

    public static void invalidateConnections() {
        isDirty = true;
    }

    public static void renderCablesFor(IBlockDisplayReader world, MatrixStack matrixStack, Vector3d eye, NetworkConnectorTileEntity connector) {
        ArrayList<Connection> connections = connectionsByConnector.get((Object)connector);
        if (connections != null) {
            NetworkCableRenderer.renderCables(world, matrixStack, eye, connections, unused -> true);
        }
    }

    private static void handleChunkUnloadEvent(ChunkEvent.Unload event) {
        if (event.getWorld().func_201670_d()) {
            ChunkPos chunkPos = event.getChunk().func_76632_l();
            ArrayList<NetworkConnectorTileEntity> list = new ArrayList<NetworkConnectorTileEntity>(connectors);
            for (NetworkConnectorTileEntity connector : list) {
                ChunkPos connectorChunkPos = new ChunkPos(connector.func_174877_v());
                if (!Objects.equals(connectorChunkPos, chunkPos)) continue;
                connectors.remove((Object)connector);
            }
            NetworkCableRenderer.invalidateConnections();
        }
    }

    private static void handleWorldUnloadEvent(WorldEvent.Unload event) {
        if (event.getWorld().func_201670_d()) {
            IWorld world = event.getWorld();
            ArrayList<NetworkConnectorTileEntity> list = new ArrayList<NetworkConnectorTileEntity>(connectors);
            for (NetworkConnectorTileEntity connector : list) {
                if (connector.func_145831_w() != world) continue;
                connectors.remove((Object)connector);
            }
            NetworkCableRenderer.invalidateConnections();
        }
    }

    private static void handleRenderWorld(RenderWorldLastEvent event) {
        NetworkCableRenderer.validateConnectors();
        NetworkCableRenderer.validatePairs();
        if (Minecraft.func_238218_y_()) {
            return;
        }
        if (connections.isEmpty()) {
            return;
        }
        Minecraft client = Minecraft.func_71410_x();
        ClientWorld world = client.field_71441_e;
        if (world == null) {
            return;
        }
        MatrixStack matrixStack = event.getMatrixStack();
        ActiveRenderInfo activeRenderInfo = client.field_71460_t.func_215316_n();
        Vector3d eye = activeRenderInfo.func_216785_c();
        ClippingHelper frustum = new ClippingHelper(matrixStack.func_227866_c_().func_227870_a_(), event.getProjectionMatrix());
        frustum.func_228952_a_(eye.field_72450_a, eye.field_72448_b, eye.field_72449_c);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(-eye.field_72450_a, -eye.field_72448_b, -eye.field_72449_c);
        NetworkCableRenderer.renderCables((IBlockDisplayReader)world, matrixStack, eye, connections, arg_0 -> ((ClippingHelper)frustum).func_228957_a_(arg_0));
        matrixStack.func_227865_b_();
    }

    private static void renderCables(IBlockDisplayReader world, MatrixStack matrixStack, Vector3d eye, ArrayList<Connection> connections, Predicate<AxisAlignedBB> filter) {
        Matrix4f viewMatrix = matrixStack.func_227866_c_().func_227870_a_();
        RenderType renderType = CustomRenderType.getNetworkCable();
        IRenderTypeBuffer.Impl bufferSource = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        float r = CABLE_COLOR.func_195899_a();
        float g = CABLE_COLOR.func_195900_b();
        float b = CABLE_COLOR.func_195902_c();
        for (Connection connection : connections) {
            Vector3d p0 = connection.from;
            Vector3d p1 = connection.to;
            if (!p0.func_237488_a_((IPosition)eye, 100.0) && !p1.func_237488_a_((IPosition)eye, 100.0) || !filter.test(connection.bounds)) continue;
            Vector3d p2 = NetworkCableRenderer.animateCableSwing(NetworkCableRenderer.lerp(p0, p1, 0.5f).func_178786_a(0.0, (double)NetworkCableRenderer.computeCableHang(p0, p1), 0.0), connection.right, NetworkCableRenderer.computeCableSwingAmount(p0, p1), connection.hashCode());
            IVertexBuilder buffer = bufferSource.getBuffer(renderType);
            for (int i = 0; i < 9; ++i) {
                float t = (float)i / 8.0f;
                Vector3d p = NetworkCableRenderer.quadraticBezier(p0, p1, p2, t);
                Vector3d n = NetworkCableRenderer.getExtrusionVector(eye, p, connection.forward);
                BlockPos blockPos = new BlockPos(p);
                int blockLight = world.func_226658_a_(LightType.BLOCK, blockPos);
                int skyLight = world.func_226658_a_(LightType.SKY, blockPos);
                int packedLight = LightTexture.func_228451_a_((int)blockLight, (int)skyLight);
                Vector3f v0 = new Vector3f(p.func_178788_d(n));
                Vector3f v1 = new Vector3f(p.func_178787_e(n));
                buffer.func_227888_a_(viewMatrix, v0.func_195899_a(), v0.func_195900_b(), v0.func_195902_c()).func_227885_a_(r, g, b, 1.0f).func_227886_a_(packedLight).func_181675_d();
                buffer.func_227888_a_(viewMatrix, v1.func_195899_a(), v1.func_195900_b(), v1.func_195902_c()).func_227885_a_(r, g, b, 1.0f).func_227886_a_(packedLight).func_181675_d();
            }
            bufferSource.func_228462_a_(renderType);
        }
    }

    private static Vector3d lerp(Vector3d a, Vector3d b, float t) {
        return a.func_178787_e(b.func_178788_d(a).func_186678_a((double)t));
    }

    private static Vector3d quadraticBezier(Vector3d a, Vector3d b, Vector3d c, float t) {
        Vector3d a1 = NetworkCableRenderer.lerp(a, c, t);
        Vector3d b1 = NetworkCableRenderer.lerp(c, b, t);
        return NetworkCableRenderer.lerp(a1, b1, t);
    }

    private static Vector3d getExtrusionVector(Vector3d eye, Vector3d v, Vector3d forward) {
        return forward.func_72431_c(eye.func_178788_d(v)).func_72432_b().func_186678_a((double)0.025f);
    }

    private static float computeCableHang(Vector3d a, Vector3d b) {
        double length = a.func_72438_d(b);
        double hangFactor = MathHelper.func_151237_a((double)(length / 8.0), (double)0.0, (double)1.0);
        return (float)((double)0.1f + (double)0.4f * hangFactor);
    }

    private static float computeCableSwingAmount(Vector3d p0, Vector3d p1) {
        return MathHelper.func_76131_a((float)((float)p0.func_72438_d(p1) / 6.0f), (float)0.1f, (float)1.0f) * 0.05f;
    }

    private static Vector3d animateCableSwing(Vector3d c, @Nullable Vector3d right, float swingAmount, int seed) {
        float relTime = (float)((System.currentTimeMillis() + (long)seed) % 8000L) / 8000.0f;
        float relRadialTime = relTime * 2.0f * (float)Math.PI;
        if (right == null) {
            return c.func_72441_c((double)(swingAmount * MathHelper.func_76126_a((float)relRadialTime)), 0.0, (double)(swingAmount * MathHelper.func_76134_b((float)relRadialTime)));
        }
        return c.func_72441_c((double)(swingAmount * MathHelper.func_76134_b((float)relRadialTime)) * right.field_72450_a, (double)(0.5f * swingAmount * MathHelper.func_76126_a((float)(relRadialTime * 2.0f - (float)Math.PI)) - swingAmount), (double)(swingAmount * MathHelper.func_76134_b((float)relRadialTime)) * right.field_72449_c);
    }

    private static void validateConnectors() {
        ArrayList<NetworkConnectorTileEntity> list = new ArrayList<NetworkConnectorTileEntity>(connectors);
        for (NetworkConnectorTileEntity connector : list) {
            if (!connector.func_145837_r()) continue;
            connectors.remove((Object)connector);
            connectionsByConnector.remove((Object)connector);
            NetworkCableRenderer.invalidateConnections();
        }
        if (list.size() != lastKnownConnectorCount) {
            NetworkCableRenderer.invalidateConnections();
        }
        lastKnownConnectorCount = list.size();
    }

    private static void validatePairs() {
        if (!isDirty) {
            return;
        }
        isDirty = false;
        connections.clear();
        connectionsByConnector.clear();
        HashSet<Connection> seen = new HashSet<Connection>();
        for (NetworkConnectorTileEntity connector : connectors) {
            BlockPos position = connector.func_174877_v();
            for (BlockPos connectedPosition : connector.getConnectedPositions()) {
                Connection connection = new Connection(position, connectedPosition);
                if (!seen.add(connection)) continue;
                connections.add(connection);
                connectionsByConnector.computeIfAbsent(connector, unused -> new ArrayList()).add(connection);
            }
        }
    }

    static {
        connections = new ArrayList();
        connectionsByConnector = new WeakHashMap();
    }

    private static final class Connection {
        private static final Vector3d POS_Y = new Vector3d(0.0, 1.0, 0.0);
        public final BlockPos fromPos;
        public final BlockPos toPos;
        public final Vector3d from;
        public final Vector3d to;
        public final Vector3d forward;
        public final Vector3d right;
        public final AxisAlignedBB bounds;

        private Connection(BlockPos fromPos, BlockPos toPos) {
            if (fromPos.compareTo((Vector3i)toPos) > 0) {
                this.fromPos = toPos;
                this.toPos = fromPos;
            } else {
                this.fromPos = fromPos;
                this.toPos = toPos;
            }
            this.from = Vector3d.func_237489_a_((Vector3i)fromPos);
            this.to = Vector3d.func_237489_a_((Vector3i)toPos);
            this.forward = this.to.func_178788_d(this.from).func_72432_b();
            this.right = fromPos.func_177958_n() == toPos.func_177958_n() && fromPos.func_177952_p() == toPos.func_177952_p() ? null : this.forward.func_72431_c(POS_Y);
            this.bounds = new AxisAlignedBB(this.from, this.to).func_72314_b(0.0, 0.5, 0.0);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Connection that = (Connection)o;
            return this.fromPos.equals((Object)that.fromPos) && this.toPos.equals((Object)that.toPos);
        }

        public int hashCode() {
            return Objects.hash(this.fromPos, this.toPos);
        }
    }
}

