/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.client.renderer.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import li.cil.oc2.client.renderer.CustomRenderType;
import li.cil.oc2.common.tileentity.ChargerTileEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;

public final class ChargerTileEntityRenderer
extends TileEntityRenderer<ChargerTileEntity> {
    public static final ResourceLocation EFFECT_LOCATION = new ResourceLocation("oc2", "block/charger/effect");
    private static final RenderMaterial TEXTURE_EFFECT = new RenderMaterial(PlayerContainer.field_226615_c_, EFFECT_LOCATION);
    private static final int EFFECT_LAYERS = 3;
    private static final float EFFECT_HEIGHT = 0.5f;
    private static final float EFFECT_SPEED = 0.1f;
    private static final float EFFECT_SCALE_START = 0.6f;
    private static final float EFFECT_SCALE_END = 0.8f;
    private float offset = 0.0f;

    public ChargerTileEntityRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(ChargerTileEntity tileEntity, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int light, int overlay) {
        this.offset = (this.offset + 0.1f * partialTicks / 20.0f) % ((float)Math.PI * 2);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 1.1, 0.5);
        IVertexBuilder builder = TEXTURE_EFFECT.func_229311_a_(buffer, CustomRenderType::getUnlitBlock);
        for (int i = 0; i < 3; ++i) {
            float relativeY = (1.0f + MathHelper.func_76126_a((float)(this.offset + (float)Math.PI * 2 * (float)i / 3.0f))) * 0.5f;
            float y = relativeY * 0.5f;
            float scale = 0.6f + relativeY * 0.19999999f;
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.0, (double)y, 0.0);
            ChargerTileEntityRenderer.renderScaledQuad(matrixStack, builder, scale);
            matrixStack.func_227865_b_();
        }
        matrixStack.func_227865_b_();
    }

    private static void renderScaledQuad(MatrixStack matrixStack, IVertexBuilder builder, float scale) {
        matrixStack.func_227860_a_();
        matrixStack.func_227862_a_(scale, scale, scale);
        ChargerTileEntityRenderer.renderQuad(matrixStack.func_227866_c_().func_227870_a_(), builder);
        matrixStack.func_227865_b_();
    }

    private static void renderQuad(Matrix4f matrix, IVertexBuilder builder) {
        builder.func_227888_a_(matrix, -0.5f, 0.0f, -0.5f);
        builder.func_225583_a_(0.0f, 0.0f);
        builder.func_181675_d();
        builder.func_227888_a_(matrix, -0.5f, 0.0f, 0.5f);
        builder.func_225583_a_(0.0f, 1.0f);
        builder.func_181675_d();
        builder.func_227888_a_(matrix, 0.5f, 0.0f, 0.5f);
        builder.func_225583_a_(1.0f, 1.0f);
        builder.func_181675_d();
        builder.func_227888_a_(matrix, 0.5f, 0.0f, -0.5f);
        builder.func_225583_a_(1.0f, 0.0f);
        builder.func_181675_d();
    }
}

