/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.client.renderer.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import li.cil.oc2.client.renderer.CustomRenderType;
import li.cil.oc2.common.block.ComputerBlock;
import li.cil.oc2.common.tileentity.ComputerTileEntity;
import li.cil.oc2.common.vm.Terminal;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.dispenser.IPosition;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.Style;

public final class ComputerTileEntityRenderer
extends TileEntityRenderer<ComputerTileEntity> {
    public static final ResourceLocation OVERLAY_POWER_LOCATION = new ResourceLocation("oc2", "block/computer/computer_overlay_power");
    public static final ResourceLocation OVERLAY_STATUS_LOCATION = new ResourceLocation("oc2", "block/computer/computer_overlay_status");
    public static final ResourceLocation OVERLAY_TERMINAL_LOCATION = new ResourceLocation("oc2", "block/computer/computer_overlay_terminal");
    private static final RenderMaterial TEXTURE_POWER = new RenderMaterial(PlayerContainer.field_226615_c_, OVERLAY_POWER_LOCATION);
    private static final RenderMaterial TEXTURE_STATUS = new RenderMaterial(PlayerContainer.field_226615_c_, OVERLAY_STATUS_LOCATION);
    private static final RenderMaterial TEXTURE_TERMINAL = new RenderMaterial(PlayerContainer.field_226615_c_, OVERLAY_TERMINAL_LOCATION);

    public ComputerTileEntityRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(ComputerTileEntity tileEntity, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int light, int overlay) {
        Direction blockFacing = (Direction)tileEntity.func_195044_w().func_177229_b((Property)ComputerBlock.field_185512_D);
        Vector3d cameraPosition = this.field_228858_b_.field_217666_g.func_216773_g().func_174824_e(partialTicks);
        Vector3d relativeCameraPosition = cameraPosition.func_178788_d(Vector3d.func_237489_a_((Vector3i)tileEntity.func_174877_v()));
        double projectedCameraPosition = relativeCameraPosition.func_72430_b(Vector3d.func_237491_b_((Vector3i)blockFacing.func_176730_m()));
        if (projectedCameraPosition <= 0.0) {
            return;
        }
        matrixStack.func_227860_a_();
        Quaternion rotation = new Quaternion(Vector3f.field_229180_c_, blockFacing.func_185119_l() + 180.0f, true);
        matrixStack.func_227861_a_(0.5, 0.0, 0.5);
        matrixStack.func_227863_a_(rotation);
        matrixStack.func_227861_a_(-0.5, 0.0, -0.5);
        matrixStack.func_227861_a_(1.0, 1.0, 0.0);
        matrixStack.func_227862_a_(-1.0f, -1.0f, -1.0f);
        float pixelScale = 0.0625f;
        matrixStack.func_227862_a_(0.0625f, 0.0625f, 0.0625f);
        if (tileEntity.getVirtualMachine().isRunning()) {
            this.renderTerminal(tileEntity, matrixStack, buffer, cameraPosition);
        } else {
            this.renderStatusText(tileEntity, matrixStack, cameraPosition);
        }
        matrixStack.func_227861_a_(0.0, 0.0, (double)-0.1f);
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        block0 : switch (tileEntity.getVirtualMachine().getBusState()) {
            case SCAN_PENDING: 
            case INCOMPLETE: {
                this.renderStatus(matrix, buffer);
                break;
            }
            case TOO_COMPLEX: {
                this.renderStatus(matrix, buffer, 1000);
                break;
            }
            case MULTIPLE_CONTROLLERS: {
                this.renderStatus(matrix, buffer, 250);
                break;
            }
            case READY: {
                switch (tileEntity.getVirtualMachine().getRunState()) {
                    case STOPPED: {
                        break block0;
                    }
                    case LOADING_DEVICES: {
                        this.renderStatus(matrix, buffer);
                        break block0;
                    }
                    case RUNNING: {
                        this.renderPower(matrix, buffer);
                    }
                }
            }
        }
        matrixStack.func_227865_b_();
    }

    private void renderTerminal(ComputerTileEntity tileEntity, MatrixStack stack, IRenderTypeBuffer buffer, Vector3d cameraPosition) {
        if (Vector3d.func_237489_a_((Vector3i)tileEntity.func_174877_v()).func_237488_a_((IPosition)cameraPosition, 6.0)) {
            stack.func_227860_a_();
            stack.func_227861_a_(2.0, 2.0, (double)-0.9f);
            Terminal terminal = tileEntity.getTerminal();
            float textScaleX = 12.0f / (float)terminal.getWidth();
            float textScaleY = 7.0f / (float)terminal.getHeight();
            float scale = Math.min(textScaleX, textScaleY) * 0.95f;
            float scaleDeltaX = textScaleX - scale;
            float scaleDeltaY = textScaleY - scale;
            stack.func_227861_a_((double)((float)terminal.getWidth() * scaleDeltaX * 0.5f), (double)((float)terminal.getHeight() * scaleDeltaY * 0.5f), 0.0);
            stack.func_227862_a_(scale, scale, 1.0f);
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            RenderSystem.depthMask((boolean)false);
            terminal.render(stack);
            stack.func_227865_b_();
        } else {
            stack.func_227860_a_();
            stack.func_227861_a_(0.0, 0.0, (double)-0.9f);
            Matrix4f matrix = stack.func_227866_c_().func_227870_a_();
            ComputerTileEntityRenderer.renderQuad(matrix, TEXTURE_TERMINAL.func_229311_a_(buffer, CustomRenderType::getUnlitBlock));
            stack.func_227865_b_();
        }
    }

    private void renderStatusText(ComputerTileEntity tileEntity, MatrixStack stack, Vector3d cameraPosition) {
        if (!Vector3d.func_237489_a_((Vector3i)tileEntity.func_174877_v()).func_237488_a_((IPosition)cameraPosition, 12.0)) {
            return;
        }
        ITextComponent bootError = tileEntity.getVirtualMachine().getBootError();
        if (bootError == null) {
            return;
        }
        stack.func_227860_a_();
        stack.func_227861_a_(3.0, 3.0, (double)-0.9f);
        this.drawText(stack, bootError);
        stack.func_227865_b_();
    }

    private void drawText(MatrixStack stack, ITextComponent text) {
        int maxWidth = 100;
        stack.func_227860_a_();
        stack.func_227862_a_(0.1f, 0.1f, 0.1f);
        FontRenderer fontRenderer = this.field_228858_b_.field_147557_n;
        List wrappedText = fontRenderer.func_238420_b_().func_238362_b_((ITextProperties)text, 100, Style.field_240709_b_);
        if (wrappedText.size() == 1) {
            int textWidth = fontRenderer.func_238414_a_((ITextProperties)text);
            fontRenderer.func_243248_b(stack, text, (float)(100 - textWidth) * 0.5f, 0.0f, 0xEE3322);
        } else {
            for (int i = 0; i < wrappedText.size(); ++i) {
                String string = ((ITextProperties)wrappedText.get(i)).getString();
                fontRenderer.getClass();
                fontRenderer.func_238421_b_(stack, string, 0.0f, (float)(i * 9), 0xEE3322);
            }
        }
        stack.func_227865_b_();
    }

    private void renderStatus(Matrix4f matrix, IRenderTypeBuffer buffer) {
        this.renderStatus(matrix, buffer, 0);
    }

    private void renderStatus(Matrix4f matrix, IRenderTypeBuffer buffer, int frequency) {
        if (frequency <= 0 || (System.currentTimeMillis() + (long)((Object)((Object)this)).hashCode()) / (long)frequency % 2L == 1L) {
            ComputerTileEntityRenderer.renderQuad(matrix, TEXTURE_STATUS.func_229311_a_(buffer, CustomRenderType::getUnlitBlock));
        }
    }

    private void renderPower(Matrix4f matrix, IRenderTypeBuffer buffer) {
        ComputerTileEntityRenderer.renderQuad(matrix, TEXTURE_POWER.func_229311_a_(buffer, CustomRenderType::getUnlitBlock));
    }

    private static void renderQuad(Matrix4f matrix, IVertexBuilder builder) {
        builder.func_227888_a_(matrix, 0.0f, 0.0f, 0.0f);
        builder.func_225583_a_(0.0f, 0.0f);
        builder.func_181675_d();
        builder.func_227888_a_(matrix, 0.0f, 16.0f, 0.0f);
        builder.func_225583_a_(0.0f, 1.0f);
        builder.func_181675_d();
        builder.func_227888_a_(matrix, 16.0f, 16.0f, 0.0f);
        builder.func_225583_a_(1.0f, 1.0f);
        builder.func_181675_d();
        builder.func_227888_a_(matrix, 16.0f, 0.0f, 0.0f);
        builder.func_225583_a_(1.0f, 0.0f);
        builder.func_181675_d();
    }
}

