/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.block;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import li.cil.oc2.client.gui.BusInterfaceScreen;
import li.cil.oc2.common.Constants;
import li.cil.oc2.common.block.Blocks;
import li.cil.oc2.common.integration.Wrenches;
import li.cil.oc2.common.item.Items;
import li.cil.oc2.common.tileentity.BusCableTileEntity;
import li.cil.oc2.common.tileentity.TileEntities;
import li.cil.oc2.common.util.ItemStackUtils;
import li.cil.oc2.common.util.TranslationUtils;
import li.cil.oc2.common.util.WorldUtils;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class BusCableBlock
extends Block {
    public static final BooleanProperty HAS_CABLE = BooleanProperty.func_177716_a((String)"has_cable");
    public static final BooleanProperty HAS_FACADE = BooleanProperty.func_177716_a((String)"has_facade");
    public static final EnumProperty<ConnectionType> CONNECTION_NORTH = EnumProperty.func_177709_a((String)"connection_north", ConnectionType.class);
    public static final EnumProperty<ConnectionType> CONNECTION_EAST = EnumProperty.func_177709_a((String)"connection_east", ConnectionType.class);
    public static final EnumProperty<ConnectionType> CONNECTION_SOUTH = EnumProperty.func_177709_a((String)"connection_south", ConnectionType.class);
    public static final EnumProperty<ConnectionType> CONNECTION_WEST = EnumProperty.func_177709_a((String)"connection_west", ConnectionType.class);
    public static final EnumProperty<ConnectionType> CONNECTION_UP = EnumProperty.func_177709_a((String)"connection_up", ConnectionType.class);
    public static final EnumProperty<ConnectionType> CONNECTION_DOWN = EnumProperty.func_177709_a((String)"connection_down", ConnectionType.class);
    public static final Map<Direction, EnumProperty<ConnectionType>> FACING_TO_CONNECTION_MAP = (Map)Util.func_200696_a((Object)Maps.newEnumMap(Direction.class), directions -> {
        directions.put(Direction.NORTH, CONNECTION_NORTH);
        directions.put(Direction.EAST, CONNECTION_EAST);
        directions.put(Direction.SOUTH, CONNECTION_SOUTH);
        directions.put(Direction.WEST, CONNECTION_WEST);
        directions.put(Direction.UP, CONNECTION_UP);
        directions.put(Direction.DOWN, CONNECTION_DOWN);
    });
    private final VoxelShape[] shapes;

    public static ConnectionType getConnectionType(BlockState state, @Nullable Direction direction) {
        if (direction != null) {
            return (ConnectionType)((Object)state.func_177229_b((Property)FACING_TO_CONNECTION_MAP.get(direction)));
        }
        return ConnectionType.NONE;
    }

    public static int getInterfaceCount(BlockState state) {
        int partCount = 0;
        for (EnumProperty<ConnectionType> connectionType : FACING_TO_CONNECTION_MAP.values()) {
            if (state.func_177229_b(connectionType) != ConnectionType.INTERFACE) continue;
            ++partCount;
        }
        return partCount;
    }

    public static Direction getHitSide(BlockPos pos, BlockRayTraceResult hit) {
        Vector3d localHitPos = hit.func_216347_e().func_178788_d(Vector3d.func_237489_a_((Vector3i)pos));
        return Direction.func_210769_a((double)localHitPos.field_72450_a, (double)localHitPos.field_72448_b, (double)localHitPos.field_72449_c);
    }

    public BusCableBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200947_a(SoundType.field_185852_e).func_200948_a(1.5f, 6.0f));
        BlockState defaultState = (BlockState)this.func_176194_O().func_177621_b();
        for (EnumProperty<ConnectionType> property : FACING_TO_CONNECTION_MAP.values()) {
            defaultState = (BlockState)defaultState.func_206870_a(property, (Comparable)((Object)ConnectionType.NONE));
        }
        defaultState = (BlockState)defaultState.func_206870_a((Property)HAS_CABLE, (Comparable)Boolean.valueOf(true));
        defaultState = (BlockState)defaultState.func_206870_a((Property)HAS_FACADE, (Comparable)Boolean.valueOf(false));
        this.func_180632_j(defaultState);
        this.shapes = BusCableBlock.makeShapes();
    }

    public static boolean addInterface(World world, BlockPos pos, BlockState state, Direction side) {
        if (state.func_177230_c() != Blocks.BUS_CABLE.get()) {
            return false;
        }
        if (((Boolean)state.func_177229_b((Property)HAS_FACADE)).booleanValue()) {
            return false;
        }
        EnumProperty<ConnectionType> property = FACING_TO_CONNECTION_MAP.get(side);
        if (state.func_177229_b(property) != ConnectionType.NONE) {
            return false;
        }
        world.func_180501_a(pos, (BlockState)state.func_206870_a(property, (Comparable)((Object)ConnectionType.INTERFACE)), 11);
        BusCableBlock.onConnectionTypeChanged((IWorld)world, pos, side);
        return true;
    }

    public static boolean addCable(World world, BlockPos pos, BlockState state) {
        if (state.func_177230_c() != Blocks.BUS_CABLE.get()) {
            return false;
        }
        if (((Boolean)state.func_177229_b((Property)HAS_CABLE)).booleanValue()) {
            return false;
        }
        world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)HAS_CABLE, (Comparable)Boolean.valueOf(true)), 11);
        BusCableBlock.onConnectionTypeChanged((IWorld)world, pos, null);
        return true;
    }

    public static void setHasFacade(World world, BlockPos pos, BlockState state, @Nullable BlockState facadeState, boolean value) {
        if ((Boolean)state.func_177229_b((Property)HAS_FACADE) == value) {
            return;
        }
        world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)HAS_FACADE, (Comparable)Boolean.valueOf(value)), 11);
        BlockState soundsSource = facadeState != null ? facadeState : state;
        WorldUtils.playSound((IWorld)world, pos, soundsSource.func_215695_r(), value ? SoundType::func_185841_e : SoundType::func_185845_c);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)TileEntities.BUS_CABLE_TILE_ENTITY.get()).func_200968_a();
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block changedBlock, BlockPos changedBlockPos, boolean isMoving) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof BusCableTileEntity) {
            BusCableTileEntity busCable = (BusCableTileEntity)tileEntity;
            busCable.handleNeighborChanged(changedBlockPos);
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (heldItem.func_77973_b() == Items.BUS_CABLE.get() || heldItem.func_77973_b() == Items.BUS_INTERFACE.get()) {
            return ActionResultType.PASS;
        }
        TileEntity tileEntity = world.func_175625_s(pos);
        if (!(tileEntity instanceof BusCableTileEntity)) {
            return super.func_225533_a_(state, world, pos, player, hand, hit);
        }
        BusCableTileEntity busCableTileEntity = (BusCableTileEntity)tileEntity;
        if (Wrenches.isWrench(heldItem)) {
            Direction side;
            if (player.func_225608_bj_()) {
                ItemStack facadeItem = busCableTileEntity.getFacade();
                if (!facadeItem.func_190926_b()) {
                    if (!world.func_201670_d()) {
                        busCableTileEntity.removeFacade();
                        if (!player.func_184812_l_() && world.func_82736_K().func_223586_b(GameRules.field_223603_f)) {
                            ItemStackUtils.spawnAsEntity(world, pos, facadeItem, hit.func_216354_b()).ifPresent(entity -> {
                                entity.func_174868_q();
                                entity.func_70100_b_(player);
                            });
                        }
                    }
                    return ActionResultType.func_233537_a_((boolean)world.func_201670_d());
                }
                if (BusCableBlock.getPartCount(state) > 1 && (BusCableBlock.tryRemovePlug(state, world, pos, player, hit) || BusCableBlock.tryRemoveCable(state, world, pos, player))) {
                    return ActionResultType.func_233537_a_((boolean)world.func_201670_d());
                }
            } else if (world.func_201670_d() && BusCableBlock.getConnectionType(state, side = BusCableBlock.getHitSide(pos, hit)) == ConnectionType.INTERFACE) {
                BusCableBlock.openBusInterfaceScreen(busCableTileEntity, side);
                return ActionResultType.func_233537_a_((boolean)world.func_201670_d());
            }
        } else if (!player.func_225608_bj_() && !((Boolean)state.func_177229_b((Property)HAS_FACADE)).booleanValue() && BusCableBlock.getInterfaceCount(state) == 0) {
            switch (busCableTileEntity.getFacadeType(heldItem)) {
                case INVALID_BLOCK: {
                    if (!world.func_201670_d()) {
                        player.func_146105_b((ITextComponent)TranslationUtils.text("message.{mod}.invalid_facade_block"), true);
                    }
                    return ActionResultType.func_233537_a_((boolean)world.func_201670_d());
                }
                case VALID_BLOCK: {
                    if (!world.func_201670_d()) {
                        busCableTileEntity.setFacade(heldItem);
                        if (!player.field_71075_bZ.field_75098_d) {
                            heldItem.func_190918_g(1);
                        }
                    }
                    return ActionResultType.func_233537_a_((boolean)world.func_201670_d());
                }
            }
        }
        return super.func_225533_a_(state, world, pos, player, hand, hit);
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        ItemStack stack;
        TileEntity tileEntity;
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>(super.func_220076_a(state, builder));
        if (((Boolean)state.func_177229_b((Property)HAS_FACADE)).booleanValue() && (tileEntity = (TileEntity)builder.func_216019_b(LootParameters.field_216288_h)) instanceof BusCableTileEntity && !(stack = ((BusCableTileEntity)tileEntity).getFacade()).func_190926_b()) {
            drops.add(stack);
        }
        if (((Boolean)state.func_177229_b((Property)HAS_CABLE)).booleanValue()) {
            drops.add(new ItemStack((IItemProvider)Items.BUS_CABLE.get()));
        }
        int interfaceCount = 0;
        for (Direction side : Constants.DIRECTIONS) {
            ConnectionType connectionType = (ConnectionType)((Object)state.func_177229_b((Property)FACING_TO_CONNECTION_MAP.get(side)));
            if (connectionType != ConnectionType.INTERFACE) continue;
            ++interfaceCount;
        }
        if (interfaceCount > 0) {
            drops.add(new ItemStack((IItemProvider)Items.BUS_INTERFACE.get(), interfaceCount));
        }
        return drops;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = this.func_176223_P();
        World world = context.func_195991_k();
        BlockPos position = context.func_195995_a();
        for (Map.Entry<Direction, EnumProperty<ConnectionType>> entry : FACING_TO_CONNECTION_MAP.entrySet()) {
            Direction facing = entry.getKey();
            BlockPos facingPos = position.func_177972_a(facing);
            if (context.func_195996_i().func_77973_b() != Items.BUS_CABLE.get() || !BusCableBlock.canHaveCableTo(world.func_180495_p(facingPos), facing.func_176734_d())) continue;
            state = (BlockState)state.func_206870_a((Property)entry.getValue(), (Comparable)((Object)ConnectionType.CABLE));
        }
        return state;
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (state.func_177229_b((Property)FACING_TO_CONNECTION_MAP.get(facing)) == ConnectionType.INTERFACE) {
            return state;
        }
        state = (Boolean)state.func_177229_b((Property)HAS_CABLE) != false && BusCableBlock.canHaveCableTo(facingState, facing.func_176734_d()) ? (BlockState)state.func_206870_a((Property)FACING_TO_CONNECTION_MAP.get(facing), (Comparable)((Object)ConnectionType.CABLE)) : (BlockState)state.func_206870_a((Property)FACING_TO_CONNECTION_MAP.get(facing), (Comparable)((Object)ConnectionType.NONE));
        BusCableBlock.onConnectionTypeChanged(world, currentPos, facing);
        return state;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        if (((Boolean)state.func_177229_b((Property)HAS_FACADE)).booleanValue()) {
            return VoxelShapes.func_197868_b();
        }
        return this.shapes[BusCableBlock.getShapeIndex(state)];
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        Direction side;
        TileEntity tileEntity = world.func_175625_s(pos);
        if (!(tileEntity instanceof BusCableTileEntity)) {
            return super.getPickBlock(state, target, world, pos, player);
        }
        BusCableTileEntity busCableTileEntity = (BusCableTileEntity)tileEntity;
        ItemStack facadeItem = busCableTileEntity.getFacade();
        if (!facadeItem.func_190926_b()) {
            return facadeItem;
        }
        if (target instanceof BlockRayTraceResult && BusCableBlock.getConnectionType(state, side = BusCableBlock.getHitSide(pos, (BlockRayTraceResult)target)) == ConnectionType.INTERFACE) {
            return new ItemStack((IItemProvider)Items.BUS_INTERFACE.get());
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        FACING_TO_CONNECTION_MAP.values().forEach(xva$0 -> builder.func_206894_a(new Property[]{xva$0}));
        builder.func_206894_a(new Property[]{HAS_CABLE});
        builder.func_206894_a(new Property[]{HAS_FACADE});
    }

    private static boolean canHaveCableTo(BlockState state, Direction side) {
        return state.func_177230_c() == Blocks.BUS_CABLE.get() && (Boolean)state.func_177229_b((Property)HAS_CABLE) != false && state.func_177229_b((Property)FACING_TO_CONNECTION_MAP.get(side)) != ConnectionType.INTERFACE;
    }

    private static int getPartCount(BlockState state) {
        int partCount = BusCableBlock.getInterfaceCount(state);
        if (((Boolean)state.func_177229_b((Property)HAS_CABLE)).booleanValue()) {
            ++partCount;
        }
        return partCount;
    }

    private static boolean tryRemovePlug(BlockState state, World world, BlockPos pos, PlayerEntity player, BlockRayTraceResult hit) {
        Direction side = BusCableBlock.getHitSide(pos, hit);
        EnumProperty<ConnectionType> property = FACING_TO_CONNECTION_MAP.get(side);
        if (state.func_177229_b(property) != ConnectionType.INTERFACE) {
            return false;
        }
        BlockPos neighborPos = pos.func_177972_a(side);
        if (((Boolean)state.func_177229_b((Property)HAS_CABLE)).booleanValue() && BusCableBlock.canHaveCableTo(world.func_180495_p(neighborPos), side.func_176734_d())) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a(property, (Comparable)((Object)ConnectionType.CABLE)));
        } else {
            world.func_175656_a(pos, (BlockState)state.func_206870_a(property, (Comparable)((Object)ConnectionType.NONE)));
        }
        BusCableBlock.handlePartRemoved(state, world, pos, side, player, new ItemStack((IItemProvider)Items.BUS_INTERFACE.get()));
        return true;
    }

    private static boolean tryRemoveCable(BlockState state, World world, BlockPos pos, PlayerEntity player) {
        if (!((Boolean)state.func_177229_b((Property)HAS_CABLE)).booleanValue()) {
            return false;
        }
        world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)HAS_CABLE, (Comparable)Boolean.valueOf(false)));
        BusCableBlock.handlePartRemoved(state, world, pos, null, player, new ItemStack((IItemProvider)Items.BUS_CABLE.get()));
        return true;
    }

    private static void handlePartRemoved(BlockState state, World world, BlockPos pos, @Nullable Direction side, PlayerEntity player, ItemStack drop) {
        BusCableBlock.onConnectionTypeChanged((IWorld)world, pos, side);
        if (!player.func_184812_l_() && world.func_82736_K().func_223586_b(GameRules.field_223603_f)) {
            ItemStackUtils.spawnAsEntity(world, pos, drop, side).ifPresent(entity -> {
                entity.func_174868_q();
                entity.func_70100_b_(player);
            });
        }
        WorldUtils.playSound((IWorld)world, pos, state.func_215695_r(), SoundType::func_185845_c);
    }

    private static void onConnectionTypeChanged(IWorld world, BlockPos pos, @Nullable Direction face) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof BusCableTileEntity) {
            BusCableTileEntity busCable = (BusCableTileEntity)tileEntity;
            busCable.handleConnectivityChanged(face);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void openBusInterfaceScreen(BusCableTileEntity tileEntity, Direction side) {
        BusInterfaceScreen screen = new BusInterfaceScreen(tileEntity, side);
        Minecraft.func_71410_x().func_147108_a((Screen)screen);
    }

    private static VoxelShape[] makeShapes() {
        VoxelShape ownCableBounds = Block.func_208617_a((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0);
        VoxelShape[] cableShapes = new VoxelShape[Constants.BLOCK_FACE_COUNT];
        VoxelShape[] interfaceShapes = new VoxelShape[Constants.BLOCK_FACE_COUNT];
        for (int i = 0; i < Constants.BLOCK_FACE_COUNT; ++i) {
            cableShapes[i] = BusCableBlock.getCableShape(Constants.DIRECTIONS[i]);
            interfaceShapes[i] = BusCableBlock.getInterfaceShape(Constants.DIRECTIONS[i]);
        }
        int configurations = 8192;
        Object[] result = new VoxelShape[8192];
        Arrays.fill(result, VoxelShapes.func_197880_a());
        for (int i = 0; i < result.length; ++i) {
            int mask = i >> 1;
            for (int sideIndex = 0; sideIndex < Constants.BLOCK_FACE_COUNT; ++sideIndex) {
                int interfaceBit;
                int cableBit = 1 << sideIndex;
                if ((mask & cableBit) != 0) {
                    result[i] = VoxelShapes.func_197872_a((VoxelShape)result[i], (VoxelShape)cableShapes[sideIndex]);
                }
                if ((mask & (interfaceBit = cableBit << 6)) == 0) continue;
                result[i] = VoxelShapes.func_197872_a((VoxelShape)result[i], (VoxelShape)interfaceShapes[sideIndex]);
            }
            if ((i & 1) == 0) continue;
            result[i] = VoxelShapes.func_197872_a((VoxelShape)result[i], (VoxelShape)ownCableBounds);
        }
        return result;
    }

    private static VoxelShape getCableShape(Direction zDirection) {
        int xSize = 6;
        int ySize = 6;
        int zSize = 5;
        Direction yDirection = zDirection.func_176740_k() == Direction.Axis.Y ? Direction.NORTH : Direction.UP;
        Direction xDirection = zDirection.func_176740_k() == Direction.Axis.Y ? Direction.WEST : zDirection.func_176746_e();
        Vector3i min = new Vector3i(8, 8, 8).func_177967_a(xDirection, -3).func_177967_a(yDirection, -3).func_177967_a(zDirection, 3);
        Vector3i max = new Vector3i(8, 8, 8).func_177967_a(xDirection, 3).func_177967_a(yDirection, 3).func_177967_a(zDirection, 8);
        AxisAlignedBB bounds = new AxisAlignedBB(Vector3d.func_237491_b_((Vector3i)min).func_186678_a(0.0625), Vector3d.func_237491_b_((Vector3i)max).func_186678_a(0.0625));
        return VoxelShapes.func_197881_a((AxisAlignedBB)bounds);
    }

    private static VoxelShape getInterfaceShape(Direction zDirection) {
        int xSize = 8;
        int ySize = 8;
        boolean zSize = true;
        Direction yDirection = zDirection.func_176740_k() == Direction.Axis.Y ? Direction.NORTH : Direction.UP;
        Direction xDirection = zDirection.func_176740_k() == Direction.Axis.Y ? Direction.WEST : zDirection.func_176746_e();
        Vector3i min = new Vector3i(8, 8, 8).func_177967_a(xDirection, -4).func_177967_a(yDirection, -4).func_177967_a(zDirection, 7);
        Vector3i max = new Vector3i(8, 8, 8).func_177967_a(xDirection, 4).func_177967_a(yDirection, 4).func_177967_a(zDirection, 8);
        AxisAlignedBB bounds = new AxisAlignedBB(Vector3d.func_237491_b_((Vector3i)min).func_186678_a(0.0625), Vector3d.func_237491_b_((Vector3i)max).func_186678_a(0.0625));
        return VoxelShapes.func_197872_a((VoxelShape)BusCableBlock.getCableShape(zDirection), (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)bounds));
    }

    private static int getShapeIndex(BlockState state) {
        int index = 0;
        block4: for (int sideIndex = 0; sideIndex < Constants.BLOCK_FACE_COUNT; ++sideIndex) {
            int cableBit = 1 << sideIndex;
            int interfaceBit = cableBit << 6;
            switch ((ConnectionType)((Object)state.func_177229_b((Property)FACING_TO_CONNECTION_MAP.get(Constants.DIRECTIONS[sideIndex])))) {
                case CABLE: {
                    index |= cableBit;
                    continue block4;
                }
                case INTERFACE: {
                    index |= interfaceBit;
                }
            }
        }
        index <<= 1;
        if (((Boolean)state.func_177229_b((Property)HAS_CABLE)).booleanValue()) {
            index |= 1;
        }
        return index;
    }

    public static enum ConnectionType implements IStringSerializable
    {
        NONE,
        CABLE,
        INTERFACE;


        public String func_176610_l() {
            switch (this) {
                case NONE: {
                    return "none";
                }
                case CABLE: {
                    return "cable";
                }
                case INTERFACE: {
                    return "interface";
                }
            }
            throw new IllegalArgumentException();
        }
    }
}

