/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.block;

import java.util.List;
import javax.annotation.Nullable;
import li.cil.oc2.api.bus.device.DeviceTypes;
import li.cil.oc2.api.capabilities.RedstoneEmitter;
import li.cil.oc2.common.Config;
import li.cil.oc2.common.block.ImmutableHorizontalBlock;
import li.cil.oc2.common.capabilities.Capabilities;
import li.cil.oc2.common.integration.Wrenches;
import li.cil.oc2.common.item.Items;
import li.cil.oc2.common.tileentity.ComputerTileEntity;
import li.cil.oc2.common.tileentity.TileEntities;
import li.cil.oc2.common.util.NBTUtils;
import li.cil.oc2.common.util.TooltipUtils;
import li.cil.oc2.common.util.TranslationUtils;
import li.cil.oc2.common.util.VoxelShapeUtils;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class ComputerBlock
extends ImmutableHorizontalBlock {
    private static final VoxelShape NEG_Z_SHAPE = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)1.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)1.0), Block.func_208617_a((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0)});
    private static final VoxelShape NEG_X_SHAPE = VoxelShapeUtils.rotateHorizontalClockwise(NEG_Z_SHAPE);
    private static final VoxelShape POS_Z_SHAPE = VoxelShapeUtils.rotateHorizontalClockwise(NEG_X_SHAPE);
    private static final VoxelShape POS_X_SHAPE = VoxelShapeUtils.rotateHorizontalClockwise(POS_Z_SHAPE);

    public ComputerBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200947_a(SoundType.field_185852_e).func_200948_a(1.5f, 6.0f));
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)field_185512_D, (Comparable)Direction.NORTH));
    }

    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> items) {
        items.add((Object)this.getComputerWithFlash());
        items.add((Object)this.getPreconfiguredComputer());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        super.func_190948_a(stack, world, tooltip, advanced);
        TooltipUtils.addEnergyConsumption(Config.computerEnergyPerTick, tooltip);
        TooltipUtils.addTileEntityInventoryInformation(stack, tooltip);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)TileEntities.COMPUTER_TILE_ENTITY.get()).func_200968_a();
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    public int func_180656_a(BlockState state, IBlockReader world, BlockPos pos, Direction side) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity != null) {
            return tileEntity.getCapability(Capabilities.REDSTONE_EMITTER, side.func_176734_d()).map(RedstoneEmitter::getRedstoneOutput).orElse(0);
        }
        return super.func_180656_a(state, world, pos, side);
    }

    public int func_176211_b(BlockState state, IBlockReader world, BlockPos pos, Direction side) {
        return this.func_180656_a(state, world, pos, side);
    }

    public boolean shouldCheckWeakPower(BlockState state, IWorldReader world, BlockPos pos, Direction side) {
        return false;
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block changedBlock, BlockPos changedBlockPos, boolean isMoving) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof ComputerTileEntity) {
            ComputerTileEntity computer = (ComputerTileEntity)tileEntity;
            computer.handleNeighborChanged();
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        switch ((Direction)state.func_177229_b((Property)field_185512_D)) {
            case NORTH: {
                return NEG_Z_SHAPE;
            }
            case SOUTH: {
                return POS_Z_SHAPE;
            }
            case WEST: {
                return NEG_X_SHAPE;
            }
        }
        return POS_X_SHAPE;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (!(tileEntity instanceof ComputerTileEntity)) {
            return super.func_225533_a_(state, world, pos, player, hand, hit);
        }
        ComputerTileEntity computer = (ComputerTileEntity)tileEntity;
        ItemStack heldItem = player.func_184586_b(hand);
        if (Wrenches.isWrench(heldItem)) {
            if (!player.func_225608_bj_()) {
                if (!world.func_201670_d() && player instanceof ServerPlayerEntity) {
                    computer.openInventoryScreen((ServerPlayerEntity)player);
                }
                return ActionResultType.func_233537_a_((boolean)world.func_201670_d());
            }
        } else {
            if (!world.func_201670_d()) {
                if (player.func_225608_bj_()) {
                    computer.start();
                } else if (player instanceof ServerPlayerEntity) {
                    computer.openTerminalScreen((ServerPlayerEntity)player);
                }
            }
            return ActionResultType.func_233537_a_((boolean)world.func_201670_d());
        }
        return super.func_225533_a_(state, world, pos, player, hand, hit);
    }

    public void func_176208_a(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        ComputerTileEntity computer;
        TileEntity tileEntity = world.func_175625_s(pos);
        if (!world.func_201670_d() && tileEntity instanceof ComputerTileEntity && !(computer = (ComputerTileEntity)tileEntity).getItemStackHandlers().isEmpty()) {
            computer.getItemStackHandlers().exportDeviceDataToItemStacks();
            if (player.func_184812_l_()) {
                ItemStack stack = new ItemStack((IItemProvider)Items.COMPUTER.get());
                computer.exportToItemStack(stack);
                ComputerBlock.func_180635_a((World)world, (BlockPos)pos, (ItemStack)stack);
            }
        }
        super.func_176208_a(world, pos, state, player);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)super.func_176223_P().func_206870_a((Property)field_185512_D, (Comparable)context.func_195992_f().func_176734_d());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{field_185512_D});
    }

    private ItemStack getComputerWithFlash() {
        ItemStack computer = new ItemStack((IItemProvider)this);
        CompoundNBT itemsTag = NBTUtils.getOrCreateChildTag(computer.func_196082_o(), "BlockEntityTag", "items");
        itemsTag.func_218657_a(DeviceTypes.FLASH_MEMORY.getRegistryName().toString(), (INBT)NBTUtils.makeInventoryTag(new ItemStack((IItemProvider)Items.FLASH_MEMORY_CUSTOM.get())));
        return computer;
    }

    private ItemStack getPreconfiguredComputer() {
        ItemStack computer = this.getComputerWithFlash();
        CompoundNBT itemsTag = NBTUtils.getOrCreateChildTag(computer.func_196082_o(), "BlockEntityTag", "items");
        itemsTag.func_218657_a(DeviceTypes.MEMORY.getRegistryName().toString(), (INBT)NBTUtils.makeInventoryTag(new ItemStack((IItemProvider)Items.MEMORY_LARGE.get()), new ItemStack((IItemProvider)Items.MEMORY_LARGE.get()), new ItemStack((IItemProvider)Items.MEMORY_LARGE.get()), new ItemStack((IItemProvider)Items.MEMORY_LARGE.get())));
        itemsTag.func_218657_a(DeviceTypes.HARD_DRIVE.getRegistryName().toString(), (INBT)NBTUtils.makeInventoryTag(new ItemStack((IItemProvider)Items.HARD_DRIVE_CUSTOM.get())));
        itemsTag.func_218657_a(DeviceTypes.CARD.getRegistryName().toString(), (INBT)NBTUtils.makeInventoryTag(new ItemStack((IItemProvider)Items.NETWORK_INTERFACE_CARD.get())));
        computer.func_200302_a((ITextComponent)TranslationUtils.text("block.{mod}.computer.preconfigured"));
        return computer;
    }
}

