/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.block;

import java.util.Objects;
import li.cil.oc2.common.tileentity.NetworkConnectorTileEntity;
import li.cil.oc2.common.tileentity.TileEntities;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalFaceBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public final class NetworkConnectorBlock
extends HorizontalFaceBlock {
    private static final VoxelShape NEG_Z_SHAPE = Block.func_208617_a((double)5.0, (double)5.0, (double)7.0, (double)11.0, (double)11.0, (double)16.0);
    private static final VoxelShape POS_Z_SHAPE = Block.func_208617_a((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)9.0);
    private static final VoxelShape NEG_X_SHAPE = Block.func_208617_a((double)7.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0);
    private static final VoxelShape POS_X_SHAPE = Block.func_208617_a((double)0.0, (double)5.0, (double)5.0, (double)9.0, (double)11.0, (double)11.0);
    private static final VoxelShape NEG_Y_SHAPE = Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)9.0, (double)11.0);
    private static final VoxelShape POS_Y_SHAPE = Block.func_208617_a((double)5.0, (double)7.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);

    public NetworkConnectorBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200947_a(SoundType.field_185852_e).func_200948_a(1.5f, 6.0f));
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)field_185512_D, (Comparable)Direction.NORTH)).func_206870_a((Property)field_196366_M, (Comparable)AttachFace.WALL));
    }

    public static Direction getFacing(BlockState state) {
        return HorizontalFaceBlock.func_196365_i((BlockState)state);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)TileEntities.NETWORK_CONNECTOR_TILE_ENTITY.get()).func_200968_a();
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block changedBlock, BlockPos changedBlockPos, boolean isMoving) {
        TileEntity tileEntity;
        if (Objects.equals(changedBlockPos, pos.func_177972_a(NetworkConnectorBlock.getFacing(state).func_176734_d())) && (tileEntity = world.func_175625_s(pos)) instanceof NetworkConnectorTileEntity) {
            NetworkConnectorTileEntity connector = (NetworkConnectorTileEntity)tileEntity;
            connector.setLocalInterfaceChanged();
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        switch ((AttachFace)state.func_177229_b((Property)field_196366_M)) {
            case WALL: {
                switch ((Direction)state.func_177229_b((Property)field_185512_D)) {
                    case EAST: {
                        return POS_X_SHAPE;
                    }
                    case WEST: {
                        return NEG_X_SHAPE;
                    }
                    case SOUTH: {
                        return POS_Z_SHAPE;
                    }
                }
                return NEG_Z_SHAPE;
            }
            case CEILING: {
                return POS_Y_SHAPE;
            }
        }
        return NEG_Y_SHAPE;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_196366_M, field_185512_D});
    }
}

