/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.bus;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import li.cil.oc2.api.bus.device.Device;
import li.cil.oc2.common.bus.AbstractDeviceBusElement;
import li.cil.oc2.common.bus.device.util.AbstractDeviceInfo;
import li.cil.oc2.common.util.ItemDeviceUtils;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraftforge.registries.IForgeRegistryEntry;

public abstract class AbstractGroupingDeviceBusElement<TProvider extends IForgeRegistryEntry<TProvider>, TDeviceInfo extends AbstractDeviceInfo<TProvider, ?>>
extends AbstractDeviceBusElement {
    private static final String GROUPS_TAG_NAME = "groups";
    private static final String GROUP_ID_TAG_NAME = "groupId";
    private static final String GROUP_DATA_TAG_NAME = "groupData";
    protected final int groupCount;
    protected final ArrayList<HashSet<TDeviceInfo>> groups;
    protected final UUID[] groupIds;
    protected final CompoundNBT[] groupData;

    protected AbstractGroupingDeviceBusElement(int groupCount) {
        this.groupCount = groupCount;
        this.groups = new ArrayList(groupCount);
        this.groupIds = new UUID[groupCount];
        this.groupData = new CompoundNBT[groupCount];
        for (int i = 0; i < groupCount; ++i) {
            this.groups.add(new HashSet());
            this.groupIds[i] = UUID.randomUUID();
            this.groupData[i] = new CompoundNBT();
        }
    }

    public Collection<TDeviceInfo> getDeviceGroup(int index) {
        return this.groups.get(index);
    }

    public CompoundNBT save() {
        ListNBT listTag = new ListNBT();
        for (int i = 0; i < this.groupCount; ++i) {
            this.saveGroup(i);
            CompoundNBT sideTag = new CompoundNBT();
            sideTag.func_186854_a(GROUP_ID_TAG_NAME, this.groupIds[i]);
            sideTag.func_218657_a(GROUP_DATA_TAG_NAME, (INBT)this.groupData[i]);
            listTag.add((Object)sideTag);
        }
        CompoundNBT tag = new CompoundNBT();
        tag.func_218657_a(GROUPS_TAG_NAME, (INBT)listTag);
        return tag;
    }

    public void load(CompoundNBT tag) {
        ListNBT listTag = tag.func_150295_c(GROUPS_TAG_NAME, 10);
        int count = Math.min(this.groupCount, listTag.size());
        for (int i = 0; i < count; ++i) {
            CompoundNBT sideTag = listTag.func_150305_b(i);
            if (sideTag.func_186855_b(GROUP_ID_TAG_NAME)) {
                this.groupIds[i] = sideTag.func_186857_a(GROUP_ID_TAG_NAME);
            }
            if (!sideTag.func_150297_b(GROUP_DATA_TAG_NAME, 10)) continue;
            this.groupData[i] = sideTag.func_74775_l(GROUP_DATA_TAG_NAME);
        }
    }

    @Override
    public Optional<UUID> getDeviceIdentifier(Device device) {
        for (int i = 0; i < this.groupCount; ++i) {
            HashSet<TDeviceInfo> group = this.groups.get(i);
            for (AbstractDeviceInfo deviceInfo : group) {
                if (!Objects.equals(device, deviceInfo.device)) continue;
                return Optional.of(this.groupIds[i]);
            }
        }
        return super.getDeviceIdentifier(device);
    }

    protected final void setDevicesForGroup(int index, Set<TDeviceInfo> newDevices) {
        HashSet<TDeviceInfo> oldDevices = this.groups.get(index);
        if (Objects.equals(newDevices, oldDevices)) {
            return;
        }
        HashSet<TDeviceInfo> removedDevices = new HashSet<TDeviceInfo>(oldDevices);
        removedDevices.removeAll(newDevices);
        for (Object info : removedDevices) {
            this.devices.removeInt(((AbstractDeviceInfo)info).device);
        }
        HashSet<TDeviceInfo> addedDevices = new HashSet<TDeviceInfo>(newDevices);
        addedDevices.removeAll(oldDevices);
        for (AbstractDeviceInfo info : addedDevices) {
            this.devices.put(info.device, info.getEnergyConsumption());
        }
        oldDevices.removeAll(removedDevices);
        oldDevices.addAll(newDevices);
        CompoundNBT devicesTag = this.groupData[index];
        for (AbstractDeviceInfo deviceInfo : removedDevices) {
            ItemDeviceUtils.getItemDeviceDataKey(deviceInfo.provider).ifPresent(arg_0 -> ((CompoundNBT)devicesTag).func_82580_o(arg_0));
        }
        for (AbstractDeviceInfo deviceInfo : addedDevices) {
            ItemDeviceUtils.getItemDeviceDataKey(deviceInfo.provider).ifPresent(key -> {
                if (devicesTag.func_150297_b(key, 10)) {
                    deviceInfo.device.deserializeNBT(devicesTag.func_74775_l(key));
                }
            });
        }
        this.scanDevices();
    }

    private void saveGroup(int index) {
        CompoundNBT devicesTag = new CompoundNBT();
        for (AbstractDeviceInfo deviceInfo : this.groups.get(index)) {
            ItemDeviceUtils.getItemDeviceDataKey(deviceInfo.provider).ifPresent(key -> {
                CompoundNBT deviceTag = deviceInfo.device.serializeNBT();
                if (!deviceTag.isEmpty()) {
                    devicesTag.func_218657_a(key, (INBT)deviceTag);
                }
            });
        }
        this.groupData[index] = devicesTag;
    }
}

