/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.bus;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.UUID;
import li.cil.oc2.api.bus.DeviceBusController;
import li.cil.oc2.api.bus.DeviceBusElement;
import li.cil.oc2.api.bus.device.Device;
import li.cil.oc2.common.util.Event;
import li.cil.oc2.common.util.ParameterizedEvent;
import net.minecraftforge.common.util.LazyOptional;

public class CommonDeviceBusController
implements DeviceBusController {
    private static final int MAX_BUS_ELEMENT_COUNT = 128;
    private static final int INCOMPLETE_RETRY_INTERVAL = 200;
    private static final int BAD_CONFIGURATION_RETRY_INTERVAL = 100;
    public final Event onAfterBusScan = new Event();
    public final Event onBeforeScan = new Event();
    public final ParameterizedEvent<AfterDeviceScanEvent> onAfterDeviceScan = new ParameterizedEvent();
    public final ParameterizedEvent<DevicesChangedEvent> onDevicesAdded = new ParameterizedEvent();
    public final ParameterizedEvent<DevicesChangedEvent> onDevicesRemoved = new ParameterizedEvent();
    private final DeviceBusElement root;
    private final int baseEnergyConsumption;
    private final Set<DeviceBusElement> elements = new HashSet<DeviceBusElement>();
    private final HashSet<Device> devices = new HashSet();
    private final HashMap<Device, Set<UUID>> deviceIds = new HashMap();
    private BusState state = BusState.SCAN_PENDING;
    private int scanDelay;
    private int energyConsumption;

    public CommonDeviceBusController(DeviceBusElement root, int baseEnergyConsumption) {
        this.root = root;
        this.baseEnergyConsumption = baseEnergyConsumption;
    }

    public void dispose() {
        for (DeviceBusElement element : this.elements) {
            element.removeController(this);
            for (DeviceBusController controller : element.getControllers()) {
                controller.scheduleBusScan();
            }
        }
        this.elements.clear();
    }

    public BusState getState() {
        return this.state;
    }

    public int getEnergyConsumption() {
        return this.energyConsumption;
    }

    @Override
    public void scheduleBusScan() {
        this.scanDelay = 0;
        this.state = BusState.SCAN_PENDING;
    }

    @Override
    public void scanDevices() {
        boolean didDeviceIdsChange;
        boolean didDevicesChange;
        this.onBeforeScan();
        HashSet<Device> newDevices = new HashSet<Device>();
        HashMap newDeviceIds = new HashMap();
        for (DeviceBusElement element : this.elements) {
            for (Device device : element.getLocalDevices()) {
                newDevices.add(device);
                element.getDeviceIdentifier(device).ifPresent(identifier -> newDeviceIds.computeIfAbsent(device, unused -> new HashSet()).add(identifier));
            }
        }
        HashSet<Device> removedDevices = new HashSet<Device>(this.devices);
        removedDevices.removeAll(newDevices);
        this.onDevicesRemoved(removedDevices);
        HashSet<Device> addedDevices = new HashSet<Device>(newDevices);
        addedDevices.removeAll(this.devices);
        this.onDevicesAdded(addedDevices);
        boolean bl = didDevicesChange = !removedDevices.isEmpty() || !addedDevices.isEmpty();
        if (didDevicesChange) {
            this.devices.clear();
            this.devices.addAll(newDevices);
            didDeviceIdsChange = true;
        } else {
            didDeviceIdsChange = this.deviceIds.entrySet().stream().anyMatch(entry -> !Objects.equals(entry.getValue(), newDeviceIds.get(entry.getKey())));
        }
        if (didDeviceIdsChange) {
            this.deviceIds.clear();
            this.deviceIds.putAll(newDeviceIds);
        }
        this.onAfterDeviceScan(didDevicesChange || didDeviceIdsChange);
    }

    @Override
    public Set<Device> getDevices() {
        return this.devices;
    }

    @Override
    public Set<UUID> getDeviceIdentifiers(Device device) {
        return this.deviceIds.getOrDefault(device, Collections.emptySet());
    }

    public void scan() {
        if (this.scanDelay < 0) {
            return;
        }
        if (this.scanDelay-- > 0) {
            return;
        }
        assert (this.scanDelay == -1);
        this.clearElements();
        HashSet<DeviceBusElement> closed = new HashSet<DeviceBusElement>();
        Stack<DeviceBusElement> open = new Stack<DeviceBusElement>();
        ArrayList optionals = new ArrayList();
        closed.add(this.root);
        open.add(this.root);
        while (!open.isEmpty()) {
            DeviceBusElement element = (DeviceBusElement)open.pop();
            Optional<Collection<LazyOptional<DeviceBusElement>>> elementNeighbors = element.getNeighbors();
            if (!elementNeighbors.isPresent()) {
                this.scanDelay = 200;
                this.state = BusState.INCOMPLETE;
                return;
            }
            elementNeighbors.ifPresent(neighbors -> {
                for (LazyOptional neighbor : neighbors) {
                    neighbor.ifPresent(neighborElement -> {
                        if (closed.add((DeviceBusElement)neighborElement)) {
                            open.add((DeviceBusElement)neighborElement);
                            optionals.add(neighbor);
                        }
                    });
                }
            });
            if (closed.size() <= 128) continue;
            this.scanDelay = 100;
            this.state = BusState.TOO_COMPLEX;
            return;
        }
        HashSet<DeviceBusController> controllers = new HashSet<DeviceBusController>();
        for (DeviceBusElement element : closed) {
            controllers.addAll(element.getControllers());
            element.addController(this);
        }
        controllers.remove(this);
        this.elements.addAll(closed);
        if (!controllers.isEmpty()) {
            for (DeviceBusController controller : controllers) {
                controller.scheduleBusScan();
            }
            this.state = BusState.MULTIPLE_CONTROLLERS;
            this.scanDelay = 100;
            return;
        }
        for (LazyOptional optional : optionals) {
            assert (optional.isPresent());
            optional.addListener(unused -> this.scheduleBusScan());
        }
        this.onAfterBusScan();
        this.scanDevices();
        this.updateEnergyConsumption();
        this.state = BusState.READY;
    }

    protected Collection<DeviceBusElement> getElements() {
        return this.elements;
    }

    protected void onAfterBusScan() {
        this.onAfterBusScan.run();
    }

    protected void onBeforeScan() {
        this.onBeforeScan.run();
    }

    protected void onAfterDeviceScan(boolean didDevicesChange) {
        this.onAfterDeviceScan.accept(new AfterDeviceScanEvent(didDevicesChange));
    }

    protected void onDevicesAdded(Collection<Device> devices) {
        this.onDevicesAdded.accept(new DevicesChangedEvent(devices));
    }

    protected void onDevicesRemoved(Collection<Device> devices) {
        this.onDevicesRemoved.accept(new DevicesChangedEvent(devices));
    }

    private void clearElements() {
        for (DeviceBusElement element : this.elements) {
            element.removeController(this);
        }
        this.elements.clear();
    }

    private void updateEnergyConsumption() {
        double accumulator = this.baseEnergyConsumption;
        for (DeviceBusElement element : this.elements) {
            accumulator += Math.max(0.0, element.getEnergyConsumption());
        }
        this.energyConsumption = accumulator > 2.147483647E9 ? Integer.MAX_VALUE : (int)accumulator;
    }

    public static final class DevicesChangedEvent {
        public final Collection<Device> devices;

        public DevicesChangedEvent(Collection<Device> devices) {
            this.devices = devices;
        }
    }

    public static final class AfterDeviceScanEvent {
        public final boolean didDevicesChange;

        public AfterDeviceScanEvent(boolean didDevicesChange) {
            this.didDevicesChange = didDevicesChange;
        }
    }

    public static enum BusState {
        SCAN_PENDING,
        INCOMPLETE,
        TOO_COMPLEX,
        MULTIPLE_CONTROLLERS,
        READY;

    }
}

