/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.bus;

import java.util.Collections;
import java.util.HashSet;
import java.util.function.Function;
import li.cil.oc2.api.bus.device.ItemDevice;
import li.cil.oc2.api.bus.device.provider.ItemDeviceQuery;
import li.cil.oc2.api.bus.device.rpc.RPCDevice;
import li.cil.oc2.common.bus.AbstractGroupingItemDeviceBusElement;
import li.cil.oc2.common.bus.device.rpc.TypeNameRPCDevice;
import li.cil.oc2.common.bus.device.util.Devices;
import li.cil.oc2.common.bus.device.util.ItemDeviceInfo;
import li.cil.oc2.common.util.ItemDeviceUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;

public final class ItemHandlerDeviceBusElement
extends AbstractGroupingItemDeviceBusElement {
    private final Function<ItemStack, ItemDeviceQuery> queryFactory;

    public ItemHandlerDeviceBusElement(int slotCount, Function<ItemStack, ItemDeviceQuery> queryFactory) {
        super(slotCount);
        this.queryFactory = queryFactory;
    }

    public void updateDevices(int slot, ItemStack stack) {
        if (!stack.func_190926_b()) {
            ItemDeviceQuery query = this.queryFactory.apply(stack);
            HashSet<ItemDeviceInfo> newDevices = new HashSet<ItemDeviceInfo>(Devices.getDevices(query));
            this.insertItemNameDevice(stack, newDevices);
            this.importDeviceDataFromItemStack(stack, newDevices);
            this.setDevicesForGroup(slot, newDevices);
        } else {
            this.setDevicesForGroup(slot, Collections.emptySet());
        }
    }

    public void exportDeviceDataToItemStack(int slot, ItemStack stack) {
        if (stack.func_190926_b()) {
            return;
        }
        CompoundNBT exportedTag = new CompoundNBT();
        for (ItemDeviceInfo info : (HashSet)this.groups.get(slot)) {
            ItemDeviceUtils.getItemDeviceDataKey(info.provider).ifPresent(key -> {
                CompoundNBT deviceTag = new CompoundNBT();
                ((ItemDevice)info.device).exportToItemStack(deviceTag);
                if (!deviceTag.isEmpty()) {
                    exportedTag.func_218657_a(key, (INBT)deviceTag);
                }
            });
        }
        if (!exportedTag.isEmpty()) {
            ItemDeviceUtils.setItemDeviceData(stack, exportedTag);
        }
    }

    private void importDeviceDataFromItemStack(ItemStack stack, HashSet<ItemDeviceInfo> devices) {
        CompoundNBT exportedTag = ItemDeviceUtils.getItemDeviceData(stack);
        if (!exportedTag.isEmpty()) {
            for (ItemDeviceInfo info : devices) {
                ItemDeviceUtils.getItemDeviceDataKey(info.provider).ifPresent(key -> {
                    if (exportedTag.func_150297_b(key, 10)) {
                        ((ItemDevice)info.device).importFromItemStack(exportedTag.func_74775_l(key));
                    }
                });
            }
        }
    }

    private void insertItemNameDevice(ItemStack stack, HashSet<ItemDeviceInfo> devices) {
        ResourceLocation registryName;
        if (devices.stream().anyMatch(info -> info.device instanceof RPCDevice) && (registryName = stack.func_77973_b().getRegistryName()) != null) {
            devices.add(new ItemDeviceInfo(null, new TypeNameRPCDevice(registryName.toString()), 0));
        }
    }
}

