/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.bus;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import li.cil.ceres.api.Serialized;
import li.cil.oc2.api.bus.DeviceBusController;
import li.cil.oc2.api.bus.device.Device;
import li.cil.oc2.api.bus.device.rpc.RPCDevice;
import li.cil.oc2.api.bus.device.rpc.RPCMethod;
import li.cil.oc2.api.bus.device.rpc.RPCParameter;
import li.cil.oc2.common.bus.device.rpc.RPCDeviceList;
import li.cil.oc2.common.bus.device.rpc.RPCMethodParameterTypeAdapters;
import li.cil.oc2.common.serialization.serializers.MessageJsonDeserializer;
import li.cil.oc2.common.serialization.serializers.MethodInvocationJsonDeserializer;
import li.cil.oc2.common.serialization.serializers.RPCDeviceWithIdentifierJsonSerializer;
import li.cil.oc2.common.serialization.serializers.RPCMethodJsonSerializer;
import li.cil.oc2.common.serialization.serializers.UnsignedByteArrayJsonSerializer;
import li.cil.sedna.api.device.Steppable;
import li.cil.sedna.api.device.serial.SerialDevice;

public final class RPCDeviceBusAdapter
implements Steppable {
    private static final int DEFAULT_MAX_MESSAGE_SIZE = 4096;
    private static final byte[] MESSAGE_DELIMITER = "\u0000".getBytes();
    public static final String ERROR_MESSAGE_TOO_LARGE = "message too large";
    public static final String ERROR_UNKNOWN_MESSAGE_TYPE = "unknown message type";
    public static final String ERROR_UNKNOWN_DEVICE = "unknown device";
    public static final String ERROR_UNKNOWN_METHOD = "unknown method";
    public static final String ERROR_INVALID_PARAMETER_SIGNATURE = "invalid parameter signature";
    private final SerialDevice serialDevice;
    private final Gson gson;
    private final ArrayList<RPCDeviceWithIdentifier> devices = new ArrayList();
    private final HashMap<UUID, RPCDeviceList> devicesById = new HashMap();
    private final Lock pauseLock = new ReentrantLock();
    private boolean isPaused;
    @Serialized
    private final ByteBuffer transmitBuffer;
    @Serialized
    private ByteBuffer receiveBuffer;
    @Serialized
    private MethodInvocation synchronizedInvocation;

    public RPCDeviceBusAdapter(SerialDevice serialDevice) {
        this(serialDevice, 4096);
    }

    public RPCDeviceBusAdapter(SerialDevice serialDevice, int maxMessageSize) {
        this.serialDevice = serialDevice;
        this.transmitBuffer = ByteBuffer.allocate(maxMessageSize);
        this.gson = RPCMethodParameterTypeAdapters.beginBuildGson().registerTypeAdapter(byte[].class, (Object)new UnsignedByteArrayJsonSerializer()).registerTypeAdapter(MethodInvocation.class, (Object)new MethodInvocationJsonDeserializer()).registerTypeAdapter(Message.class, (Object)new MessageJsonDeserializer()).registerTypeAdapter(RPCDeviceWithIdentifier.class, (Object)new RPCDeviceWithIdentifierJsonSerializer()).registerTypeHierarchyAdapter(RPCMethod.class, (Object)new RPCMethodJsonSerializer()).create();
    }

    public void suspend() {
        for (RPCDeviceWithIdentifier info : this.devices) {
            info.device.suspend();
        }
    }

    public void reset() {
        this.transmitBuffer.clear();
        this.receiveBuffer = null;
        this.synchronizedInvocation = null;
    }

    public void pause() {
        if (this.isPaused) {
            return;
        }
        this.pauseLock.lock();
        this.isPaused = true;
        this.pauseLock.unlock();
    }

    public void resume(DeviceBusController controller, boolean didDevicesChange) {
        this.isPaused = false;
        if (!didDevicesChange) {
            return;
        }
        this.devices.clear();
        this.devicesById.clear();
        HashMap<UUID, ArrayList> devicesByIdentifier = new HashMap<UUID, ArrayList>();
        for (Device device2 : controller.getDevices()) {
            if (!(device2 instanceof RPCDevice)) continue;
            RPCDevice rpcDevice = (RPCDevice)device2;
            Set<UUID> identifiers2 = controller.getDeviceIdentifiers(device2);
            for (UUID identifier2 : identifiers2) {
                devicesByIdentifier.computeIfAbsent(identifier2, unused -> new ArrayList()).add(rpcDevice);
            }
        }
        HashMap<RPCDeviceList, ArrayList> identifiersByDevice = new HashMap<RPCDeviceList, ArrayList>();
        devicesByIdentifier.forEach((identifier, devices) -> {
            RPCDeviceList device = new RPCDeviceList((ArrayList<RPCDevice>)devices);
            if (device.getMethods().isEmpty()) {
                return;
            }
            identifiersByDevice.computeIfAbsent(device, unused -> new ArrayList()).add(identifier);
        });
        identifiersByDevice.forEach((device, identifiers) -> {
            UUID identifier = this.selectIdentifierDeterministically((ArrayList<UUID>)identifiers);
            this.devices.add(new RPCDeviceWithIdentifier(identifier, (RPCDevice)device));
            this.devicesById.put(identifier, (RPCDeviceList)device);
        });
    }

    public void tick() {
        if (this.isPaused) {
            return;
        }
        if (this.synchronizedInvocation != null) {
            MethodInvocation methodInvocation = this.synchronizedInvocation;
            this.processMethodInvocation(methodInvocation, true);
            this.synchronizedInvocation = null;
        }
    }

    public void step(int cycles) {
        if (this.isPaused || !this.pauseLock.tryLock()) {
            return;
        }
        try {
            this.readFromDevice();
            this.writeToDevice();
        }
        finally {
            this.pauseLock.unlock();
        }
    }

    private UUID selectIdentifierDeterministically(ArrayList<UUID> identifiers) {
        UUID lowestIdentifier = identifiers.get(0);
        for (int i = 1; i < identifiers.size(); ++i) {
            UUID identifier = identifiers.get(i);
            if (identifier.compareTo(lowestIdentifier) >= 0) continue;
            lowestIdentifier = identifier;
        }
        return lowestIdentifier;
    }

    private void readFromDevice() {
        int value;
        while (this.receiveBuffer == null && this.synchronizedInvocation == null && (value = this.serialDevice.read()) >= 0) {
            if (value == 0) {
                if (this.transmitBuffer.limit() > 0) {
                    this.transmitBuffer.flip();
                    if (this.transmitBuffer.hasRemaining()) {
                        byte[] message = new byte[this.transmitBuffer.remaining()];
                        this.transmitBuffer.get(message);
                        this.processMessage(message);
                    }
                } else {
                    this.writeError(ERROR_MESSAGE_TOO_LARGE);
                }
                this.transmitBuffer.clear();
                continue;
            }
            if (this.transmitBuffer.hasRemaining()) {
                this.transmitBuffer.put((byte)value);
                continue;
            }
            this.transmitBuffer.clear();
            this.transmitBuffer.limit(0);
        }
    }

    private void writeToDevice() {
        if (this.receiveBuffer == null) {
            return;
        }
        while (this.receiveBuffer.hasRemaining() && this.serialDevice.canPutByte()) {
            this.serialDevice.putByte(this.receiveBuffer.get());
        }
        this.serialDevice.flush();
        if (!this.receiveBuffer.hasRemaining()) {
            this.receiveBuffer = null;
        }
    }

    private void processMessage(byte[] messageData) {
        if (new String(messageData).trim().isEmpty()) {
            return;
        }
        InputStreamReader stream = new InputStreamReader(new ByteArrayInputStream(messageData));
        try {
            Message message = (Message)this.gson.fromJson((Reader)stream, Message.class);
            switch (message.type) {
                case "list": {
                    this.writeDeviceList();
                    break;
                }
                case "methods": {
                    if (message.data != null) {
                        this.writeDeviceMethods((UUID)message.data);
                        break;
                    }
                    this.writeError("missing device id");
                    break;
                }
                case "invoke": {
                    if (message.data != null) {
                        this.processMethodInvocation((MethodInvocation)message.data, false);
                        break;
                    }
                    this.writeError("missing invocation data");
                    break;
                }
                default: {
                    this.writeError(ERROR_UNKNOWN_MESSAGE_TYPE);
                    break;
                }
            }
        }
        catch (Throwable e) {
            this.writeError(e.getMessage());
        }
    }

    private void processMethodInvocation(MethodInvocation methodInvocation, boolean isMainThread) {
        RPCMethod method;
        Object[] parameters;
        RPCDevice device = this.devicesById.get(methodInvocation.deviceId);
        if (device == null) {
            this.writeError(ERROR_UNKNOWN_DEVICE);
            return;
        }
        ArrayList<RPCMethod> fallbacks = new ArrayList<RPCMethod>();
        String error = ERROR_UNKNOWN_METHOD;
        for (RPCMethod method2 : device.getMethods()) {
            if (!Objects.equals(method2.getName(), methodInvocation.methodName)) continue;
            RPCParameter[] parametersSpec = method2.getParameters();
            if (parametersSpec.length == 1 && parametersSpec[0].getType() == JsonArray.class) {
                this.invokeMethod(methodInvocation, isMainThread, method2, new Object[]{methodInvocation.parameters});
                return;
            }
            if (methodInvocation.parameters.size() != parametersSpec.length) {
                if (this.canTrailingParametersBeImplicitlyNull(methodInvocation.parameters, parametersSpec)) {
                    fallbacks.add(method2);
                }
                error = ERROR_INVALID_PARAMETER_SIGNATURE;
                continue;
            }
            Object[] parameters2 = this.getParameters(methodInvocation.parameters, parametersSpec);
            if (parameters2 == null) {
                error = ERROR_INVALID_PARAMETER_SIGNATURE;
                continue;
            }
            this.invokeMethod(methodInvocation, isMainThread, method2, parameters2);
            return;
        }
        if (fallbacks.size() == 1 && (parameters = this.getParameters(methodInvocation.parameters, (method = (RPCMethod)fallbacks.get(0)).getParameters())) != null) {
            this.invokeMethod(methodInvocation, isMainThread, method, parameters);
            return;
        }
        this.writeError(error);
    }

    private void invokeMethod(MethodInvocation methodInvocation, boolean isMainThread, RPCMethod method, Object[] parameters) {
        if (method.isSynchronized() && !isMainThread) {
            this.synchronizedInvocation = methodInvocation;
            return;
        }
        try {
            Object result = method.invoke(parameters);
            this.writeMessage("result", result);
        }
        catch (Throwable e) {
            this.writeError(e.getMessage() != null ? e.getMessage() : e.getClass().getSimpleName());
        }
    }

    @Nullable
    private Object[] getParameters(JsonArray parameters, RPCParameter[] parametersSpec) {
        Object[] result = new Object[parametersSpec.length];
        for (int i = 0; i < parametersSpec.length; ++i) {
            RPCParameter parameterInfo = parametersSpec[i];
            if (parameters.size() > i) {
                try {
                    result[i] = this.gson.fromJson(parameters.get(i), parameterInfo.getType());
                    continue;
                }
                catch (Throwable e) {
                    return null;
                }
            }
            result[i] = null;
        }
        return result;
    }

    private boolean canTrailingParametersBeImplicitlyNull(JsonArray parameters, RPCParameter[] parametersSpec) {
        if (parameters.size() > parametersSpec.length) {
            return false;
        }
        for (int i = parameters.size(); i < parametersSpec.length; ++i) {
            Class<?> type = parametersSpec[i].getType();
            if (!type.isPrimitive()) continue;
            return false;
        }
        return true;
    }

    private void writeDeviceList() {
        this.writeMessage("list", this.devices);
    }

    private void writeDeviceMethods(UUID deviceId) {
        RPCDeviceList device = this.devicesById.get(deviceId);
        if (device != null) {
            this.writeMessage("methods", device.getMethods());
        } else {
            this.writeError(ERROR_UNKNOWN_DEVICE);
        }
    }

    private void writeError(String message) {
        this.writeMessage("error", message);
    }

    private void writeMessage(String type, @Nullable Object data) {
        if (this.receiveBuffer != null) {
            throw new IllegalStateException();
        }
        String json = this.gson.toJson((Object)new Message(type, data));
        byte[] bytes = json.getBytes();
        ByteBuffer receiveBuffer = ByteBuffer.allocate(bytes.length + MESSAGE_DELIMITER.length * 2);
        receiveBuffer.put(MESSAGE_DELIMITER);
        receiveBuffer.put(bytes);
        receiveBuffer.put(MESSAGE_DELIMITER);
        receiveBuffer.flip();
        this.receiveBuffer = receiveBuffer;
    }

    @Serialized
    public static final class MethodInvocation {
        public UUID deviceId;
        public String methodName;
        public JsonArray parameters;

        public MethodInvocation() {
        }

        public MethodInvocation(UUID deviceId, String methodName, JsonArray parameters) {
            this.deviceId = deviceId;
            this.methodName = methodName;
            this.parameters = parameters;
        }
    }

    public static final class Message {
        public static final String MESSAGE_TYPE_LIST = "list";
        public static final String MESSAGE_TYPE_METHODS = "methods";
        public static final String MESSAGE_TYPE_RESULT = "result";
        public static final String MESSAGE_TYPE_ERROR = "error";
        public static final String MESSAGE_TYPE_INVOKE_METHOD = "invoke";
        public final String type;
        @Nullable
        public final Object data;

        public Message(String type, @Nullable Object data) {
            this.type = type;
            this.data = data;
        }
    }

    public static final class RPCDeviceWithIdentifier {
        public final UUID identifier;
        public final RPCDevice device;

        private RPCDeviceWithIdentifier(UUID identifier, RPCDevice device) {
            this.identifier = identifier;
            this.device = device;
        }
    }
}

