/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.bus;

import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import li.cil.oc2.api.bus.BlockDeviceBusElement;
import li.cil.oc2.api.bus.DeviceBusElement;
import li.cil.oc2.common.bus.CommonDeviceBusController;
import li.cil.oc2.common.util.ServerScheduler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public final class TileEntityDeviceBusController
extends CommonDeviceBusController {
    private final Runnable onBusChunkLoadedStateChanged = this::scheduleBusScan;
    private final HashSet<TrackedChunk> trackedChunks = new HashSet();
    private final TileEntity tileEntity;

    public TileEntityDeviceBusController(DeviceBusElement root, int baseEnergyConsumption, TileEntity tileEntity) {
        super(root, baseEnergyConsumption);
        this.tileEntity = tileEntity;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.removeListeners(this.trackedChunks);
        this.trackedChunks.clear();
    }

    @Override
    protected void onAfterBusScan() {
        super.onAfterBusScan();
        World world = this.tileEntity.func_145831_w();
        if (world == null) {
            return;
        }
        HashSet<TrackedChunk> newTrackedChunks = new HashSet<TrackedChunk>();
        for (DeviceBusElement element : this.getElements()) {
            if (!(element instanceof BlockDeviceBusElement)) continue;
            BlockDeviceBusElement blockElement = (BlockDeviceBusElement)element;
            IWorld elementWorld = blockElement.getLevel();
            BlockPos elementPosition = blockElement.getPosition();
            newTrackedChunks.add(new TrackedChunk(elementWorld, elementPosition));
            newTrackedChunks.add(new TrackedChunk(elementWorld, elementPosition.func_177972_a(Direction.NORTH)));
            newTrackedChunks.add(new TrackedChunk(elementWorld, elementPosition.func_177972_a(Direction.EAST)));
            newTrackedChunks.add(new TrackedChunk(elementWorld, elementPosition.func_177972_a(Direction.SOUTH)));
            newTrackedChunks.add(new TrackedChunk(elementWorld, elementPosition.func_177972_a(Direction.WEST)));
        }
        newTrackedChunks.remove(new TrackedChunk((IWorld)world, this.tileEntity.func_174877_v()));
        HashSet<TrackedChunk> removedChunks = new HashSet<TrackedChunk>(this.trackedChunks);
        removedChunks.removeAll(newTrackedChunks);
        this.removeListeners(removedChunks);
        HashSet<TrackedChunk> addedChunks = new HashSet<TrackedChunk>(newTrackedChunks);
        newTrackedChunks.removeAll(this.trackedChunks);
        this.addListeners(addedChunks);
        this.trackedChunks.removeAll(removedChunks);
        this.trackedChunks.addAll(newTrackedChunks);
    }

    private void addListeners(Collection<TrackedChunk> trackedChunks) {
        for (TrackedChunk trackedChunk : trackedChunks) {
            IWorld world = (IWorld)trackedChunk.world.get();
            ServerScheduler.scheduleOnLoad(world, trackedChunk.position, this.onBusChunkLoadedStateChanged);
            ServerScheduler.scheduleOnUnload(world, trackedChunk.position, this.onBusChunkLoadedStateChanged);
        }
    }

    private void removeListeners(Collection<TrackedChunk> trackedChunks) {
        for (TrackedChunk trackedChunk : trackedChunks) {
            IWorld world = (IWorld)trackedChunk.world.get();
            if (world == null) continue;
            ServerScheduler.cancelOnLoad(world, trackedChunk.position, this.onBusChunkLoadedStateChanged);
            ServerScheduler.cancelOnUnload(world, trackedChunk.position, this.onBusChunkLoadedStateChanged);
        }
    }

    private static final class TrackedChunk {
        public final WeakReference<IWorld> world;
        public final ChunkPos position;

        private TrackedChunk(IWorld world, BlockPos position) {
            this.world = new WeakReference<IWorld>(world);
            this.position = new ChunkPos(position);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TrackedChunk that = (TrackedChunk)o;
            return this.world.equals(that.world) && this.position.equals((Object)that.position);
        }

        public int hashCode() {
            return Objects.hash(this.world, this.position);
        }
    }
}

