/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.bus;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import li.cil.oc2.api.bus.BlockDeviceBusElement;
import li.cil.oc2.api.bus.DeviceBus;
import li.cil.oc2.api.bus.DeviceBusElement;
import li.cil.oc2.api.bus.device.provider.BlockDeviceQuery;
import li.cil.oc2.common.Constants;
import li.cil.oc2.common.bus.AbstractGroupingBlockDeviceBusElement;
import li.cil.oc2.common.bus.device.rpc.TypeNameRPCDevice;
import li.cil.oc2.common.bus.device.util.BlockDeviceInfo;
import li.cil.oc2.common.bus.device.util.Devices;
import li.cil.oc2.common.capabilities.Capabilities;
import li.cil.oc2.common.util.ServerScheduler;
import li.cil.oc2.common.util.WorldUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;

public class TileEntityDeviceBusElement
extends AbstractGroupingBlockDeviceBusElement
implements BlockDeviceBusElement {
    private final TileEntity tileEntity;

    public TileEntityDeviceBusElement(TileEntity tileEntity) {
        super(Constants.BLOCK_FACE_COUNT);
        this.tileEntity = tileEntity;
    }

    @Override
    public IWorld getLevel() {
        return this.tileEntity.func_145831_w();
    }

    @Override
    public BlockPos getPosition() {
        return this.tileEntity.func_174877_v();
    }

    @Override
    public Optional<Collection<LazyOptional<DeviceBusElement>>> getNeighbors() {
        World world = this.tileEntity.func_145831_w();
        if (world == null || world.func_201670_d()) {
            return Optional.empty();
        }
        ArrayList<LazyOptional> neighbors = new ArrayList<LazyOptional>();
        for (Direction neighborDirection : Constants.DIRECTIONS) {
            LazyOptional capability;
            if (!this.canScanContinueTowards(neighborDirection)) continue;
            BlockPos neighborPos = this.tileEntity.func_174877_v().func_177972_a(neighborDirection);
            ChunkPos chunkPos = new ChunkPos(neighborPos);
            if (!world.func_217354_b(chunkPos.field_77276_a, chunkPos.field_77275_b)) {
                return Optional.empty();
            }
            TileEntity tileEntity = world.func_175625_s(neighborPos);
            if (tileEntity == null || !(capability = tileEntity.getCapability(Capabilities.DEVICE_BUS_ELEMENT, neighborDirection.func_176734_d())).isPresent()) continue;
            neighbors.add(capability);
        }
        return Optional.of(neighbors);
    }

    public void handleNeighborChanged(BlockPos pos) {
        World world = this.tileEntity.func_145831_w();
        if (world == null || world.func_201670_d()) {
            return;
        }
        BlockPos toPos = pos.func_177973_b((Vector3i)this.tileEntity.func_174877_v());
        Direction direction = Direction.func_218383_a((int)toPos.func_177958_n(), (int)toPos.func_177956_o(), (int)toPos.func_177952_p());
        if (direction == null) {
            return;
        }
        HashSet<BlockDeviceInfo> newDevices = this.collectDevices(world, pos, direction);
        int index = direction.func_176745_a();
        this.setDevicesForGroup(index, newDevices);
    }

    public void initialize() {
        World world = Objects.requireNonNull(this.tileEntity.func_145831_w());
        ServerScheduler.schedule((IWorld)world, () -> {
            if (this.tileEntity.func_145837_r()) {
                return;
            }
            this.scanNeighborsForDevices();
            this.scheduleBusScanInAdjacentBusElements();
        });
    }

    protected boolean canScanContinueTowards(@Nullable Direction direction) {
        return true;
    }

    protected boolean canDetectDevicesTowards(@Nullable Direction direction) {
        return this.canScanContinueTowards(direction);
    }

    protected HashSet<BlockDeviceInfo> collectDevices(World world, BlockPos pos, @Nullable Direction direction) {
        HashSet<BlockDeviceInfo> newDevices = new HashSet<BlockDeviceInfo>();
        if (this.canDetectDevicesTowards(direction)) {
            BlockDeviceQuery query = Devices.makeQuery(world, pos, direction);
            for (LazyOptional<BlockDeviceInfo> deviceInfo : Devices.getDevices(query)) {
                deviceInfo.ifPresent(newDevices::add);
                deviceInfo.addListener(unused -> this.handleNeighborChanged(pos));
            }
        }
        this.collectSyntheticDevices(world, pos, direction, newDevices);
        return newDevices;
    }

    protected void collectSyntheticDevices(World world, BlockPos pos, @Nullable Direction direction, HashSet<BlockDeviceInfo> devices) {
        String blockName = WorldUtils.getBlockName((IWorld)world, pos);
        if (blockName != null) {
            devices.add(new BlockDeviceInfo(null, new TypeNameRPCDevice(blockName)));
        }
    }

    private void scanNeighborsForDevices() {
        for (Direction direction : Constants.DIRECTIONS) {
            this.handleNeighborChanged(this.tileEntity.func_174877_v().func_177972_a(direction));
        }
    }

    private void scheduleBusScanInAdjacentBusElements() {
        World world = Objects.requireNonNull(this.tileEntity.func_145831_w());
        BlockPos pos = this.tileEntity.func_174877_v();
        for (Direction direction : Constants.DIRECTIONS) {
            BlockPos neighborPos = pos.func_177972_a(direction);
            TileEntity tileEntity = WorldUtils.getBlockEntityIfChunkExists((IWorld)world, neighborPos);
            if (tileEntity == null) continue;
            LazyOptional capability = tileEntity.getCapability(Capabilities.DEVICE_BUS_ELEMENT, direction.func_176734_d());
            capability.ifPresent(DeviceBus::scheduleScan);
        }
    }
}

