/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.bus.device.data;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import li.cil.oc2.common.vm.fs.LayeredFileSystem;
import li.cil.sedna.fs.FileSystem;
import li.cil.sedna.fs.ZipStreamFileSystem;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class FileSystems {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final LayeredFileSystem LAYERED_FILE_SYSTEM = new LayeredFileSystem();

    public static void initialize() {
        MinecraftForge.EVENT_BUS.addListener(FileSystems::handleAddReloadListenerEvent);
    }

    public static FileSystem getLayeredFileSystem() {
        return LAYERED_FILE_SYSTEM;
    }

    public static void reset() {
        LAYERED_FILE_SYSTEM.clear();
    }

    private static void handleAddReloadListenerEvent(AddReloadListenerEvent event) {
        event.addListener((IFutureReloadListener)ReloadListener.INSTANCE);
    }

    private static void reload(IResourceManager resourceManager) {
        FileSystems.reset();
        LOGGER.info("Searching for datapack filesystems...");
        Collection fileSystemDescriptorLocations = resourceManager.func_199003_a("file_systems", s -> s.endsWith(".json"));
        ArrayList<ZipStreamFileSystem> fileSystems = new ArrayList<ZipStreamFileSystem>();
        Object2IntArrayMap fileSystemOrder = new Object2IntArrayMap();
        for (ResourceLocation fileSystemDescriptorLocation : fileSystemDescriptorLocations) {
            LOGGER.info("Found [{}]", (Object)fileSystemDescriptorLocation);
            try {
                String type;
                IResource fileSystemDescriptor = resourceManager.func_199002_a(fileSystemDescriptorLocation);
                JsonObject json = new JsonParser().parse((Reader)new InputStreamReader(fileSystemDescriptor.func_199027_b())).getAsJsonObject();
                switch (type = json.getAsJsonPrimitive("type").getAsString()) {
                    case "layer": {
                        ZipStreamFileSystem fileSystem;
                        ResourceLocation location = new ResourceLocation(json.getAsJsonPrimitive("location").getAsString());
                        try (InputStream stream = resourceManager.func_199002_a(location).func_199027_b();){
                            fileSystem = new ZipStreamFileSystem(stream);
                        }
                        long fileCount = fileSystem.statfs().fileCount;
                        if (fileCount > 0L) {
                            LOGGER.info("  Adding layer with [{}] file(s).", (Object)fileCount);
                            fileSystems.add(fileSystem);
                        } else {
                            LOGGER.info("  Skipping empty layer.");
                        }
                        if (json.has("order")) {
                            JsonPrimitive order = json.getAsJsonPrimitive("order");
                            fileSystemOrder.put((Object)fileSystem, order.getAsInt());
                            break;
                        }
                        fileSystemOrder.put((Object)fileSystem, 0);
                        break;
                    }
                    case "block": {
                        LOGGER.error("Not yet implemented.");
                        break;
                    }
                    default: {
                        LOGGER.error("Unsupported file system type [{}].", (Object)type);
                        break;
                    }
                }
            }
            catch (Throwable e) {
                LOGGER.error((Object)e);
            }
        }
        fileSystems.sort(Comparator.comparingInt(arg_0 -> ((Object2IntArrayMap)fileSystemOrder).getInt(arg_0)));
        fileSystems.forEach(LAYERED_FILE_SYSTEM::addLayer);
    }

    private static final class ReloadListener
    implements IFutureReloadListener {
        public static final ReloadListener INSTANCE = new ReloadListener();

        private ReloadListener() {
        }

        public CompletableFuture<Void> func_215226_a(IFutureReloadListener.IStage stage, IResourceManager resourceManager, IProfiler preparationsProfiler, IProfiler reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
            return CompletableFuture.runAsync(() -> FileSystems.reload(resourceManager), backgroundExecutor).thenCompose(arg_0 -> ((IFutureReloadListener.IStage)stage).func_216872_a(arg_0));
        }
    }
}

