/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.bus.device.item;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import javax.annotation.Nullable;
import li.cil.oc2.api.bus.device.ItemDevice;
import li.cil.oc2.api.bus.device.vm.VMDevice;
import li.cil.oc2.api.bus.device.vm.VMDeviceLoadResult;
import li.cil.oc2.api.bus.device.vm.context.VMContext;
import li.cil.oc2.common.Constants;
import li.cil.oc2.common.bus.device.util.IdentityProxy;
import li.cil.oc2.common.bus.device.util.OptionalAddress;
import li.cil.oc2.common.bus.device.util.OptionalInterrupt;
import li.cil.oc2.common.serialization.BlobStorage;
import li.cil.oc2.common.serialization.NBTSerialization;
import li.cil.oc2.common.util.Event;
import li.cil.sedna.api.device.BlockDevice;
import li.cil.sedna.api.device.MemoryMappedDevice;
import li.cil.sedna.device.virtio.VirtIOBlockDevice;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractBlockDeviceVMDevice<TBlock extends BlockDevice, TIdentity>
extends IdentityProxy<TIdentity>
implements VMDevice,
ItemDevice {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String DEVICE_TAG_NAME = "device";
    private static final String ADDRESS_TAG_NAME = "address";
    private static final String INTERRUPT_TAG_NAME = "interrupt";
    private static final String BLOB_HANDLE_TAG_NAME = "blob";
    protected VirtIOBlockDevice device;
    private final OptionalAddress address = new OptionalAddress();
    private final OptionalInterrupt interrupt = new OptionalInterrupt();
    private CompoundNBT deviceTag;
    @Nullable
    protected UUID blobHandle;

    protected AbstractBlockDeviceVMDevice(TIdentity identity) {
        super(identity);
    }

    @Override
    public VMDeviceLoadResult mount(VMContext context) {
        if (!this.allocateDevice(context)) {
            return VMDeviceLoadResult.fail();
        }
        if (!this.address.claim(context, (MemoryMappedDevice)this.device)) {
            return VMDeviceLoadResult.fail();
        }
        if (!this.interrupt.claim(context)) {
            return VMDeviceLoadResult.fail();
        }
        this.device.getInterrupt().set(this.interrupt.getAsInt(), context.getInterruptController());
        context.getEventBus().register(this);
        if (this.deviceTag != null) {
            NBTSerialization.deserialize(this.deviceTag, this.device);
        }
        return VMDeviceLoadResult.success();
    }

    @Override
    public void unmount() {
        this.suspend();
        this.deviceTag = null;
        this.address.clear();
        this.interrupt.clear();
    }

    @Override
    public void suspend() {
        if (this.device != null) {
            try {
                this.device.close();
            }
            catch (IOException e) {
                LOGGER.error((Object)e);
            }
        }
        if (this.blobHandle != null) {
            BlobStorage.close(this.blobHandle);
        }
        this.device = null;
    }

    @Override
    public void exportToItemStack(CompoundNBT nbt) {
        if (this.blobHandle != null) {
            nbt.func_186854_a(BLOB_HANDLE_TAG_NAME, this.blobHandle);
        }
    }

    @Override
    public void importFromItemStack(CompoundNBT nbt) {
        if (nbt.func_186855_b(BLOB_HANDLE_TAG_NAME)) {
            this.blobHandle = nbt.func_186857_a(BLOB_HANDLE_TAG_NAME);
        }
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT tag = new CompoundNBT();
        if (this.blobHandle != null) {
            tag.func_186854_a(BLOB_HANDLE_TAG_NAME, this.blobHandle);
        }
        if (this.device != null) {
            this.deviceTag = NBTSerialization.serialize(this.device);
        }
        if (this.deviceTag != null) {
            tag.func_218657_a(DEVICE_TAG_NAME, (INBT)this.deviceTag);
        }
        if (this.address.isPresent()) {
            tag.func_74772_a(ADDRESS_TAG_NAME, this.address.getAsLong());
        }
        if (this.interrupt.isPresent()) {
            tag.func_74768_a(INTERRUPT_TAG_NAME, this.interrupt.getAsInt());
        }
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundNBT tag) {
        if (tag.func_186855_b(BLOB_HANDLE_TAG_NAME)) {
            this.blobHandle = tag.func_186857_a(BLOB_HANDLE_TAG_NAME);
        }
        if (tag.func_150297_b(DEVICE_TAG_NAME, 10)) {
            this.deviceTag = tag.func_74775_l(DEVICE_TAG_NAME);
        }
        if (tag.func_150297_b(ADDRESS_TAG_NAME, 4)) {
            this.address.set(tag.func_74763_f(ADDRESS_TAG_NAME));
        }
        if (tag.func_150297_b(INTERRUPT_TAG_NAME, 3)) {
            this.interrupt.set(tag.func_74762_e(INTERRUPT_TAG_NAME));
        }
    }

    protected abstract TBlock createBlockDevice() throws IOException;

    protected void handleDataAccess() {
    }

    private boolean allocateDevice(VMContext context) {
        if (!context.getMemoryAllocator().claimMemory(Constants.PAGE_SIZE)) {
            return false;
        }
        try {
            ListenableBlockDevice listenableData = new ListenableBlockDevice((BlockDevice)this.createBlockDevice());
            listenableData.onAccess.add(this::handleDataAccess);
            this.device = new VirtIOBlockDevice(context.getMemoryMap(), (BlockDevice)listenableData);
        }
        catch (IOException e) {
            LOGGER.error((Object)e);
            return false;
        }
        return true;
    }

    private static final class ListenableOutputStream
    extends OutputStream {
        private final OutputStream inner;
        public final Event onAccess = new Event();

        private ListenableOutputStream(OutputStream inner) {
            this.inner = inner;
        }

        @Override
        public void write(int b) throws IOException {
            this.onAccess();
            this.inner.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.onAccess();
            this.inner.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.onAccess();
            this.inner.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.inner.flush();
        }

        @Override
        public void close() throws IOException {
            this.inner.close();
        }

        private void onAccess() {
            this.onAccess.run();
        }
    }

    private static final class ListenableInputStream
    extends InputStream {
        private final InputStream inner;
        public final Event onAccess = new Event();

        private ListenableInputStream(InputStream inner) {
            this.inner = inner;
        }

        @Override
        public int read() throws IOException {
            this.onAccess();
            return this.inner.read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            this.onAccess();
            return this.inner.read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            this.onAccess();
            return this.inner.read(b, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            this.onAccess();
            return this.inner.skip(n);
        }

        @Override
        public int available() throws IOException {
            return this.inner.available();
        }

        @Override
        public void close() throws IOException {
            this.inner.close();
        }

        @Override
        public synchronized void mark(int limit) {
            this.inner.mark(limit);
        }

        @Override
        public synchronized void reset() throws IOException {
            this.onAccess();
            this.inner.reset();
        }

        @Override
        public boolean markSupported() {
            return this.inner.markSupported();
        }

        private void onAccess() {
            this.onAccess.run();
        }
    }

    private static final class ListenableBlockDevice
    implements BlockDevice {
        private final BlockDevice inner;
        public final Event onAccess = new Event();

        private ListenableBlockDevice(BlockDevice inner) {
            this.inner = inner;
        }

        public boolean isReadonly() {
            return this.inner.isReadonly();
        }

        public long getCapacity() {
            return this.inner.getCapacity();
        }

        public InputStream getInputStream(long offset) {
            ListenableInputStream stream = new ListenableInputStream(this.inner.getInputStream(offset));
            stream.onAccess.add(this.onAccess);
            return stream;
        }

        public OutputStream getOutputStream(long offset) {
            ListenableOutputStream stream = new ListenableOutputStream(this.inner.getOutputStream(offset));
            stream.onAccess.add(this.onAccess);
            return stream;
        }

        public void flush() {
            this.inner.flush();
        }

        public void close() throws IOException {
            this.inner.close();
        }
    }
}

