/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.bus.device.item;

import java.util.List;
import javax.annotation.Nullable;
import li.cil.oc2.api.bus.device.object.Callback;
import li.cil.oc2.api.bus.device.object.Parameter;
import li.cil.oc2.api.capabilities.Robot;
import li.cil.oc2.api.util.RobotOperationSide;
import li.cil.oc2.common.Config;
import li.cil.oc2.common.bus.device.item.AbstractItemRPCDevice;
import li.cil.oc2.common.tags.ItemTags;
import li.cil.oc2.common.util.FakePlayerUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CommandBlockBlock;
import net.minecraft.block.JigsawBlock;
import net.minecraft.block.StructureBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public final class BlockOperationsModuleDevice
extends AbstractItemRPCDevice {
    private static final String LAST_OPERATION_TAG_NAME = "cooldown";
    private static final int COOLDOWN = 20;
    private final Entity entity;
    private final Robot robot;
    private long lastOperation;

    public BlockOperationsModuleDevice(ItemStack identity, Entity entity, Robot robot) {
        super(identity, "block_operations");
        this.entity = entity;
        this.robot = robot;
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74772_a(LAST_OPERATION_TAG_NAME, this.lastOperation);
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundNBT tag) {
        this.lastOperation = MathHelper.func_226163_a_((long)tag.func_74763_f(LAST_OPERATION_TAG_NAME), (long)0L, (long)this.entity.field_70170_p.func_82737_E());
    }

    @Callback
    public boolean excavate(@Parameter(value="side") @Nullable RobotOperationSide side) {
        if (this.isOnCooldown()) {
            return false;
        }
        this.beginCooldown();
        World level = this.entity.field_70170_p;
        if (!(level instanceof ServerWorld)) {
            return false;
        }
        int selectedSlot = this.robot.getSelectedSlot();
        ItemStackHandler inventory = this.robot.getInventory();
        List<ItemEntity> oldItems = this.getItemsInRange();
        Direction direction = RobotOperationSide.getAdjustedDirection(side, this.entity);
        if (!this.tryHarvestBlock(level, this.entity.func_233580_cy_().func_177972_a(direction))) {
            return false;
        }
        List<ItemEntity> droppedItems = this.getItemsInRange();
        droppedItems.removeAll(oldItems);
        for (ItemEntity itemEntity : droppedItems) {
            ItemStack stack = itemEntity.func_92059_d();
            stack = this.insertStartingAt((IItemHandler)inventory, stack, selectedSlot, false);
            itemEntity.func_92058_a(stack);
        }
        return true;
    }

    @Callback
    public boolean place(@Parameter(value="side") @Nullable RobotOperationSide side) {
        ServerPlayerEntity player;
        BlockItemUseContext context;
        if (this.isOnCooldown()) {
            return false;
        }
        this.beginCooldown();
        World level = this.entity.field_70170_p;
        if (!(level instanceof ServerWorld)) {
            return false;
        }
        int selectedSlot = this.robot.getSelectedSlot();
        ItemStackHandler inventory = this.robot.getInventory();
        ItemStack extracted = inventory.extractItem(selectedSlot, 1, true);
        if (extracted.func_190926_b() || !(extracted.func_77973_b() instanceof BlockItem)) {
            return false;
        }
        Direction direction = RobotOperationSide.getAdjustedDirection(side, this.entity);
        BlockPos blockPos = this.entity.func_233580_cy_().func_177972_a(direction);
        Direction oppositeDirection = direction.func_176734_d();
        BlockRayTraceResult hit = new BlockRayTraceResult(Vector3d.func_237489_a_((Vector3i)blockPos).func_178787_e(Vector3d.func_237489_a_((Vector3i)oppositeDirection.func_176730_m()).func_186678_a(0.5)), oppositeDirection, blockPos, false);
        ItemStack itemStack = extracted.func_77946_l();
        BlockItem blockItem = (BlockItem)itemStack.func_77973_b();
        ActionResultType result = blockItem.func_195942_a(context = new BlockItemUseContext((PlayerEntity)(player = FakePlayerUtils.getFakePlayer((ServerWorld)level, this.entity)), Hand.MAIN_HAND, itemStack, hit));
        if (!result.func_226246_a_()) {
            return false;
        }
        if (itemStack.func_190926_b()) {
            inventory.extractItem(selectedSlot, 1, false);
        }
        return true;
    }

    @Callback(synchronize=false)
    public int durability() {
        return ((ItemStack)this.identity).func_77958_k() - ((ItemStack)this.identity).func_77952_i();
    }

    @Callback
    public boolean repair() {
        if (this.isOnCooldown()) {
            return false;
        }
        this.beginCooldown();
        if (((ItemStack)this.identity).func_77952_i() == 0) {
            return false;
        }
        int selectedSlot = this.robot.getSelectedSlot();
        ItemStackHandler inventory = this.robot.getInventory();
        ItemStack extracted = inventory.extractItem(selectedSlot, 1, true);
        ItemTier tier = this.getRepairItemTier(extracted);
        if (tier == null) {
            return false;
        }
        int repairValue = tier.func_200926_a();
        if (repairValue == 0) {
            return false;
        }
        if (inventory.extractItem(selectedSlot, 1, false).func_190926_b()) {
            return false;
        }
        ((ItemStack)this.identity).func_196085_b(((ItemStack)this.identity).func_77952_i() - repairValue);
        return true;
    }

    private void beginCooldown() {
        this.lastOperation = this.entity.field_70170_p.func_82737_E();
    }

    private boolean isOnCooldown() {
        return this.entity.field_70170_p.func_82737_E() - this.lastOperation < 20L;
    }

    private List<ItemEntity> getItemsInRange() {
        return this.entity.field_70170_p.func_217357_a(ItemEntity.class, this.entity.func_174813_aQ().func_186662_g(2.0));
    }

    private boolean tryHarvestBlock(World world, BlockPos blockPos) {
        boolean canHarvest;
        boolean isCommandBlock;
        BlockState blockState = world.func_180495_p(blockPos);
        if (blockState.isAir((IBlockReader)world, blockPos)) {
            return false;
        }
        ServerPlayerEntity player = FakePlayerUtils.getFakePlayer((ServerWorld)world, this.entity);
        int experience = ForgeHooks.onBlockBreakEvent((World)world, (GameType)GameType.NOT_SET, (ServerPlayerEntity)player, (BlockPos)blockPos);
        if (experience == -1) {
            return false;
        }
        TileEntity tileEntity = world.func_175625_s(blockPos);
        Block block = blockState.func_177230_c();
        boolean bl = isCommandBlock = block instanceof CommandBlockBlock || block instanceof StructureBlock || block instanceof JigsawBlock;
        if (isCommandBlock && !player.func_195070_dx()) {
            return false;
        }
        if (player.func_223729_a(world, blockPos, GameType.NOT_SET)) {
            return false;
        }
        boolean bl2 = canHarvest = Config.blockOperationsModuleToolLevel >= blockState.getHarvestLevel();
        if (!canHarvest) {
            return false;
        }
        if (!ForgeEventFactory.doPlayerHarvestCheck((PlayerEntity)player, (BlockState)blockState, (boolean)canHarvest)) {
            return false;
        }
        if (((ItemStack)this.identity).func_96631_a(1, world.field_73012_v, null)) {
            return false;
        }
        if (!blockState.removedByPlayer(world, blockPos, (PlayerEntity)player, true, world.func_204610_c(blockPos))) {
            return false;
        }
        block.func_176206_d((IWorld)world, blockPos, blockState);
        block.func_180657_a(world, (PlayerEntity)player, blockPos, blockState, tileEntity, ItemStack.field_190927_a);
        return true;
    }

    @Nullable
    private ItemTier getRepairItemTier(ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        Item item = stack.func_77973_b();
        if (ItemTags.TOOL_MATERIAL_NETHERITE.func_230235_a_((Object)item)) {
            return ItemTier.NETHERITE;
        }
        if (ItemTags.TOOL_MATERIAL_GOLD.func_230235_a_((Object)item)) {
            return ItemTier.DIAMOND;
        }
        if (ItemTags.TOOL_MATERIAL_DIAMOND.func_230235_a_((Object)item)) {
            return ItemTier.GOLD;
        }
        if (ItemTags.TOOL_MATERIAL_IRON.func_230235_a_((Object)item)) {
            return ItemTier.IRON;
        }
        if (ItemTags.TOOL_MATERIAL_STONE.func_230235_a_((Object)item)) {
            return ItemTier.STONE;
        }
        if (ItemTags.TOOL_MATERIAL_WOOD.func_230235_a_((Object)item)) {
            return ItemTier.WOOD;
        }
        return null;
    }

    private ItemStack insertStartingAt(IItemHandler handler, ItemStack stack, int startSlot, boolean simulate) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            int slot = (startSlot + i) % handler.getSlots();
            stack = handler.insertItem(slot, stack, simulate);
            if (!stack.func_190926_b()) continue;
            return ItemStack.field_190927_a;
        }
        return stack;
    }
}

