/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.bus.device.item;

import com.google.common.eventbus.Subscribe;
import java.nio.ByteBuffer;
import li.cil.oc2.api.bus.device.ItemDevice;
import li.cil.oc2.api.bus.device.vm.FirmwareLoader;
import li.cil.oc2.api.bus.device.vm.VMDevice;
import li.cil.oc2.api.bus.device.vm.VMDeviceLoadResult;
import li.cil.oc2.api.bus.device.vm.context.VMContext;
import li.cil.oc2.api.bus.device.vm.event.VMInitializationException;
import li.cil.oc2.api.bus.device.vm.event.VMInitializingEvent;
import li.cil.oc2.common.Constants;
import li.cil.oc2.common.bus.device.util.IdentityProxy;
import li.cil.oc2.common.bus.device.util.OptionalAddress;
import li.cil.sedna.api.device.MemoryMappedDevice;
import li.cil.sedna.api.memory.MemoryAccessException;
import li.cil.sedna.api.memory.MemoryMap;
import li.cil.sedna.device.flash.FlashMemoryDevice;
import li.cil.sedna.memory.MemoryMaps;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public final class ByteBufferFlashMemoryVMDevice
extends IdentityProxy<ItemStack>
implements VMDevice,
ItemDevice,
FirmwareLoader {
    public static final String DATA_TAG_NAME = "data";
    private final int size;
    private MemoryMap memoryMap;
    private ByteBuffer data;
    private FlashMemoryDevice device;
    private CompoundNBT deviceTag;
    private final OptionalAddress address = new OptionalAddress();

    public ByteBufferFlashMemoryVMDevice(ItemStack identity, int size) {
        super(identity);
        this.size = size;
    }

    @Override
    public VMDeviceLoadResult mount(VMContext context) {
        if (!this.allocateDevice(context)) {
            return VMDeviceLoadResult.fail();
        }
        if (!this.address.claim(context, (MemoryMappedDevice)this.device)) {
            return VMDeviceLoadResult.fail();
        }
        this.loadPersistedState();
        this.memoryMap = context.getMemoryMap();
        context.getEventBus().register(this);
        return VMDeviceLoadResult.success();
    }

    @Override
    public void unmount() {
        this.suspend();
        this.deviceTag = null;
        this.address.clear();
    }

    @Override
    public void suspend() {
        this.memoryMap = null;
        this.data = null;
        this.device = null;
    }

    @Subscribe
    public void handleInitializingEvent(VMInitializingEvent event) {
        this.copyDataToMemory(event.getProgramStartAddress());
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT tag = new CompoundNBT();
        if (this.device != null) {
            tag.func_74773_a(DATA_TAG_NAME, this.device.getData().array());
        }
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundNBT tag) {
        byte[] data = tag.func_74770_j(DATA_TAG_NAME);
        ByteBuffer bufferData = this.device.getData();
        bufferData.clear();
        bufferData.put(data, 0, Math.min(bufferData.limit(), data.length));
    }

    private boolean allocateDevice(VMContext context) {
        if (!context.getMemoryAllocator().claimMemory(this.size)) {
            return false;
        }
        this.data = ByteBuffer.allocate(this.size);
        this.device = new FlashMemoryDevice(this.data);
        return true;
    }

    private void loadPersistedState() {
        if (this.deviceTag != null) {
            this.data.clear();
            byte[] persistedData = this.deviceTag.func_74770_j(DATA_TAG_NAME);
            this.data.put(persistedData, 0, Math.min(persistedData.length, this.data.capacity()));
        }
    }

    private void copyDataToMemory(long startAddress) {
        ByteBuffer data = this.device.getData();
        data.clear();
        try {
            MemoryMaps.store((MemoryMap)this.memoryMap, (long)startAddress, (ByteBuffer)data);
        }
        catch (MemoryAccessException e) {
            throw new VMInitializationException((ITextComponent)new TranslationTextComponent(Constants.COMPUTER_ERROR_INSUFFICIENT_MEMORY));
        }
    }
}

