/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.bus.device.item;

import com.google.common.eventbus.Subscribe;
import li.cil.oc2.api.bus.device.ItemDevice;
import li.cil.oc2.api.bus.device.data.Firmware;
import li.cil.oc2.api.bus.device.vm.FirmwareLoader;
import li.cil.oc2.api.bus.device.vm.VMDevice;
import li.cil.oc2.api.bus.device.vm.VMDeviceLoadResult;
import li.cil.oc2.api.bus.device.vm.context.VMContext;
import li.cil.oc2.api.bus.device.vm.event.VMInitializationException;
import li.cil.oc2.api.bus.device.vm.event.VMInitializingEvent;
import li.cil.oc2.common.Constants;
import li.cil.oc2.common.bus.device.util.IdentityProxy;
import li.cil.sedna.api.memory.MemoryMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public final class FirmwareFlashMemoryVMDevice
extends IdentityProxy<ItemStack>
implements VMDevice,
ItemDevice,
FirmwareLoader {
    private final Firmware firmware;
    private MemoryMap memoryMap;

    public FirmwareFlashMemoryVMDevice(ItemStack identity, Firmware firmware) {
        super(identity);
        this.firmware = firmware;
    }

    @Override
    public VMDeviceLoadResult mount(VMContext context) {
        this.memoryMap = context.getMemoryMap();
        context.getEventBus().register(this);
        return VMDeviceLoadResult.success();
    }

    @Override
    public void unmount() {
        this.suspend();
    }

    @Override
    public void suspend() {
        this.memoryMap = null;
    }

    @Subscribe
    public void handleInitializingEvent(VMInitializingEvent event) {
        this.copyDataToMemory(event.getProgramStartAddress());
    }

    private void copyDataToMemory(long address) {
        if (!this.firmware.run(this.memoryMap, address)) {
            throw new VMInitializationException((ITextComponent)new TranslationTextComponent(Constants.COMPUTER_ERROR_INSUFFICIENT_MEMORY));
        }
    }
}

