/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.bus.device.item;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.time.Duration;
import java.util.Optional;
import java.util.function.Supplier;
import li.cil.oc2.common.bus.device.item.AbstractBlockDeviceVMDevice;
import li.cil.oc2.common.serialization.BlobStorage;
import li.cil.oc2.common.util.Location;
import li.cil.oc2.common.util.SoundEvents;
import li.cil.oc2.common.util.ThrottledSoundEmitter;
import li.cil.sedna.device.block.ByteBufferBlockDevice;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;

public class HardDriveVMDevice
extends AbstractBlockDeviceVMDevice<ByteBufferBlockDevice, ItemStack> {
    private final int size;
    private final boolean readonly;
    private final ThrottledSoundEmitter soundEmitter;

    public HardDriveVMDevice(ItemStack identity, int size, boolean readonly, Supplier<Optional<Location>> location) {
        super(identity);
        this.size = size;
        this.readonly = readonly;
        this.soundEmitter = new ThrottledSoundEmitter(location, (SoundEvent)SoundEvents.HDD_ACCESS.get()).withMinInterval(Duration.ofSeconds(1L));
    }

    @Override
    protected ByteBufferBlockDevice createBlockDevice() throws IOException {
        this.blobHandle = BlobStorage.validateHandle(this.blobHandle);
        FileChannel channel = BlobStorage.getOrOpen(this.blobHandle);
        MappedByteBuffer buffer = channel.map(FileChannel.MapMode.READ_WRITE, 0L, this.size);
        return ByteBufferBlockDevice.wrap((ByteBuffer)buffer, (boolean)this.readonly);
    }

    @Override
    protected void handleDataAccess() {
        this.soundEmitter.play();
    }
}

