/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.bus.device.item;

import com.google.common.eventbus.Subscribe;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import li.cil.oc2.api.bus.device.vm.event.VMResumingRunningEvent;
import li.cil.oc2.common.bus.device.item.HardDriveVMDevice;
import li.cil.oc2.common.util.Location;
import li.cil.sedna.api.device.BlockDevice;
import li.cil.sedna.device.block.ByteBufferBlockDevice;
import net.minecraft.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class HardDriveVMDeviceWithInitialData
extends HardDriveVMDevice {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ExecutorService WORKERS = Executors.newCachedThreadPool(r -> {
        Thread thread = new Thread(r, "Hard Drive Initializer");
        thread.setDaemon(false);
        return thread;
    });
    private final BlockDevice base;
    private Future<Void> copyJob;

    public HardDriveVMDeviceWithInitialData(ItemStack identity, BlockDevice base, boolean readonly, Supplier<Optional<Location>> location) {
        super(identity, (int)base.getCapacity(), readonly, location);
        this.base = base;
    }

    @Subscribe
    public void handleResumingRunningEvent(VMResumingRunningEvent event) {
        if (this.copyJob != null) {
            try {
                this.copyJob.get();
            }
            catch (Throwable e) {
                LOGGER.error((Object)e);
            }
            finally {
                this.copyJob = null;
            }
        }
    }

    @Override
    protected ByteBufferBlockDevice createBlockDevice() throws IOException {
        boolean isInitializing = this.blobHandle == null;
        ByteBufferBlockDevice device = super.createBlockDevice();
        if (isInitializing) {
            this.copyJob = CompletableFuture.runAsync(() -> {
                try (InputStream input = this.base.getInputStream(0L);
                     OutputStream output = device.getOutputStream(0L);){
                    ByteStreams.copy((InputStream)input, (OutputStream)output);
                }
                catch (IOException e) {
                    LOGGER.error((Object)e);
                }
            }, WORKERS);
        }
        return device;
    }
}

