/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.bus.device.item;

import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import li.cil.oc2.api.bus.device.object.Callback;
import li.cil.oc2.api.bus.device.object.Parameter;
import li.cil.oc2.api.capabilities.Robot;
import li.cil.oc2.api.util.RobotOperationSide;
import li.cil.oc2.common.bus.device.item.AbstractItemRPCDevice;
import li.cil.oc2.common.capabilities.Capabilities;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public final class InventoryOperationsModuleDevice
extends AbstractItemRPCDevice {
    private final Entity entity;
    private final Robot robot;

    public InventoryOperationsModuleDevice(ItemStack identity, Entity entity, Robot robot) {
        super(identity, "inventory_operations");
        this.entity = entity;
        this.robot = robot;
    }

    @Callback
    public void move(@Parameter(value="fromSlot") int fromSlot, @Parameter(value="intoSlot") int intoSlot, @Parameter(value="count") int count) {
        if (count <= 0) {
            return;
        }
        ItemStackHandler inventory = this.robot.getInventory();
        ItemStack extracted = inventory.extractItem(fromSlot, count, true);
        ItemStack remaining = inventory.insertItem(intoSlot, extracted, true);
        extracted = inventory.extractItem(fromSlot, extracted.func_190916_E() - remaining.func_190916_E(), false);
        remaining = inventory.insertItem(intoSlot, extracted, false);
        if (!(remaining = inventory.insertItem(fromSlot, remaining, false)).func_190926_b()) {
            this.entity.func_199701_a_(remaining);
        }
    }

    @Callback
    public int drop(@Parameter(value="count") int count, @Parameter(value="side") @Nullable RobotOperationSide side) {
        IItemHandler handler;
        if (count <= 0) {
            return 0;
        }
        int selectedSlot = this.robot.getSelectedSlot();
        ItemStack stack = this.robot.getInventory().extractItem(selectedSlot, count, false);
        if (stack.func_190926_b()) {
            return 0;
        }
        int originalStackSize = stack.func_190916_E();
        Direction direction = RobotOperationSide.getAdjustedDirection(side, this.entity);
        List itemHandlers = this.getItemStackHandlersInDirection(direction).collect(Collectors.toList());
        Iterator iterator = itemHandlers.iterator();
        while (iterator.hasNext() && !(stack = ItemHandlerHelper.insertItemStacked((IItemHandler)(handler = (IItemHandler)iterator.next()), (ItemStack)stack, (boolean)false)).func_190926_b()) {
        }
        int dropped = originalStackSize - stack.func_190916_E();
        if (!stack.func_190926_b() && !itemHandlers.isEmpty()) {
            stack = this.robot.getInventory().insertItem(selectedSlot, stack, false);
        }
        if (!stack.func_190926_b()) {
            dropped += stack.func_190916_E();
            this.entity.func_199701_a_(stack);
        }
        return dropped;
    }

    @Callback
    public int dropInto(@Parameter(value="intoSlot") int intoSlot, @Parameter(value="count") int count, @Parameter(value="side") @Nullable RobotOperationSide side) {
        if (count <= 0) {
            return 0;
        }
        int selectedSlot = this.robot.getSelectedSlot();
        ItemStack stack = this.robot.getInventory().extractItem(selectedSlot, count, false);
        if (stack.func_190926_b()) {
            return 0;
        }
        int originalStackSize = stack.func_190916_E();
        Direction direction = RobotOperationSide.getAdjustedDirection(side, this.entity);
        Optional<IItemHandler> optional = this.getItemStackHandlersInDirection(direction).findFirst();
        if (optional.isPresent()) {
            stack = optional.get().insertItem(intoSlot, stack, false);
        }
        int dropped = originalStackSize - stack.func_190916_E();
        if (!stack.func_190926_b()) {
            stack = this.robot.getInventory().insertItem(selectedSlot, stack, false);
        }
        if (!stack.func_190926_b()) {
            dropped += stack.func_190916_E();
            this.entity.func_199701_a_(stack);
        }
        return dropped;
    }

    @Callback
    public int take(@Parameter(value="count") int count, @Parameter(value="side") @Nullable RobotOperationSide side) {
        if (count <= 0) {
            return 0;
        }
        Direction direction = RobotOperationSide.getAdjustedDirection(side, this.entity);
        List<IItemHandler> handlers = this.getItemStackHandlersInDirection(direction).collect(Collectors.toList());
        if (handlers.isEmpty()) {
            return this.takeFromWorld(count);
        }
        return this.takeFromInventories(count, handlers);
    }

    @Callback
    public int takeFrom(@Parameter(value="fromSlot") int fromSlot, @Parameter(value="count") int count, @Parameter(value="side") @Nullable RobotOperationSide side) {
        if (count <= 0) {
            return 0;
        }
        Direction direction = RobotOperationSide.getAdjustedDirection(side, this.entity);
        return this.getItemStackHandlersInDirection(direction).findFirst().map(handler -> this.takeFromInventory(count, (IItemHandler)handler, fromSlot)).orElse(0);
    }

    private ItemStack insertStartingAt(IItemHandler handler, ItemStack stack, int startSlot, boolean simulate) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            int slot = (startSlot + i) % handler.getSlots();
            stack = handler.insertItem(slot, stack, simulate);
            if (!stack.func_190926_b()) continue;
            return ItemStack.field_190927_a;
        }
        return stack;
    }

    private Stream<IItemHandler> getItemStackHandlersInDirection(Direction direction) {
        return this.getItemStackHandlersAt(Vector3d.func_237489_a_((Vector3i)this.entity.func_233580_cy_().func_177972_a(direction)), direction.func_176734_d());
    }

    private Stream<IItemHandler> getItemStackHandlersAt(Vector3d position, Direction side) {
        return Stream.concat(this.getEntityItemHandlersAt(position, side), this.getBlockItemHandlersAt(position, side));
    }

    private Stream<IItemHandler> getEntityItemHandlersAt(Vector3d position, Direction side) {
        AxisAlignedBB bounds = AxisAlignedBB.func_241549_a_((Vector3d)position.func_178786_a(0.5, 0.5, 0.5));
        return this.entity.field_70170_p.func_72839_b(this.entity, bounds).stream().map(e -> e.getCapability(Capabilities.ITEM_HANDLER, side)).filter(LazyOptional::isPresent).map(c -> (IItemHandler)c.orElseThrow(AssertionError::new));
    }

    private Stream<IItemHandler> getBlockItemHandlersAt(Vector3d position, Direction side) {
        BlockPos pos = new BlockPos(position);
        TileEntity tileEntity = this.entity.field_70170_p.func_175625_s(pos);
        if (tileEntity == null) {
            return Stream.empty();
        }
        LazyOptional capability = tileEntity.getCapability(Capabilities.ITEM_HANDLER, side);
        if (capability.isPresent()) {
            return Stream.of(capability.orElseThrow(AssertionError::new));
        }
        return Stream.empty();
    }

    private List<ItemEntity> getItemsInRange() {
        return this.entity.field_70170_p.func_217357_a(ItemEntity.class, this.entity.func_174813_aQ().func_186662_g(1.0));
    }

    private int takeFromWorld(int count) {
        int selectedSlot = this.robot.getSelectedSlot();
        ItemStackHandler inventory = this.robot.getInventory();
        int remaining = count;
        for (ItemEntity itemEntity : this.getItemsInRange()) {
            ItemStack original = itemEntity.func_92059_d().func_77946_l();
            ItemStack stackToInsert = original.func_77946_l();
            if (stackToInsert.func_190916_E() > remaining) {
                stackToInsert.func_190920_e(remaining);
            }
            ItemStack overflow = this.insertStartingAt((IItemHandler)inventory, stackToInsert, selectedSlot, false);
            int taken = stackToInsert.func_190916_E() - overflow.func_190916_E();
            remaining -= taken;
            original.func_190918_g(taken);
            itemEntity.func_92058_a(original);
        }
        return count - remaining;
    }

    private int takeFromInventories(int count, List<IItemHandler> handlers) {
        int selectedSlot = this.robot.getSelectedSlot();
        ItemStackHandler inventory = this.robot.getInventory();
        int remaining = count;
        for (IItemHandler handler : handlers) {
            for (int fromSlot = 0; fromSlot < handler.getSlots(); ++fromSlot) {
                ItemStack extracted = handler.extractItem(fromSlot, remaining, true);
                ItemStack overflow = this.insertStartingAt((IItemHandler)inventory, extracted, selectedSlot, true);
                int delta = extracted.func_190916_E() - overflow.func_190916_E();
                if (delta == 0) continue;
                remaining -= delta;
                extracted = handler.extractItem(fromSlot, delta, false);
                overflow = this.insertStartingAt((IItemHandler)inventory, extracted, selectedSlot, false);
                remaining += overflow.func_190916_E();
                if ((overflow = handler.insertItem(fromSlot, overflow, false)).func_190926_b()) continue;
                remaining -= overflow.func_190916_E();
                this.entity.func_199701_a_(overflow);
            }
            if (remaining > 0) continue;
            break;
        }
        return count - remaining;
    }

    private int takeFromInventory(int count, IItemHandler handler, int slot) {
        ItemStackHandler inventory = this.robot.getInventory();
        int selectedSlot = this.robot.getSelectedSlot();
        ItemStack extracted = handler.extractItem(slot, count, true);
        ItemStack overflow = this.insertStartingAt((IItemHandler)inventory, extracted, selectedSlot, true);
        int taken = extracted.func_190916_E() - overflow.func_190916_E();
        extracted = handler.extractItem(slot, taken, false);
        overflow = this.insertStartingAt((IItemHandler)inventory, extracted, selectedSlot, false);
        taken -= overflow.func_190916_E();
        if (!(overflow = handler.insertItem(slot, overflow, false)).func_190926_b()) {
            this.entity.func_199701_a_(overflow);
        }
        return taken;
    }
}

