/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.bus.device.item;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.UUID;
import li.cil.oc2.api.bus.device.ItemDevice;
import li.cil.oc2.api.bus.device.vm.VMDevice;
import li.cil.oc2.api.bus.device.vm.VMDeviceLoadResult;
import li.cil.oc2.api.bus.device.vm.context.VMContext;
import li.cil.oc2.common.Constants;
import li.cil.oc2.common.bus.device.util.IdentityProxy;
import li.cil.oc2.common.bus.device.util.OptionalAddress;
import li.cil.oc2.common.serialization.BlobStorage;
import li.cil.sedna.api.device.MemoryMappedDevice;
import li.cil.sedna.api.device.PhysicalMemory;
import li.cil.sedna.device.memory.ByteBufferMemory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class MemoryDevice
extends IdentityProxy<ItemStack>
implements VMDevice,
ItemDevice {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String BLOB_HANDLE_TAG_NAME = "blob";
    private static final String ADDRESS_TAG_NAME = "address";
    private final int size;
    private PhysicalMemory device;
    private final OptionalAddress address = new OptionalAddress();
    private UUID blobHandle;

    public MemoryDevice(ItemStack identity, int capacity) {
        super(identity);
        this.size = capacity;
    }

    @Override
    public VMDeviceLoadResult mount(VMContext context) {
        if (!this.allocateDevice(context)) {
            return VMDeviceLoadResult.fail();
        }
        if (!this.address.claim(context, (MemoryMappedDevice)this.device)) {
            return VMDeviceLoadResult.fail();
        }
        context.getEventBus().register(this);
        return VMDeviceLoadResult.success();
    }

    @Override
    public void unmount() {
        this.suspend();
        if (this.blobHandle != null) {
            BlobStorage.delete(this.blobHandle);
            this.blobHandle = null;
        }
        this.address.clear();
    }

    @Override
    public void suspend() {
        if (this.device != null) {
            try {
                this.device.close();
            }
            catch (Exception e) {
                LOGGER.error((Object)e);
            }
        }
        if (this.blobHandle != null) {
            BlobStorage.close(this.blobHandle);
        }
        this.device = null;
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT tag = new CompoundNBT();
        if (this.blobHandle != null) {
            tag.func_186854_a(BLOB_HANDLE_TAG_NAME, this.blobHandle);
        }
        if (this.address.isPresent()) {
            tag.func_74772_a(ADDRESS_TAG_NAME, this.address.getAsLong());
        }
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundNBT tag) {
        if (tag.func_186855_b(BLOB_HANDLE_TAG_NAME)) {
            this.blobHandle = tag.func_186857_a(BLOB_HANDLE_TAG_NAME);
        }
        if (tag.func_150297_b(ADDRESS_TAG_NAME, 4)) {
            this.address.set(tag.func_74763_f(ADDRESS_TAG_NAME));
        }
    }

    private boolean allocateDevice(VMContext context) {
        if (!context.getMemoryAllocator().claimMemory(Constants.PAGE_SIZE)) {
            return false;
        }
        try {
            this.blobHandle = BlobStorage.validateHandle(this.blobHandle);
            FileChannel channel = BlobStorage.getOrOpen(this.blobHandle);
            MappedByteBuffer buffer = channel.map(FileChannel.MapMode.READ_WRITE, 0L, this.size);
            this.device = new ByteBufferMemory((ByteBuffer)buffer);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }
}

