/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.bus.device.item;

import com.google.common.eventbus.Subscribe;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import li.cil.oc2.api.bus.device.ItemDevice;
import li.cil.oc2.api.bus.device.vm.VMDevice;
import li.cil.oc2.api.bus.device.vm.VMDeviceLoadResult;
import li.cil.oc2.api.bus.device.vm.context.VMContext;
import li.cil.oc2.api.bus.device.vm.event.VMPausingEvent;
import li.cil.oc2.api.bus.device.vm.event.VMResumingRunningEvent;
import li.cil.oc2.api.capabilities.NetworkInterface;
import li.cil.oc2.common.bus.device.util.IdentityProxy;
import li.cil.oc2.common.bus.device.util.OptionalAddress;
import li.cil.oc2.common.bus.device.util.OptionalInterrupt;
import li.cil.oc2.common.capabilities.Capabilities;
import li.cil.oc2.common.serialization.NBTSerialization;
import li.cil.sedna.api.device.MemoryMappedDevice;
import li.cil.sedna.device.virtio.VirtIONetworkDevice;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public final class NetworkInterfaceCardItemDevice
extends IdentityProxy<ItemStack>
implements VMDevice,
ItemDevice,
ICapabilityProvider {
    private static final String DEVICE_TAG_NAME = "device";
    private static final String ADDRESS_TAG_NAME = "address";
    private static final String INTERRUPT_TAG_NAME = "interrupt";
    private VirtIONetworkDevice device;
    private final NetworkInterface networkInterface = new NetworkInterfaceImpl();
    private boolean isRunning;
    private final OptionalAddress address = new OptionalAddress();
    private final OptionalInterrupt interrupt = new OptionalInterrupt();
    private CompoundNBT deviceTag;

    public NetworkInterfaceCardItemDevice(ItemStack identity) {
        super(identity);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == Capabilities.NETWORK_INTERFACE && side != null) {
            return LazyOptional.of(() -> this.networkInterface).cast();
        }
        return LazyOptional.empty();
    }

    @Override
    public VMDeviceLoadResult mount(VMContext context) {
        this.device = new VirtIONetworkDevice(context.getMemoryMap());
        if (!this.address.claim(context, (MemoryMappedDevice)this.device)) {
            return VMDeviceLoadResult.fail();
        }
        if (!this.interrupt.claim(context)) {
            return VMDeviceLoadResult.fail();
        }
        this.device.getInterrupt().set(this.interrupt.getAsInt(), context.getInterruptController());
        if (this.deviceTag != null) {
            NBTSerialization.deserialize(this.deviceTag, this.device);
        }
        context.getEventBus().register(this);
        return VMDeviceLoadResult.success();
    }

    @Override
    public void unmount() {
        this.suspend();
        this.isRunning = false;
        this.address.clear();
        this.interrupt.clear();
    }

    @Override
    public void suspend() {
        this.device = null;
    }

    @Subscribe
    public void handlePausingEvent(VMPausingEvent event) {
        this.isRunning = false;
    }

    @Subscribe
    public void handleResumingRunningEvent(VMResumingRunningEvent event) {
        this.isRunning = true;
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT tag = new CompoundNBT();
        if (this.device != null) {
            this.deviceTag = NBTSerialization.serialize(this.device);
        }
        if (this.deviceTag != null) {
            tag.func_218657_a(DEVICE_TAG_NAME, (INBT)this.deviceTag);
        }
        if (this.address.isPresent()) {
            tag.func_74772_a(ADDRESS_TAG_NAME, this.address.getAsLong());
        }
        if (this.interrupt.isPresent()) {
            tag.func_74768_a(INTERRUPT_TAG_NAME, this.interrupt.getAsInt());
        }
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundNBT tag) {
        if (tag.func_150297_b(DEVICE_TAG_NAME, 10)) {
            this.deviceTag = tag.func_74775_l(DEVICE_TAG_NAME);
        }
        if (tag.func_150297_b(ADDRESS_TAG_NAME, 4)) {
            this.address.set(tag.func_74763_f(ADDRESS_TAG_NAME));
        }
        if (tag.func_150297_b(INTERRUPT_TAG_NAME, 3)) {
            this.interrupt.set(tag.func_74762_e(INTERRUPT_TAG_NAME));
        }
    }

    private final class NetworkInterfaceImpl
    implements NetworkInterface {
        private NetworkInterfaceImpl() {
        }

        @Override
        public byte[] readEthernetFrame() {
            if (NetworkInterfaceCardItemDevice.this.device != null && NetworkInterfaceCardItemDevice.this.isRunning) {
                return NetworkInterfaceCardItemDevice.this.device.readEthernetFrame();
            }
            return null;
        }

        @Override
        public void writeEthernetFrame(NetworkInterface source, byte[] frame, int timeToLive) {
            if (NetworkInterfaceCardItemDevice.this.device != null && NetworkInterfaceCardItemDevice.this.isRunning) {
                NetworkInterfaceCardItemDevice.this.device.writeEthernetFrame(frame);
            }
        }
    }
}

