/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.bus.device.item;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import li.cil.oc2.api.bus.device.object.Callback;
import li.cil.oc2.api.bus.device.object.DocumentedDevice;
import li.cil.oc2.api.bus.device.object.Parameter;
import li.cil.oc2.api.capabilities.RedstoneEmitter;
import li.cil.oc2.api.util.Side;
import li.cil.oc2.common.Constants;
import li.cil.oc2.common.bus.device.item.AbstractItemRPCDevice;
import li.cil.oc2.common.capabilities.Capabilities;
import li.cil.oc2.common.util.HorizontalBlockUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public final class RedstoneInterfaceCardItemDevice
extends AbstractItemRPCDevice
implements DocumentedDevice,
ICapabilityProvider {
    private static final String OUTPUT_TAG_NAME = "output";
    private static final String GET_REDSTONE_INPUT = "getRedstoneInput";
    private static final String GET_REDSTONE_OUTPUT = "getRedstoneOutput";
    private static final String SET_REDSTONE_OUTPUT = "setRedstoneOutput";
    private static final String SIDE = "side";
    private static final String VALUE = "value";
    private final TileEntity tileEntity;
    private final RedstoneEmitter[] capabilities;
    private final byte[] output = new byte[Constants.BLOCK_FACE_COUNT];

    public RedstoneInterfaceCardItemDevice(ItemStack identity, TileEntity tileEntity) {
        super(identity, "redstone");
        this.tileEntity = tileEntity;
        this.capabilities = new RedstoneEmitter[Constants.BLOCK_FACE_COUNT];
        for (int i = 0; i < Constants.BLOCK_FACE_COUNT; ++i) {
            int indexForClosure = i;
            this.capabilities[i] = () -> this.output[indexForClosure];
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
        if (capability == Capabilities.REDSTONE_EMITTER && side != null) {
            return LazyOptional.of(() -> this.capabilities[side.func_176745_a()]).cast();
        }
        return LazyOptional.empty();
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74773_a(OUTPUT_TAG_NAME, this.output);
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundNBT tag) {
        byte[] serializedOutput = tag.func_74770_j(OUTPUT_TAG_NAME);
        System.arraycopy(serializedOutput, 0, this.output, 0, Math.min(serializedOutput.length, this.output.length));
    }

    @Callback(name="getRedstoneInput")
    public int getRedstoneInput(@Parameter(value="side") @Nullable Side side) {
        if (side == null) {
            throw new IllegalArgumentException();
        }
        World world = this.tileEntity.func_145831_w();
        if (world == null) {
            return 0;
        }
        BlockPos pos = this.tileEntity.func_174877_v();
        Direction direction = HorizontalBlockUtils.toGlobal(this.tileEntity.func_195044_w(), side);
        assert (direction != null);
        BlockPos neighborPos = pos.func_177972_a(direction);
        ChunkPos chunkPos = new ChunkPos(neighborPos.func_177958_n(), neighborPos.func_177952_p());
        if (!world.func_217354_b(chunkPos.field_77276_a, chunkPos.field_77275_b)) {
            return 0;
        }
        return world.func_175651_c(neighborPos, direction);
    }

    @Callback(name="getRedstoneOutput", synchronize=false)
    public int getRedstoneOutput(@Parameter(value="side") @Nullable Side side) {
        if (side == null) {
            throw new IllegalArgumentException();
        }
        return this.output[side.get3DDataValue()];
    }

    @Callback(name="setRedstoneOutput")
    public void setRedstoneOutput(@Parameter(value="side") @Nullable Side side, @Parameter(value="value") int value) {
        if (side == null) {
            throw new IllegalArgumentException();
        }
        byte clampedValue = (byte)MathHelper.func_76125_a((int)value, (int)0, (int)15);
        if (clampedValue == this.output[side.get3DDataValue()]) {
            return;
        }
        this.output[side.get3DDataValue()] = clampedValue;
        Direction direction = HorizontalBlockUtils.toGlobal(this.tileEntity.func_195044_w(), side);
        if (direction != null) {
            this.notifyNeighbor(direction);
        }
    }

    @Override
    public void getDeviceDocumentation(DocumentedDevice.DeviceVisitor visitor) {
        visitor.visitCallback(GET_REDSTONE_INPUT).description("Get the current redstone level received on the specified side. Note that if the current output level on the specified side is not zero, this will affect the measured level.\nSides may be specified by name or zero-based index. Please note thatthe side depends on the orientation of the device's container.").returnValueDescription("the current received level on the specified side.").parameterDescription(SIDE, "the side to read the input level from.");
        visitor.visitCallback(GET_REDSTONE_OUTPUT).description("Get the current redstone level transmitted on the specified side. This will return the value last set via setRedstoneOutput().\nSides may be specified by name or zero-based index. Please note thatthe side depends on the orientation of the device's container.").returnValueDescription("the current transmitted level on the specified side.").parameterDescription(SIDE, "the side to read the output level from.");
        visitor.visitCallback(SET_REDSTONE_OUTPUT).description("Set the new redstone level transmitted on the specified side.\nSides may be specified by name or zero-based index. Please note thatthe side depends on the orientation of the device's container.").parameterDescription(SIDE, "the side to write the output level to.").parameterDescription(VALUE, "the output level to set, will be clamped to [0, 15].");
    }

    private void notifyNeighbor(Direction direction) {
        World world = this.tileEntity.func_145831_w();
        if (world == null) {
            return;
        }
        world.func_195593_d(this.tileEntity.func_174877_v(), this.tileEntity.func_195044_w().func_177230_c());
        world.func_195593_d(this.tileEntity.func_174877_v().func_177972_a(direction), this.tileEntity.func_195044_w().func_177230_c());
    }
}

