/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.bus.device.provider.item;

import java.util.Optional;
import li.cil.oc2.api.bus.device.ItemDevice;
import li.cil.oc2.api.bus.device.provider.ItemDeviceQuery;
import li.cil.oc2.api.capabilities.TerminalUserProvider;
import li.cil.oc2.common.Config;
import li.cil.oc2.common.bus.device.item.FileImportExportCardItemDevice;
import li.cil.oc2.common.bus.device.provider.util.AbstractItemDeviceProvider;
import li.cil.oc2.common.capabilities.Capabilities;
import li.cil.oc2.common.item.Items;
import net.minecraftforge.common.util.LazyOptional;

public final class FileImportExportCardItemDeviceProvider
extends AbstractItemDeviceProvider {
    public FileImportExportCardItemDeviceProvider() {
        super(Items.FILE_IMPORT_EXPORT_CARD);
    }

    @Override
    protected boolean matches(ItemDeviceQuery query) {
        return super.matches(query) && this.getTerminalUserProvider(query).isPresent();
    }

    @Override
    protected Optional<ItemDevice> getItemDevice(ItemDeviceQuery query) {
        return this.getTerminalUserProvider(query).map(provider -> new FileImportExportCardItemDevice(query.getItemStack(), (TerminalUserProvider)provider));
    }

    @Override
    protected int getItemDeviceEnergyConsumption(ItemDeviceQuery query) {
        return Config.fileImportExportCardEnergyPerTick;
    }

    private Optional<TerminalUserProvider> getTerminalUserProvider(ItemDeviceQuery query) {
        LazyOptional capability;
        if (query.getContainerTileEntity().isPresent() && (capability = query.getContainerTileEntity().get().getCapability(Capabilities.TERMINAL_USER_PROVIDER)).isPresent()) {
            return capability.resolve();
        }
        if (query.getContainerEntity().isPresent() && (capability = query.getContainerEntity().get().getCapability(Capabilities.TERMINAL_USER_PROVIDER)).isPresent()) {
            return capability.resolve();
        }
        return Optional.empty();
    }
}

