/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.bus.device.provider.item;

import java.util.Optional;
import li.cil.oc2.api.bus.device.DeviceType;
import li.cil.oc2.api.bus.device.DeviceTypes;
import li.cil.oc2.api.bus.device.ItemDevice;
import li.cil.oc2.api.bus.device.provider.ItemDeviceQuery;
import li.cil.oc2.common.Config;
import li.cil.oc2.common.bus.device.item.HardDriveVMDevice;
import li.cil.oc2.common.bus.device.provider.util.AbstractItemDeviceProvider;
import li.cil.oc2.common.item.HardDriveItem;
import li.cil.oc2.common.util.LocationSupplierUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;

public final class HardDriveItemDeviceProvider
extends AbstractItemDeviceProvider {
    public HardDriveItemDeviceProvider() {
        super(HardDriveItem.class);
    }

    @Override
    protected Optional<ItemDevice> getItemDevice(ItemDeviceQuery query) {
        return Optional.of(new HardDriveVMDevice(query.getItemStack(), HardDriveItemDeviceProvider.getCapacity(query), false, LocationSupplierUtils.of(query)));
    }

    @Override
    protected Optional<DeviceType> getItemDeviceType(ItemDeviceQuery query) {
        return Optional.of(DeviceTypes.HARD_DRIVE);
    }

    @Override
    protected int getItemDeviceEnergyConsumption(ItemDeviceQuery query) {
        return Math.max(1, (int)Math.round((double)HardDriveItemDeviceProvider.getCapacity(query) * Config.hardDriveEnergyPerMegabytePerTick / 1048576.0));
    }

    private static int getCapacity(ItemDeviceQuery query) {
        ItemStack stack = query.getItemStack();
        HardDriveItem item = (HardDriveItem)stack.func_77973_b();
        return MathHelper.func_76125_a((int)item.getCapacity(stack), (int)0, (int)Config.maxHardDriveSize);
    }
}

