/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.bus.device.provider.item;

import java.util.Optional;
import li.cil.oc2.api.bus.device.DeviceType;
import li.cil.oc2.api.bus.device.DeviceTypes;
import li.cil.oc2.api.bus.device.ItemDevice;
import li.cil.oc2.api.bus.device.data.BlockDeviceData;
import li.cil.oc2.api.bus.device.provider.ItemDeviceQuery;
import li.cil.oc2.common.Config;
import li.cil.oc2.common.bus.device.item.HardDriveVMDeviceWithInitialData;
import li.cil.oc2.common.bus.device.provider.util.AbstractItemDeviceProvider;
import li.cil.oc2.common.item.HardDriveWithExternalDataItem;
import li.cil.oc2.common.util.LocationSupplierUtils;
import net.minecraft.item.ItemStack;

public final class HardDriveWithExternalDataItemDeviceProvider
extends AbstractItemDeviceProvider {
    public HardDriveWithExternalDataItemDeviceProvider() {
        super(HardDriveWithExternalDataItem.class);
    }

    @Override
    protected Optional<ItemDevice> getItemDevice(ItemDeviceQuery query) {
        ItemStack stack = query.getItemStack();
        HardDriveWithExternalDataItem item = (HardDriveWithExternalDataItem)stack.func_77973_b();
        BlockDeviceData data = item.getData(stack);
        if (data == null) {
            return Optional.empty();
        }
        return Optional.of(new HardDriveVMDeviceWithInitialData(stack, data.getBlockDevice(), false, LocationSupplierUtils.of(query)));
    }

    @Override
    protected Optional<DeviceType> getItemDeviceType(ItemDeviceQuery query) {
        return Optional.of(DeviceTypes.HARD_DRIVE);
    }

    @Override
    protected int getItemDeviceEnergyConsumption(ItemDeviceQuery query) {
        ItemStack stack = query.getItemStack();
        HardDriveWithExternalDataItem item = (HardDriveWithExternalDataItem)stack.func_77973_b();
        BlockDeviceData data = item.getData(stack);
        if (data == null) {
            return 0;
        }
        long capacity = Math.min(data.getBlockDevice().getCapacity(), (long)Math.max(0, Config.maxHardDriveSize));
        return Math.max(1, (int)Math.round((double)capacity * Config.hardDriveEnergyPerMegabytePerTick / 1048576.0));
    }
}

