/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.bus.device.provider.item;

import java.util.Optional;
import li.cil.oc2.api.bus.device.DeviceType;
import li.cil.oc2.api.bus.device.DeviceTypes;
import li.cil.oc2.api.bus.device.ItemDevice;
import li.cil.oc2.api.bus.device.provider.ItemDeviceQuery;
import li.cil.oc2.common.Config;
import li.cil.oc2.common.bus.device.item.MemoryDevice;
import li.cil.oc2.common.bus.device.provider.util.AbstractItemDeviceProvider;
import li.cil.oc2.common.item.MemoryItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;

public final class MemoryItemDeviceProvider
extends AbstractItemDeviceProvider {
    public MemoryItemDeviceProvider() {
        super(MemoryItem.class);
    }

    @Override
    protected Optional<ItemDevice> getItemDevice(ItemDeviceQuery query) {
        ItemStack stack = query.getItemStack();
        MemoryItem item = (MemoryItem)stack.func_77973_b();
        int capacity = MathHelper.func_76125_a((int)item.getCapacity(stack), (int)0, (int)Config.maxMemorySize);
        return Optional.of(new MemoryDevice(query.getItemStack(), capacity));
    }

    @Override
    protected Optional<DeviceType> getItemDeviceType(ItemDeviceQuery query) {
        return Optional.of(DeviceTypes.MEMORY);
    }

    @Override
    protected int getItemDeviceEnergyConsumption(ItemDeviceQuery query) {
        ItemStack stack = query.getItemStack();
        MemoryItem item = (MemoryItem)stack.func_77973_b();
        int capacity = MathHelper.func_76125_a((int)item.getCapacity(stack), (int)0, (int)Config.maxMemorySize);
        return Math.max(1, (int)Math.round((double)capacity * Config.memoryEnergyPerMegabytePerTick / 1048576.0));
    }
}

