/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.bus.device.provider.util;

import java.util.Optional;
import java.util.function.Predicate;
import li.cil.oc2.api.bus.device.DeviceType;
import li.cil.oc2.api.bus.device.DeviceTypes;
import li.cil.oc2.api.bus.device.ItemDevice;
import li.cil.oc2.api.bus.device.provider.ItemDeviceProvider;
import li.cil.oc2.api.bus.device.provider.ItemDeviceQuery;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.ForgeRegistryEntry;

public abstract class AbstractItemDeviceProvider
extends ForgeRegistryEntry<ItemDeviceProvider>
implements ItemDeviceProvider {
    private final Predicate<Item> predicate;

    private AbstractItemDeviceProvider(Predicate<Item> predicate) {
        this.predicate = predicate;
    }

    protected AbstractItemDeviceProvider(RegistryObject<? extends Item> item) {
        this((Item i) -> i == item.get());
    }

    protected AbstractItemDeviceProvider(Class<? extends Item> type) {
        this(type::isInstance);
    }

    protected AbstractItemDeviceProvider() {
        this.predicate = i -> true;
    }

    @Override
    public final Optional<ItemDevice> getDevice(ItemDeviceQuery query) {
        return this.matches(query) ? this.getItemDevice(query) : Optional.empty();
    }

    @Override
    public final Optional<DeviceType> getDeviceType(ItemDeviceQuery query) {
        return this.matches(query) ? this.getItemDeviceType(query) : Optional.empty();
    }

    @Override
    public final int getEnergyConsumption(ItemDeviceQuery query) {
        return this.matches(query) ? this.getItemDeviceEnergyConsumption(query) : 0;
    }

    protected boolean matches(ItemDeviceQuery query) {
        ItemStack stack = query.getItemStack();
        return !stack.func_190926_b() && this.predicate.test(stack.func_77973_b());
    }

    protected abstract Optional<ItemDevice> getItemDevice(ItemDeviceQuery var1);

    protected Optional<DeviceType> getItemDeviceType(ItemDeviceQuery query) {
        return Optional.of(DeviceTypes.CARD);
    }

    protected int getItemDeviceEnergyConsumption(ItemDeviceQuery query) {
        return 0;
    }
}

