/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.bus.device.provider.util;

import java.util.function.Supplier;
import li.cil.oc2.api.bus.device.Device;
import li.cil.oc2.api.bus.device.provider.BlockDeviceQuery;
import li.cil.oc2.common.bus.device.provider.util.AbstractTileEntityDeviceProvider;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public abstract class AbstractTileEntityCapabilityDeviceProvider<TCapability, TTileEntity extends TileEntity>
extends AbstractTileEntityDeviceProvider<TTileEntity> {
    private final Supplier<Capability<TCapability>> capabilitySupplier;

    protected AbstractTileEntityCapabilityDeviceProvider(TileEntityType<TTileEntity> tileEntityType, Supplier<Capability<TCapability>> capabilitySupplier) {
        super(tileEntityType);
        this.capabilitySupplier = capabilitySupplier;
    }

    protected AbstractTileEntityCapabilityDeviceProvider(Supplier<Capability<TCapability>> capabilitySupplier) {
        this.capabilitySupplier = capabilitySupplier;
    }

    @Override
    protected final LazyOptional<Device> getBlockDevice(BlockDeviceQuery blockQuery, TileEntity tileEntity) {
        Capability<TCapability> capability = this.capabilitySupplier.get();
        if (capability == null) {
            throw new IllegalStateException();
        }
        LazyOptional optional = tileEntity.getCapability(capability, blockQuery.getQuerySide());
        if (!optional.isPresent()) {
            return LazyOptional.empty();
        }
        Object value = optional.orElseThrow(AssertionError::new);
        LazyOptional<Device> device = this.getBlockDevice(blockQuery, (TCapability)value);
        optional.addListener(ignored -> device.invalidate());
        return device;
    }

    @Override
    protected abstract LazyOptional<Device> getBlockDevice(BlockDeviceQuery var1, TCapability var2);
}

