/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.bus.device.rpc;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;

public final class RPCItemStackTagFilter {
    public ResourceLocation item;
    public String[] tags;
    private String[][] paths;

    @Nullable
    public CompoundNBT apply(ItemStack stack, CompoundNBT tag) {
        if (stack.func_190926_b() || this.tags == null) {
            return null;
        }
        if (this.item != null && !Objects.equals(stack.func_77973_b().getRegistryName(), this.item)) {
            return null;
        }
        this.validatePaths();
        CompoundNBT filtered = new CompoundNBT();
        for (String[] path : this.paths) {
            CompoundNBT filteredByPath = this.filterPath(path, tag);
            if (filteredByPath == null) continue;
            filtered.func_197643_a(filteredByPath);
        }
        return filtered;
    }

    @Nullable
    private CompoundNBT filterPath(String[] path, CompoundNBT source) {
        if (path.length == 0) {
            return null;
        }
        CompoundNBT result = new CompoundNBT();
        CompoundNBT currentSource = source;
        CompoundNBT currentTarget = result;
        for (int j = 0; j < path.length - 1; ++j) {
            String segment = path[j];
            if (!currentSource.func_150297_b(segment, 10)) {
                return null;
            }
            currentSource = currentSource.func_74775_l(segment);
            currentTarget.func_218657_a(segment, (INBT)new CompoundNBT());
            currentTarget = currentTarget.func_74775_l(segment);
        }
        if (!currentSource.func_74764_b(path[path.length - 1])) {
            return null;
        }
        currentTarget.func_218657_a(path[path.length - 1], currentSource.func_74781_a(path[path.length - 1]));
        return result;
    }

    private void validatePaths() {
        this.paths = new String[this.tags.length][];
        for (int i = 0; i < this.tags.length; ++i) {
            if (StringUtils.func_151246_b((String)this.tags[i])) continue;
            this.paths[i] = this.tags[i].split("\\.");
        }
    }
}

